% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Query.R
\name{writeResults}
\alias{writeResults}
\alias{writeResults,Query-method}
\title{Write query results to a file.}
\usage{
writeResults(.Object, model, ...)

\S4method{writeResults}{Query}(
  .Object,
  model,
  file,
  mimeType = "application/x-turtle",
  format_uri = NULL,
  base_uri = NULL
)
}
\arguments{
\item{.Object}{a Query object}

\item{model}{a Model object}

\item{...}{additional parameters}

\item{file}{a string specifying the output file}

\item{mimeType}{a string specifying the mimeType of the output file. Currently supported values are "application/x-turtle", "text/plain", "application/json", "text/html"}

\item{format_uri}{(not currently used)}

\item{base_uri}{(not currently used)}
}
\description{
Write query results to a file.
}
\details{
After this method is called, the Query object is no longer usable and should
be deleted \code{"rm(query)"} and a new object created.
}
\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
stmt <- new("Statement", world=world, 
  subject="https://orcid.org/0000-0002-2192-403X",
  predicate="http://www.w3.org/ns/prov#Agent",
  object="slaughter", 
  objectType="literal", datatype_uri="http://www.w3.org/2001/XMLSchema#string")
status <- addStatement(model, stmt)
queryString <- paste("PREFIX orcid: <https://orcid.org/>",
                     "PREFIX dataone: <https://cn.dataone.org/cn/v1/resolve/>",
                     "PREFIX prov: <http://www.w3.org/ns/prov#>",
                     "SELECT ?a ?c WHERE { ?a prov:Agent ?c . }", sep=" ")
query <- new("Query", world, queryString, base_uri=NULL, query_language="sparql", query_uri=NULL)
# Return all results as a string
tf <- tempfile()
writeResults(query, model, file=tf, mimeType="application/x-turtle")

# When the query object is no longer needed, the resources it had allocated can be freed.
freeQuery(query)
rm(query)
}
