% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_jaccard_similarity.R
\name{get_jaccard_similarity}
\alias{get_jaccard_similarity}
\title{Get Jaccard similarity coefficient scores}
\usage{
get_jaccard_similarity(graph, nodes = NULL, direction = "all", round_to = 3)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{nodes}{An optional vector of node IDs to consider for Jaccard
similarity scores. If not supplied, then similarity scores will be provided
for every pair of nodes in the graph.}

\item{direction}{Using \code{all} (the default), the function will ignore edge
direction when determining scores for neighboring nodes. With \code{out} and
\verb{in}, edge direction for neighboring nodes will be considered.}

\item{round_to}{The maximum number of decimal places to retain for the
Jaccard similarity coefficient scores. The default value is \code{3}.}
}
\value{
A matrix with Jaccard similarity values for each pair of nodes
considered.
}
\description{
Get the Jaccard similarity coefficient scores for one or more nodes in a
graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the Jaccard similarity
# values for nodes `5`, `6`,
# and `7`
graph \%>\%
  get_jaccard_similarity(
    nodes = 5:7)

}
