#!/usr/bin/env php
<?php

use phpdotnet\phd as PhD;

// @todo document these settings and requirements
define ('FILENAME_JSON',	'./php_manual.json');
define ('PHD_INSTALL_DIR',	'/Users/philip/php/lib/php/');
define ('PHD_OUTPUT_DIR',	'/Users/philip/svn/php/doc-en/output/');
define ('DS',				DIRECTORY_SEPARATOR);

if (!is_dir(PHD_INSTALL_DIR)) {
	echo 'Fatal error: PHD_INSTALL_DIR is not a directory. It must contain PhD (look for a phpdotnet/ subdirectory).' . PHP_EOL;
	exit;
}
if (!is_dir(PHD_OUTPUT_DIR)) {
	echo 'Fatal error: PHD_OUTPUT_DIR is not a directory. It must contain output generated by PhD.' . PHP_EOL;
	echo 'Information: $ phd --docbook /foo/.manual.xml --package IDE --format xml' . PHP_EOL;
	echo 'Information: $ phd --docbook /foo/.manual.xml --package IDE --format funclist' . PHP_EOL;
	exit;
}

require PHD_INSTALL_DIR . DS . 'phpdotnet' . DS . 'phd' . DS . 'Autoloader.php';
require PHD_INSTALL_DIR . DS . 'phpdotnet' . DS . 'phd' . DS . 'functions.php';

spl_autoload_register(array('phpdotnet\phd\Autoloader', 'autoload'));

// @todo this may not be needed in the future
PhD\Config::init(array());

$api = new PhD\Package_IDE_API(PHD_OUTPUT_DIR);

// Gets all documented functions/methods
$functions = $api->getFunctionList();

$json_arr = array();
foreach ($functions as $function_name) {

	// @todo fix source so trim() isn't needed
	$function_name = trim($function_name);
	
	$function      = $api->getFunctionByName($function_name);
	$prototype     = (string) $function;
	
	// @todo fix this. Replaces class.method with class::method
	// @todo fix this? Replaces NULL with null, to remain consistent
	$function_name_fixed = str_replace('.', '::', (string) $function_name);
	$prototype           = str_replace($function_name, $function_name_fixed, $prototype);
	$prototype           = str_replace('NULL', 'null', $prototype);
	
	// Some contain new lines, let's remove them
	$purpose = str_replace("\n", '', (string) $function->getPurpose());
	// @todo fix bug when return description contains tables (example: variant_and())
	$return  = str_replace("\n", '', (string) $function->getReturnDescription());

	// Some 'function names' contain spaces, like 'Constants for PDO_4D'
	// @todo fix this bug in the source
	if (false !== strpos($function_name_fixed, ' ')) {
		continue;
	}

	/* Define our array structure for json. Example entries:
		[strlen] = Array
		(
			[id]		=> function.strlen
			[purpose]	=> Get string length
			[prototype]	=> int strlen(string $string)
			[return]	=> The length of the string on success,    and 0 if the string is empty.
			[versions]	=> PHP 4, PHP 5
		)
		[HttpRequest::addHeaders] => Array
		(
			[id] => function.httprequest-addheaders
			[purpose] => Add headers
			[prototype] => bool HttpRequest::addHeaders(array $headers)
			[return] => Returns TRUE on success or FALSE on failure.
			[versions] => 
		)
	*/
	
	// @todo Describe (implement?) other options like ->getParams(), ->getSeeAlsoEntries(), ->getChangelogEntries()
	$json_arr[$function_name_fixed] = array(
		
		// Example usage: php.net/$id works
		'id'	    => (string) $function->getManualId(),
		
		'purpose'   => (string) $purpose, 
		
		'prototype' => (string) $prototype,
		
		// Return description. It contains text (including tables) so may be large and odd
		'return'    => (string) $return,
		
		// @todo This appears empty for class::method's -- why?
		'versions'	=> (string) $function->getVersion(),
	);
}

$json_text = json_encode($json_arr);
if (!$json_text) {
	echo 'Fatal Error: Could not create valid json.' . PHP_EOL;
	echo 'Information: json array has count of ' . count($json_arr) . PHP_EOL;
	exit;
}

if (!file_put_contents(FILENAME_JSON, $json_text)) {
	echo 'Fatal Error: Could not save JSON to ' . FILENAME_JSON . PHP_EOL;
	exit;
}

echo 'Success. Saved json to ' . FILENAME_JSON . '. String length = ' . strlen($json_text) . PHP_EOL;
