!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!                                                                      *
! Copyright (C) 2001, Roland Lindh                                     *
!               2001, Laura Gagliardi                                  *
!***********************************************************************

subroutine Lebedev(rPt,wPt,nPt,nDeg,lMax)
!***********************************************************************
!                                                                      *
! Object: Numerical Gauss integrations over the unit sphere by a rule  *
! with octahedral symmetry.                                            *
!                                                                      *
!      Author:Roland Lindh, Department of Chemical Physics, University *
!             of Lund, SWEDEN.                                         *
!             Laura Gagliardi, Dipartimento di Chimica G. Ciamician,   *
!             University of Bologna, ITALY. November 2001              *
!             This has been readapted from the original routine by     *
!             Bernard Delley, Paul Scherrer Institut, Switzerland      *
!             Journal of Computational Chemistry 1996, 17, 1152--1155  *
!***********************************************************************

use Definitions, only: wp, iwp, u6

implicit none
integer(kind=iwp), intent(out) :: nPt
integer(kind=iwp), intent(in) :: nDeg, lMax
real(kind=wp), intent(out) :: rPt(3,nDeg), wPt(nDeg)
integer(kind=iwp), parameter :: nscheme5(8) = [5,1,1,0,0,0,0,14], &
                                nscheme7(8) = [7,1,1,1,0,0,0,26], &
                                nscheme11(8) = [11,1,1,1,1,0,0,50], &
                                nscheme17(8) = [17,1,1,0,3,1,0,110], &
                                nscheme23(8) = [23,1,1,1,4,1,1,194], &
                                nscheme29(8) = [29,1,1,0,6,2,2,302], &
                                nscheme35(8) = [35,1,1,1,7,2,4,434], &
#                               ifdef _OLDDATA_
                                nscheme41(8) = [41,1,1,0,8,4,6,590], &
                                nscheme47(8) = [47,1,1,1,9,4,9,770], &
#                               else
                                ! alternate solution 950704 BD
                                nscheme41(8) = [41,1,1,0,9,3,6,590], &
                                ! alternate solution 950705 BD
                                nscheme47(8) = [47,1,1,1,10,3,9,770], &
#                               endif
                                nscheme53(8) = [53,1,1,0,12,4,12,974], &
                                nscheme59(8) = [59,1,1,1,13,4,16,1202]
real(kind=wp), parameter :: pa5(2) = [6.6666666666666667e-2_wp,7.5000000000000000e-2_wp], &
                            pa7(3) = [4.7619047619047619e-2_wp,3.2142857142857143e-2_wp,3.8095238095238095e-2_wp], &
                            pa11(5) = [1.2698412698412698e-2_wp,2.1093750000000000e-2_wp,2.2574955908289242e-2_wp, &
                                       3.0151134457776362e-1_wp,2.0173335537918871e-2_wp], &
                            pa17(10) = [3.8282704949371616e-3_wp,9.7937375124875125e-3_wp,1.8511563534473617e-1_wp, &
                                        8.2117372831911110e-3_wp,3.9568947305594191e-1_wp,9.5954713360709628e-3_wp, &
                                        6.9042104838229218e-1_wp,9.9428148911781033e-3_wp,4.7836902881215020e-1_wp, &
                                        9.6949963616630283e-3_wp], &
                            pa23(16) = [1.7823404472446112e-3_wp,5.5733831788487380e-3_wp,5.7169059499771019e-3_wp, &
                                        4.4469331787174373e-1_wp,5.5187714672736137e-3_wp,2.8924656275754386e-1_wp, &
                                        5.1582377118053831e-3_wp,6.7129734426952263e-1_wp,5.6087040825879968e-3_wp, &
                                        1.2993354476500669e-1_wp,4.1067770281693941e-3_wp,3.4577021976112827e-1_wp, &
                                        5.0518460646148085e-3_wp,1.5904171053835295e-1_wp,5.2511857244364202e-1_wp, &
                                        5.5302489162330937e-3_wp], &
                            pa29(24) = [8.5459117251281481e-4_wp,3.5991192850255715e-3_wp,7.0117664160895449e-1_wp, &
                                        3.6500458076772554e-3_wp,6.5663294102196118e-1_wp,3.6048226014198817e-3_wp, &
                                        4.7290541325810046e-1_wp,3.5767296617433671e-3_wp,3.5156403455701051e-1_wp, &
                                        3.4497884243058833e-3_wp,2.2196452362941784e-1_wp,3.1089531224136753e-3_wp, &
                                        9.6183085226147838e-2_wp,2.3521014136891644e-3_wp,5.7189558918789607e-1_wp, &
                                        3.6008209322164603e-3_wp,2.6441528870606625e-1_wp,2.9823449631718039e-3_wp, &
                                        2.5100347517704651e-1_wp,5.4486773725807738e-1_wp,3.5715405542733871e-3_wp, &
                                        1.2335485325833274e-1_wp,4.1277240831685310e-1_wp,3.3923122050061702e-3_wp], &
                            pa35(33) = [5.2658979682244362e-4_wp,2.5123174189273072e-3_wp,2.5482199720026072e-3_wp, &
                                        6.9093463075091106e-1_wp,2.5304038011863550e-3_wp,6.4566647074242561e-1_wp, &
                                        2.5132671745975644e-3_wp,4.9143426377847465e-1_wp,2.5017251684029361e-3_wp, &
                                        3.9272597633680022e-1_wp,2.4453734373129800e-3_wp,2.8612890103076384e-1_wp, &
                                        2.3026947822274158e-3_wp,1.7748360546091578e-1_wp,2.0142790209185282e-3_wp, &
                                        7.5680843671780184e-2_wp,1.4624956215946138e-3_wp,2.1027252285730696e-1_wp, &
                                        1.9109512821795323e-3_wp,4.7159869115131592e-1_wp,2.4174423756389808e-3_wp, &
                                        9.9217696364292373e-2_wp,3.3443631453434549e-1_wp,2.2366077604378487e-3_wp, &
                                        2.0548236964030437e-1_wp,4.5023303825826254e-1_wp,2.4169300443247753e-3_wp, &
                                        3.1042840351665415e-1_wp,5.5501523610768072e-1_wp,2.4966440545530860e-3_wp, &
                                        1.0680182607580483e-1_wp,5.9051570489252711e-1_wp,2.5122368545634951e-3_wp], &
#                           ifdef _OLDDATA_
                            pa41(44) = [1.0090057533787580e-4_wp,1.8514016873890461e-3_wp,7.0404760433146996e-1_wp, &
                                        1.8686219518306975e-3_wp,6.8084561988024238e-1_wp,1.8648696345606001e-3_wp, &
                                        6.3723669159418917e-1_wp,1.8497643975168892e-3_wp,5.0447558060926046e-1_wp, &
                                        1.8450277740822388e-3_wp,4.2175447334398773e-1_wp,1.8164174988262214e-3_wp, &
                                        3.3201962086729379e-1_wp,1.7449464690023229e-3_wp,2.3917494336556047e-1_wp, &
                                        1.6278016126848035e-3_wp,1.4024070738935403e-1_wp,1.5576827519901693e-3_wp, &
                                        9.1616343286052397e-2_wp,1.2680968886048433e-3_wp,2.0326292518419433e-1_wp, &
                                        1.1183965414769017e-3_wp,3.9364042372978295e-1_wp,1.7287035120530033e-3_wp, &
                                        6.1262355812929648e-1_wp,1.8551905629473527e-3_wp,8.9598759118937909e-2_wp, &
                                        2.8114771623428322e-1_wp,1.4697353123693616e-3_wp,1.7327600238498666e-1_wp, &
                                        3.8175470908581117e-1_wp,1.6819651914742022e-3_wp,2.6422260656245780e-1_wp, &
                                        4.7452376478986998e-1_wp,1.7876372876796954e-3_wp,3.5189965873835832e-1_wp, &
                                        5.6127905075920534e-1_wp,1.8400735685528423e-3_wp,8.8867910181862953e-2_wp, &
                                        5.0324791996964975e-1_wp,1.8072536817113700e-3_wp,1.8154345643517542e-1_wp, &
                                        5.9768324320748616e-1_wp,1.8527289739424312e-3_wp], &
                            pa47(56) = [1.1685335608691628e-3_wp,1.4121215930643264e-3_wp,1.4468645950992776e-3_wp, &
                                        1.1441365123336336e-1_wp,1.0478418864629224e-3_wp,1.9944675708548970e-1_wp, &
                                        1.2392547584848484e-3_wp,2.8401278368259530e-1_wp,1.3259295792415379e-3_wp, &
                                        3.6646411416548296e-1_wp,1.3756097758625958e-3_wp,4.4356118052513995e-1_wp, &
                                        1.3999348863558624e-3_wp,5.1435709575333968e-1_wp,1.4096221218822673e-3_wp, &
                                        6.3052081196671812e-1_wp,1.4108746499638577e-3_wp,6.7164784337293865e-1_wp, &
                                        1.4134887639034478e-3_wp,6.9812332010174177e-1_wp,1.4366946685816802e-3_wp, &
                                        1.2047667931264991e-1_wp,1.0901543574180667e-3_wp,3.0940302315480606e-1_wp, &
                                        1.8691378448038514e-4_wp,3.4884276430183016e-1_wp,1.1284267652336505e-3_wp, &
                                        5.3224214285417946e-1_wp,1.3844558026568455e-3_wp,6.6161599334370030e-2_wp, &
                                        2.3249923409267532e-1_wp,1.1853923885095502e-3_wp,1.4568618765136356e-1_wp, &
                                        3.2477344409682044e-1_wp,1.2949021664637693e-3_wp,2.2832839132127622e-1_wp, &
                                        4.1056989039349425e-1_wp,1.3525857420363760e-3_wp,3.0714431901543855e-1_wp, &
                                        4.9213658085114203e-1_wp,1.3925025908786082e-3_wp,3.8271180625074657e-1_wp, &
                                        5.6548849812588755e-1_wp,1.4073257894372725e-3_wp,7.9707151879391904e-2_wp, &
                                        4.3713473693946563e-1_wp,1.3128954307755017e-3_wp,1.5892620239864833e-1_wp, &
                                        5.2320749473197761e-1_wp,1.3784632898490457e-3_wp,2.3667220253873893e-1_wp, &
                                        6.0283033994386521e-1_wp,1.4125450609821936e-3_wp,7.9823288260308803e-2_wp, &
                                        6.2037164721742807e-1_wp,1.4289835314095131e-3_wp], &
#                           else
                            ! alternate solution 950704 BD
                            pa41(44) = [3.0951212953061873e-4_wp,1.8523796985974890e-3_wp,6.0950341155071959e-2_wp, &
                                        9.7643311650510500e-4_wp,1.4590364491577632e-1_wp,1.3847372348516919e-3_wp, &
                                        2.3847367014218874e-1_wp,1.6172106472544112e-3_wp,3.3179207364721231e-1_wp, &
                                        1.7495646572811541e-3_wp,4.2157617840109665e-1_wp,1.8184717781627688e-3_wp, &
                                        5.0444197078003583e-1_wp,1.8467159561512418e-3_wp,6.3725469392587524e-1_wp, &
                                        1.8520288282962131e-3_wp,6.8077440664552429e-1_wp,1.8588125854383170e-3_wp, &
                                        7.0409549382274691e-1_wp,1.8717906392777438e-3_wp,1.7247820099077235e-1_wp, &
                                        1.3003216858860477e-3_wp,3.9647553481998576e-1_wp,1.7051539963958640e-3_wp, &
                                        6.1168434420098755e-1_wp,1.8571611967740780e-3_wp,8.2130215819325114e-2_wp, &
                                        2.7786731905862443e-1_wp,1.5552136033968085e-3_wp,8.9992058420748749e-2_wp, &
                                        5.0335642710751172e-1_wp,1.8022391280085255e-3_wp,1.8166408403602095e-1_wp, &
                                        5.9841264978853796e-1_wp,1.8498305604436602e-3_wp,1.7207952256568781e-1_wp, &
                                        3.7910354076955633e-1_wp,1.7139045071067087e-3_wp,2.6347166559379496e-1_wp, &
                                        4.7423928425519802e-1_wp,1.8026589343774512e-3_wp,3.5182809277335190e-1_wp, &
                                        5.6102638086220602e-1_wp,1.8428664729052856e-3_wp], &
                            ! alternate solution 950705 BD
                            pa47(56) = [2.1929420881811841e-4_wp,1.4219403443358774e-3_wp,1.4364336173190798e-3_wp, &
                                        5.0872044105023605e-2_wp,6.7981235110505020e-4_wp,1.2281987901788307e-1_wp, &
                                        9.9131842352949122e-4_wp,2.0268908144087861e-1_wp,1.1802078332389488e-3_wp, &
                                        2.8477451564642939e-1_wp,1.2965996020809207e-3_wp,3.6567190789780265e-1_wp, &
                                        1.3658714274283164e-3_wp,4.4282648867134686e-1_wp,1.4029886047753253e-3_wp, &
                                        5.1406196272497354e-1_wp,1.4186455635956094e-3_wp,6.3064012191668026e-1_wp, &
                                        1.4213767418516618e-3_wp,6.7168833320226119e-1_wp,1.4239964754909616e-3_wp, &
                                        6.9797926853368807e-1_wp,1.4315540421785668e-3_wp,1.4468656741953093e-1_wp, &
                                        9.2544014998653679e-4_wp,3.3902634754112157e-1_wp,1.2502399950535093e-3_wp, &
                                        5.3358046512635063e-1_wp,1.3943658433292301e-3_wp,6.9440243933494130e-2_wp, &
                                        2.3551878942423264e-1_wp,1.1270890946717488e-3_wp,2.2690041095294599e-1_wp, &
                                        4.1021824740457302e-1_wp,1.3457537609106701e-3_wp,8.0255746077753389e-2_wp, &
                                        6.2143024174816046e-1_wp,1.4249572833167828e-3_wp,1.4679995278965720e-1_wp, &
                                        3.2452843457173944e-1_wp,1.2615233412377500e-3_wp,1.5715077698247271e-1_wp, &
                                        5.2244821896966297e-1_wp,1.3925471060526959e-3_wp,2.3657029931572456e-1_wp, &
                                        6.0175466340895581e-1_wp,1.4187616778776564e-3_wp,7.7148158667657320e-2_wp, &
                                        4.3465755161411628e-1_wp,1.3383666844795541e-3_wp,3.0629366662107302e-1_wp, &
                                        4.9088265890376162e-1_wp,1.3937008626761314e-3_wp,3.8224773795247870e-1_wp, &
                                        5.6487681490995005e-1_wp,1.4159147574669320e-3_wp], &
#                           endif
                            pa53(70) = [1.4382941905274311e-4_wp,1.1257722882870041e-3_wp,4.2929635453413471e-2_wp, &
                                        4.9480293419492410e-4_wp,1.0514268540864042e-1_wp,7.3579901091254705e-4_wp, &
                                        1.7500248676230874e-1_wp,8.8891327713043843e-4_wp,2.4776533796502568e-1_wp, &
                                        9.8883478389214349e-4_wp,3.2065671239559574e-1_wp,1.0532996817094706e-3_wp, &
                                        3.9165207498499835e-1_wp,1.0927788070145785e-3_wp,4.5908258741876237e-1_wp, &
                                        1.1143893940632272e-3_wp,5.2145638884158605e-1_wp,1.1237247880515553e-3_wp, &
                                        6.2531702446541989e-1_wp,1.1252393252438136e-3_wp,6.6379267445231699e-1_wp, &
                                        1.1261532718159050e-3_wp,6.9104103984983007e-1_wp,1.1302869311238408e-3_wp, &
                                        7.0529070074577603e-1_wp,1.1349865343639549e-3_wp,1.2366867626579899e-1_wp, &
                                        6.8233679271099310e-4_wp,2.9407771144683870e-1_wp,9.4541581604470958e-4_wp, &
                                        4.6977538492076491e-1_wp,1.0744299753856791e-3_wp,6.3345632411395669e-1_wp, &
                                        1.1293000865691317e-3_wp,5.9740486141813418e-2_wp,2.0291287527775228e-1_wp, &
                                        8.4368845009019544e-4_wp,1.3757604084736365e-1_wp,4.6026219424840539e-1_wp, &
                                        1.0752557204488846e-3_wp,3.3910165263362857e-1_wp,5.0306739996620357e-1_wp, &
                                        1.1085772368644620e-3_wp,1.2716751914398195e-1_wp,2.8176064224421343e-1_wp, &
                                        9.5664753237833573e-4_wp,2.6931207404135125e-1_wp,4.3315612917201574e-1_wp, &
                                        1.0806632507173907e-3_wp,1.4197864526019183e-1_wp,6.2561673585808142e-1_wp, &
                                        1.1267971311962946e-3_wp,6.7092846007382550e-2_wp,3.7983952168591567e-1_wp, &
                                        1.0225687153580612e-3_wp,7.0577381832561723e-2_wp,5.5175054214235205e-1_wp, &
                                        1.1089602677131075e-3_wp,2.7838884778821546e-1_wp,6.0296191561591869e-1_wp, &
                                        1.1227906534357658e-3_wp,1.9795789389174069e-1_wp,3.5896063295890958e-1_wp, &
                                        1.0324018471174598e-3_wp,2.0873070611032740e-1_wp,5.3486664381354765e-1_wp, &
                                        1.1072493822838539e-3_wp,4.0551221378728359e-1_wp,5.6749975460743735e-1_wp, &
                                        1.1217800485199721e-3_wp], &
                            pa59(85) = [1.1051892332675715e-4_wp,9.1331597864435614e-4_wp,9.2052327380907415e-4_wp, &
                                        3.7126364496570891e-2_wp,3.6904218980178990e-4_wp,9.1400604122622234e-2_wp, &
                                        5.6039909286806603e-4_wp,1.5310778524699062e-1_wp,6.8652976292826086e-4_wp, &
                                        2.1809288916606116e-1_wp,7.7203385511456304e-4_wp,2.8398745322001746e-1_wp, &
                                        8.3015459588947951e-4_wp,3.4911776009637644e-1_wp,8.6866925501796284e-4_wp, &
                                        4.1214314614443092e-1_wp,8.9270762858468901e-4_wp,4.7189936271491266e-1_wp, &
                                        9.0608202385682188e-4_wp,5.2731454528423366e-1_wp,9.1197772549408672e-4_wp, &
                                        6.2094753324440192e-1_wp,9.1287201386041811e-4_wp,6.5697227118572905e-1_wp, &
                                        9.1307149356917351e-4_wp,6.8417883090701434e-1_wp,9.1528737845541164e-4_wp, &
                                        7.0126043301236308e-1_wp,9.1874362743216541e-4_wp,1.0723822154781661e-1_wp, &
                                        5.1769773129656942e-4_wp,2.5820689594969680e-1_wp,7.3311436821014169e-4_wp, &
                                        4.1727529553067168e-1_wp,8.4632328363799285e-4_wp,5.7003669117925033e-1_wp, &
                                        9.0311226942539918e-4_wp,5.2106394770112841e-2_wp,1.7717740226153253e-1_wp, &
                                        6.4857784531632566e-4_wp,1.1156409571564867e-1_wp,2.4757164634262876e-1_wp, &
                                        7.4350309109823692e-4_wp,1.7465516775786261e-1_wp,3.1736152466119767e-1_wp, &
                                        8.1017314974680177e-4_wp,2.3902784793817240e-1_wp,3.8542911506692237e-1_wp, &
                                        8.5562992573118124e-4_wp,3.0294669735289819e-1_wp,4.5074225931570644e-1_wp, &
                                        8.8502823412654443e-4_wp,3.6498322605976536e-1_wp,5.1235184864198708e-1_wp, &
                                        9.0226929384269151e-4_wp,4.2386447815223403e-1_wp,5.6937024984684411e-1_wp, &
                                        9.1057602589701256e-4_wp,5.9058888532355084e-2_wp,3.3546162890664885e-1_wp, &
                                        7.9985278918390537e-4_wp,1.2172350510959870e-1_wp,4.0902684270853572e-1_wp, &
                                        8.4833895745943309e-4_wp,1.8575051945473351e-1_wp,4.7853206759224352e-1_wp, &
                                        8.8110481824257202e-4_wp,2.4941121623622365e-1_wp,5.4343035696939004e-1_wp, &
                                        9.0100916771050857e-4_wp,3.1122759471496082e-1_wp,6.0311616930963100e-1_wp, &
                                        9.1078135794827047e-4_wp,6.2662506241541695e-2_wp,4.9322211848512846e-1_wp, &
                                        8.8032086797382601e-4_wp,1.2677748006842827e-1_wp,5.6321230207620997e-1_wp, &
                                        9.0213422990406534e-4_wp,1.9060182227792370e-1_wp,6.2698055090243917e-1_wp, &
                                        9.1315780031894351e-4_wp,6.4245492242205886e-2_wp,6.3942796347491023e-1_wp, &
                                        9.1580161746934653e-4_wp]

if (nDeg <= 0) then
  write(u6,*) 'Lebedev: nDeg<=0'
  call Abend()
end if
!lg write(u6,*) 'lMax =',lMax

if (lMax <= 5) then
  nPt = nscheme5(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme5,pa5,rPt,wPt)
  end if

else if (lMax <= 7) then
  nPt = nscheme7(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme7,pa7,rPt,wPt)
  end if

else if (lMax <= 11) then
  nPt = nscheme11(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme11,pa11,rPt,wPt)
  end if

else if (lMax <= 17) then
  nPt = nscheme17(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme17,pa17,rPt,wPt)
  end if

else if (lMax <= 23) then
  nPt = nscheme23(8)
  !lg write(u6,*) 'nPt',nPt
  if (nPt > nDeg) then
    nPt = -nPt
  else
    !lg write(u6,*) 'Call AnMesh',nscheme23
    call AnMesh(nscheme23,pa23,rPt,wPt)
  end if

else if (lMax <= 29) then
  nPt = nscheme29(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme29,pa29,rPt,wPt)
  end if

else if (Lmax <= 35) then
  nPt = nscheme35(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme35,pa35,rPt,wPt)
  end if

else if (lMax <= 41) then
  nPt = nscheme41(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme41,pa41,rPt,wPt)
  end if

else if (lMax <= 47) then
  nPt = nscheme47(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme47,pa47,rPt,wPt)
  end if

else if (lMax <= 53) then
  nPt = nscheme53(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme53,pa53,rPt,wPt)
  end if

else if (lMax <= 59) then
  nPt = nscheme59(8)
  if (nPt > nDeg) then
    nPt = -nPt
  else
    call AnMesh(nscheme59,pa59,rPt,wPt)
  end if

else
  ! such high order is not available here
  nPt = -1
end if

!lg write(u6,*) 'End of Lebedev'

return

end subroutine Lebedev
