// sinh.testdata
// copyright (C) 2005 F. de Dinechin, Ch. Q. Lauter and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RN,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RU,               0x1p-1074,               0x1p-1073,          0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RU,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RD,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RD,              -0x1p-1074,              -0x1p-1073,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RZ,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RZ,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RN,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RN,                    -inf,                    -inf,          0x0p+0, 0) // -inf
T(RU,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RU,                    -inf,                    -inf,          0x0p+0, 0) // -inf
T(RD,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RD,                    -inf,                    -inf,          0x0p+0, 0) // -inf
T(RZ,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RZ,                    -inf,                    -inf,          0x0p+0, 0) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RN,               0x1.f4p+9,                     inf,          0x0p+0, INEXACT|OVERFLOW) // A large positive
T(RU,               0x1.f4p+9,                     inf,          0x0p+0, INEXACT|OVERFLOW)
T(RD,               0x1.f4p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW) // (returns infty rounded down)
T(RZ,               0x1.f4p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
T(RN,              -0x1.f4p+9,                    -inf,          0x0p+0, INEXACT|OVERFLOW) // A large negative
T(RU,              -0x1.f4p+9,-0x1.fffffffffffffp+1023,          0x1p+0, INEXACT|OVERFLOW)
T(RD,              -0x1.f4p+9,                    -inf,          0x0p+0, INEXACT|OVERFLOW)
T(RZ,              -0x1.f4p+9,-0x1.fffffffffffffp+1023,          0x1p+0, INEXACT|OVERFLOW)
//TODO check the transition to infinity (as in exp.checkdate)
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RZ,    0x1.c13876341b62ep-1,    0x1.fd1d7f1c8170cp-1, -0x1.718798p-52, INEXACT) // 8.773838938338422988039155825390e-01
T(RZ,    0x1.aa3b649a96091p-1,     0x1.dd32c5ed1e93p-1, -0x1.89a6dcp-53, INEXACT) // 8.324843825057702817460381083947e-01
T(RZ,    0x1.67425fe575c88p-1,    0x1.857954132083dp-1, -0x1.d5cb6cp-51, INEXACT) // 7.016782729723596290227760619018e-01
T(RN,   0x1.0878ef01d4e35p-10,   0x1.0878f1f28b9eep-10,          0x1p-1, INEXACT) // 1.008882129515676186540251713097e-03
T(RZ,   0x1.db7377c065f7ep-10,   0x1.db7388d5ab191p-10, -0x1.a32ce8p-51, INEXACT) // 1.813701805167127877743693531443e-03
T(RZ,   0x1.e5df9a6dd15bcp-10,    0x1.e5dfaca909fap-10,  -0x1.03eeep-52, INEXACT) // 1.853460121723811936111925291470e-03
T(RN,    0x1.1bd15d167005p-11,   0x1.1bd15dff0122bp-11,          0x1p-1, INEXACT) // 5.413395436377841513087005864691e-04
T(RZ,   0x1.51a5a445ba076p-11,   0x1.51a5a5cd4dd9cp-11,         -0x1p+0, INEXACT) // 6.440106160115050253772706057021e-04
T(RZ,    0x1.fc87da444552p-12,   0x1.fc87db92b65e7p-12,  -0x1.8f2acp-52, INEXACT) // 4.849726431229318263094185681439e-04
T(RZ,   0x1.12a3017916a41p-13,   0x1.12a3018642272p-13,  -0x1.34ef4p-51, INEXACT) // 1.309570032244789926801492585540e-04
T(RZ,   0x1.70adff9f27684p-14,   0x1.70adffa71e7f5p-14,  -0x1.bd798p-57, INEXACT) // 8.790008586109272640043976743129e-05
T(RZ,   0x1.251e0a962233fp-15,   0x1.251e0a9722634p-15,  -0x1.03f12p-53, INEXACT) // 3.494231093365559817241414175548e-05
T(RZ,   0x1.3f84e36ebf392p-15,   0x1.3f84e3700b0e5p-15,  -0x1.0d1e7p-54, INEXACT) // 3.808964435412296302505691381057e-05
T(RZ,   0x1.84be03df01d32p-15,   0x1.84be03e1576dfp-15,   -0x1.ef26p-54, INEXACT) // 4.634168703182075263555944610872e-05
T(RZ,   0x1.692da910879e5p-16,   0x1.692da910ff709p-16, -0x1.a855bcp-53, INEXACT) // 2.152790790621054173585753599429e-05
T(RZ,   0x1.df2f013694cdfp-16,   0x1.df2f0137ac9f2p-16,         -0x1p+0, INEXACT) // 2.856156899107015816551523312850e-05
T(RN,    0x1.07f56b7a1098p-17,   0x1.07f56b7a1c495p-17,         -0x1p-1, INEXACT) // 7.866581416608687746250261341174e-06
T(RN,   0x1.de69d2c4e313fp-17,    0x1.de69d2c528b2p-17,         -0x1p-1, INEXACT) // 1.425782955679548353363893936629e-05
T(RZ,    0x1.dffffffff8f8p-17,   0x1.e00000003f47fp-17,         -0x1p+0, INEXACT) // 1.430511474604496090223815230047e-05
T(RZ,   0x1.1fcd0073f260fp-17,   0x1.1fcd00740188dp-17,         -0x1p+0, INEXACT) // 8.577131872205952676439626169991e-06
T(RZ,   0x1.57bb755e9dc3cp-17,   0x1.57bb755eb795dp-17,         -0x1p+0, INEXACT) // 1.024401961767343777502323187711e-05
T(RZ,   0x1.5ad4695b630f2p-17,   0x1.5ad4695b7d959p-17, -0x1.4a7234p-51, INEXACT) // 1.033633150517756423025263201598e-05
T(RZ,   0x1.67fffffffd08ap-17,   0x1.680000001ab25p-17,         -0x1p+0, INEXACT) // 1.072883605954972959938172050176e-05
T(RZ,   0x1.1d3eceae92a6cp-18,   0x1.1d3eceae96571p-18,         -0x1p+0, INEXACT) // 4.250486809252202483012592071354e-06
T(RZ,   0x1.07be1d2adaebap-19,   0x1.07be1d2adba64p-19, -0x1.2ddb08p-51, INEXACT) // 1.965035740727553315997534061355e-06
T(RN,   0x1.eab06808306b9p-19,   0x1.eab06808351d6p-19,         -0x1p-1, INEXACT) // 3.655918593720893238651530390837e-06
T(RN,    0x1.4169f234f23b9p-2,    0x1.46b7b3b358f99p-2,          0x1p-1, INEXACT) // 3.138807148757752352175032228843e-01
T(RN,    0x1.65a9b373182a4p-2,    0x1.6cfacb1a06434p-2,         -0x1p-1, INEXACT) // 3.492801703451198225280904807732e-01
T(RZ,    0x1.fe694c3c89138p-2,    0x1.09e7c831b1a22p-1,         -0x1p+0, INEXACT) // 4.984485542247685252448263781844e-01
T(RZ,    0x1.bad0485e0fe0ap-2,    0x1.c8be879787986p-2, -0x1.eb613ep-52, INEXACT) // 4.324351603899861951063599008194e-01
T(RZ,    0x1.e6be9678237a2p-2,     0x1.f94840422b64p-2, -0x1.5b943ap-52, INEXACT) // 4.753364096476336841945453670633e-01
T(RN,     0x1.fab395f4b6dcp-2,    0x1.07d1269db031dp-1,          0x1p-1, INEXACT) // 4.948256903278114293698308756575e-01
T(RN,    0x1.d3e0d2f5d98d6p-2,    0x1.e45428082fb8cp-2,          0x1p-1, INEXACT) // 4.569123232416932856025937326194e-01
T(RZ,   0x1.87695d95641d2p-21,   0x1.87695d9564433p-21,         -0x1p+0, INEXACT) // 7.290608887035109799947202660619e-07
T(RN,   0x1.fb9bb79e86dfep-21,   0x1.fb9bb79e87331p-21,          0x1p-1, INEXACT) // 9.454940828631356943169547144001e-07
T(RZ,   0x1.509d9b52dc91fp-22,    0x1.509d9b52dc98p-22, -0x1.2f656cp-52, INEXACT) // 3.134977550257379469172307803054e-07
T(RZ,   0x1.59a05784fe651p-22,   0x1.59a05784fe6b9p-22,         -0x1p+0, INEXACT) // 3.218896085784700206927427205278e-07
T(RZ,   0x1.b4d706debff0bp-23,   0x1.b4d706debff3fp-23,         -0x1p+0, INEXACT) // 2.034194528030488044399026878115e-07
T(RZ,   0x1.2b076f131c9d5p-23,   0x1.2b076f131c9e5p-23,         -0x1p+0, INEXACT) // 1.392462470637338800076408676723e-07
T(RN,    0x1.5f07120fe56ap-23,   0x1.5f07120fe56bbp-23,         -0x1p-1, INEXACT) // 1.634599731097404940361079994648e-07
T(RZ,   0x1.61246d6ad9aebp-23,   0x1.61246d6ad9b06p-23,         -0x1p+0, INEXACT) // 1.644446954954337727837320034738e-07
T(RN,   0x1.b0ade79bb859cp-23,    0x1.b0ade79bb85dp-23,          0x1p-1, INEXACT) // 2.014820069595779493764708782677e-07
T(RN,   0x1.c0de7acde29a4p-23,   0x1.c0de7acde29dep-23,          0x1p-1, INEXACT) // 2.090209449380532926780176979087e-07
T(RZ,   0x1.e60a0c716031fp-23,   0x1.e60a0c7160368p-23, -0x1.eb5cacp-53, INEXACT) // 2.263296639375345638494854303910e-07
T(RN,   0x1.e83fa11b81dbap-24,   0x1.e83fa11b81dcdp-24,          0x1p-1, INEXACT) // 1.136792246379422424921702911363e-07
T(RN,   0x1.30c7efbee12adp-24,   0x1.30c7efbee12b2p-24,          0x1p-1, INEXACT) // 7.096235686398443705128949833896e-08
T(RN,   0x1.45dd7c26e54bap-24,   0x1.45dd7c26e54bfp-24,         -0x1p-1, INEXACT) // 7.587139859288168358579312281625e-08
T(RZ,   0x1.7137449123ef7p-25,   0x1.7137449123ef9p-25, -0x1.bdd4bcp-51, INEXACT) // 4.298238665781642567566384299620e-08
T(RZ,   0x1.a6a58d55e307bp-25,   0x1.a6a58d55e307dp-25,         -0x1p+0, INEXACT) // 4.920255018613675682085466223624e-08
T(RZ,   0x1.d12ed0af1a27ep-25,   0x1.d12ed0af1a281p-25,         -0x1p+0, INEXACT) // 5.415441372490344784799883850676e-08
T(RZ,   0x1.f51a62037e955p-25,   0x1.f51a62037e95ap-25, -0x1.04f5c2p-52, INEXACT) // 5.833607377363537896357219649825e-08
T(RN,    0x1.6bf4b01e49582p-3,    0x1.6ddfe3f43b166p-3,          0x1p-1, INEXACT) // 1.777127990000444968110571153375e-01
T(RN,    0x1.70fafb506ca27p-3,     0x1.72fad528f355p-3,          0x1p-1, INEXACT) // 1.801662095945897046345152148206e-01
T(RN,    0x1.63f790334d21fp-4,    0x1.646a50d7df5abp-4,          0x1p-1, INEXACT) // 8.690601661948747780339630253366e-02
T(RN,    0x1.6f15c9e9c4392p-4,    0x1.6f93a2cb8855ap-4,         -0x1p-1, INEXACT) // 8.962038872074476469897774677520e-02
T(RN,    0x1.c6fe5f6e82b26p-4,    0x1.c7ee1078d11dcp-4,          0x1p-1, INEXACT) // 1.110824325370854681604981806231e-01
T(RN,    0x1.d7c5ec43c6ae4p-4,    0x1.d8d1229fa91aep-4,          0x1p-1, INEXACT) // 1.151789883701144767691459946946e-01
T(RN,    0x1.06de68233f6e2p-5,    0x1.06e9f4b529d09p-5,          0x1p-1, INEXACT) // 3.208847369567792429112529362101e-02
T(RN,    0x1.e1f384f365549p-5,    0x1.e23ab4835d3a2p-5,         -0x1p-1, INEXACT) // 5.883193938204073908382341073775e-02
T(RZ,    0x1.0c490327d68f9p-6,    0x1.0c4c14e8063a5p-6,         -0x1p+0, INEXACT) // 1.637482937017240361421421823707e-02
T(RN,    0x1.86e016031945bp-6,    0x1.86e99410fa67ep-6,         -0x1p-1, INEXACT) // 2.385713719958846776303396097774e-02
T(RN,    0x1.d80a58a697818p-6,    0x1.d81b10a820936p-6,          0x1p-1, INEXACT) // 2.881106049823509152041367542552e-02
T(RN,    0x1.55735f67ad233p-7,    0x1.5574f45e24e73p-7,          0x1p-1, INEXACT) // 1.042024763533175822638465746195e-02
T(RZ,    0x1.0041e4199113dp-8,    0x1.00420ee5386bap-8,         -0x1p+0, INEXACT) // 3.910177410549939454320611531557e-03
T(RN,    0x1.8e76ff6d8d2eep-8,    0x1.8e77a05264e28p-8,          0x1p-1, INEXACT) // 6.080090866409133473768910960189e-03
T(RZ,     0x1.e2b6e387ef5bp-8,    0x1.e2b8019489d27p-8,         -0x1p+0, INEXACT) // 7.365637349662376709424904674961e-03
T(RN,    0x1.10c0329caf2c3p-9,    0x1.10c03f8337036p-9,          0x1p-1, INEXACT) // 2.080923250416284644298547945596e-03
T(RN,    0x1.18685f1363fe1p-9,    0x1.18686d17f0284p-9,          0x1p-1, INEXACT) // 2.139340978551715777983277533281e-03
T(RZ,    0x1.2514c711e822cp-9,    0x1.2514d71358d02p-9,         -0x1p+0, INEXACT) // 2.236031818896108344651985078144e-03
T(RZ,    0x1.c75e761238f33p-9,    0x1.c75eb21b00c67p-9, -0x1.4e0558p-51, INEXACT) // 3.474189675317784688907130075108e-03
T(RZ,    0x1.e686730bc9b7cp-9,    0x1.e686bc43e8d87p-9,         -0x1p+0, INEXACT) // 3.711892646510004875604060714522e-03
T(RZ,    0x1.ba956d999f0d7p-9,    0x1.ba95a4b7e3f1ep-9,         -0x1p+0, INEXACT) // 3.376645687977224401937759168391e-03
T(RN,    0x1.cacafd15210aap-9,    0x1.cacb3a7b32b9ap-9,         -0x1p-1, INEXACT) // 3.500312227119624537696740418369e-03
T(RZ,    0x1.2885628f9cc23p+0,    0x1.6f6ab56109975p+0,         -0x1p+0, INEXACT) // 1.158285293637853596848685810983e+00
T(RN,    0x1.39f4ffbc931dcp+0,    0x1.8ecaf44ac417ep+0,         -0x1p-1, INEXACT) // 1.226394637621630145929430000251e+00
T(RZ,    0x1.f737f1e8378c7p+0,    0x1.bffd3f94f40fbp+1, -0x1.a343e8p-53, INEXACT) // 1.965697402185058839663156504685e+00
T(RZ,    0x1.e8529c29e8e91p+0,    0x1.a59f4fbb4792ap+1,         -0x1p+0, INEXACT) // 1.907510528785597125889239578100e+00
T(RN,    0x1.7f0046225d651p+1,    0x1.3e11487da075dp+3,          0x1p-1, INEXACT) // 2.992195860652636429932726969128e+00
T(RZ,    0x1.bc3c2d0c95f52p+1,    0x1.00fef7383a978p+4, -0x1.61182ap-52, INEXACT) // 3.470586424966236371858485654229e+00
T(RZ,    0x1.b90aea3103e41p+2,    0x1.ebd5b8345f38fp+8,         -0x1p+0, INEXACT) // 6.891291187158970821258208161453e+00
T(RZ,    0x1.c089fcf166171p+4,   0x1.5c452e0e37569p+39,  -0x1.3bf06p-56, INEXACT) // 2.803368849083330260896218533162e+01
T(RZ,     0x1.695ff9bffb61p+4,   0x1.7fe814ba7972cp+31, -0x1.d8be64p-51, INEXACT) // 2.258593153946827669642516411841e+01
T(RN,    0x1.6f29775af2c53p+4,   0x1.139924e530bb4p+32,          0x1p-1, INEXACT) // 2.294762359167755150224365934264e+01
T(RN,    0x1.c82cc33c75ae3p+4,   0x1.18a3bf57ce269p+40,         -0x1p-1, INEXACT) // 2.851092837922159262120658240747e+01
T(RZ,    0x1.94925476814e9p+5,    0x1.f1b76b88f075p+71, -0x1.b710acp-51, INEXACT) // 5.057145016271699233811887097545e+01
T(RN,    0x1.a1d3b2f33674ep+5,   0x1.4632f06b68116p+74,         -0x1p-1, INEXACT) // 5.222836866388261967131256824359e+01
T(RZ,    0x1.e07e71bfcf06fp+5,   0x1.91ec4412c344fp+85,  -0x1.09d28p-57, INEXACT) // 6.006174039698168343193174223416e+01
T(RN,    0x1.f0a1fc4b9f04bp+5,    0x1.79ba395af901p+88,          0x1p-1, INEXACT) // 6.207909449652705546895958832465e+01
T(RN,    0x1.181ccd8144be7p+6,  0x1.053d7702a0c15p+100,         -0x1p-1, INEXACT) // 7.002812768919066854778066044673e+01
T(RZ,    0x1.7945e34b18a9ap+7,  0x1.1b0e4936a8c9ap+271,         -0x1p+0, INEXACT) // 1.886364997356038770703889895231e+02
T(RZ,    0x1.f44c934fc9053p+7,  0x1.da4255c59658dp+359,         -0x1p+0, INEXACT) // 2.501495613987814010670263087377e+02
T(RZ,    0x1.204684c1167e9p+8,  0x1.db9797d3d32e7p+414,         -0x1p+0, INEXACT) // 2.882754631690900737339688930660e+02
T(RZ,     0x1.2da9e5e6af0bp+8,  0x1.27d6fe867d6f6p+434,  -0x1.0a1d5p-53, INEXACT) // 3.016636642625189779209904372692e+02
T(RN,    0x1.4b857492a59ebp+8,  0x1.37bab2ac649f8p+477,         -0x1p-1, INEXACT) // 3.315213100103707688504073303193e+02
T(RZ,     0x1.532627c210d1p+8,  0x1.38b3af1b0b785p+488,         -0x1p+0, INEXACT) // 3.391490441599898986169137060642e+02
T(RN,    0x1.9cd6b6d99965bp+8,  0x1.84208270e2e4cp+594,          0x1p-1, INEXACT) // 4.128387275695328639812942128628e+02
T(RZ,    0x1.c7206c1b753e4p+8,  0x1.8670de0b68cacp+655,         -0x1p+0, INEXACT) // 4.551266495858419602882349863648e+02
T(RN,    0x1.fee02d3d0ec9ap+8,  0x1.06ccf59e5ed14p+736,         -0x1p-1, INEXACT) // 5.108756902848341496792272664607e+02
T(RZ,    0x1.f419d873a3f83p+8,  0x1.685463d30fb68p+720,         -0x1p+0, INEXACT) // 5.001009590411487693017988931388e+02
T(RZ,    0x1.0bc04af1b09f5p+9,  0x1.7b1d97c902985p+771, -0x1.551dfcp-53, INEXACT) // 5.355022871124662060537957586348e+02
// Bad cases generated by crlibm_generate_test_vectors sinh 18 1
T(RN,    0x1.3a1c272a684cap+8,  0x1.1effa30012b93p+452,   -0x1.ffffep-2, INEXACT) // 3.141099726204525950379320420325e+02
T(RN,   -0x1.99fedc8de0634p+1,   -0x1.8915cd68a4524p+3,  -0x1.fffff6p-2, INEXACT) // -3.203090256953851522325749101583e+00
T(RN,   -0x1.d5d4ead3dc285p-1,   -0x1.0d4d15c81e3d6p+0,   0x1.ffffe4p-2, INEXACT) // -9.176400550478126527664812783769e-01
T(RN,   -0x1.be301fbb694fep-2,   -0x1.cc710b1211ab3p-2,    0x1.fffffp-2, INEXACT) // -4.357304533135247792685618151154e-01
T(RD,    0x1.01a4644b1ec18p+3,   0x1.883d9f4740a96p+10,  -0x1.ffffe2p-1, INEXACT) // 8.051317354887984834022063296288e+00
T(RU,    0x1.01a4644b1ec18p+3,   0x1.883d9f4740a97p+10,  0x1.d03336p-21, INEXACT) // 8.051317354887984834022063296288e+00
T(RZ,    0x1.01a4644b1ec18p+3,   0x1.883d9f4740a96p+10,  -0x1.ffffe2p-1, INEXACT) // 8.051317354887984834022063296288e+00
T(RN,   -0x1.7bc90d19545e9p-2,   -0x1.848d65d3cd79dp-2,  -0x1.fffffap-2, INEXACT) // -3.708841368398610449652608167526e-01
T(RD,    0x1.088a4cd60e43ep-9,    0x1.088a589b3a963p-9, -0x1.9b79b2p-21, INEXACT) // 2.018281821645233863049551104041e-03
T(RU,    0x1.088a4cd60e43ep-9,    0x1.088a589b3a964p-9,   0x1.ffffe6p-1, INEXACT) // 2.018281821645233863049551104041e-03
T(RZ,    0x1.088a4cd60e43ep-9,    0x1.088a589b3a963p-9, -0x1.9b79b2p-21, INEXACT) // 2.018281821645233863049551104041e-03
T(RN,   -0x1.40b36e37fc019p-5,   -0x1.40c86715d370ap-5,   -0x1.fffffp-2, INEXACT) // -3.914805914962488780917126973691e-02
T(RD,   -0x1.b9e31e713ea74p+7, -0x1.afcd25a9301b6p+317,  -0x1.fffffep-1, INEXACT) // -2.209435916317921737572760321200e+02
T(RU,   -0x1.b9e31e713ea74p+7, -0x1.afcd25a9301b5p+317,  0x1.614478p-24, INEXACT) // -2.209435916317921737572760321200e+02
T(RZ,   -0x1.b9e31e713ea74p+7, -0x1.afcd25a9301b5p+317,  0x1.614478p-24, INEXACT) // -2.209435916317921737572760321200e+02
T(RD,   -0x1.7971a40060505p+4,  -0x1.0604e7240d83ep+33, -0x1.f1511ap-21, INEXACT) // -2.359024429461443972400047641713e+01
T(RU,   -0x1.7971a40060505p+4,  -0x1.0604e7240d83dp+33,    0x1.ffffep-1, INEXACT) // -2.359024429461443972400047641713e+01
T(RZ,   -0x1.7971a40060505p+4,  -0x1.0604e7240d83dp+33,    0x1.ffffep-1, INEXACT) // -2.359024429461443972400047641713e+01
T(RD,    0x1.b911a09cbfdf4p-1,    0x1.f1aef6e4181c6p-1,  -0x1.fffff2p-1, INEXACT) // 8.614626113266568019355418073246e-01
T(RU,    0x1.b911a09cbfdf4p-1,    0x1.f1aef6e4181c7p-1,  0x1.c5537ap-22, INEXACT) // 8.614626113266568019355418073246e-01
T(RZ,    0x1.b911a09cbfdf4p-1,    0x1.f1aef6e4181c6p-1,  -0x1.fffff2p-1, INEXACT) // 8.614626113266568019355418073246e-01
T(RN,   0x1.c6af0f5902d62p-10,   0x1.c6af1e49e328dp-10,   0x1.fffffap-2, INEXACT) // 1.734481155156363408470499010150e-03
T(RD,    0x1.bfbfaf2f5cf39p-1,    0x1.fb0ab085df9f4p-1, -0x1.9e0c06p-21, INEXACT) // 8.745093102756761327398749017448e-01
T(RU,    0x1.bfbfaf2f5cf39p-1,    0x1.fb0ab085df9f5p-1,   0x1.ffffe6p-1, INEXACT) // 8.745093102756761327398749017448e-01
T(RZ,    0x1.bfbfaf2f5cf39p-1,    0x1.fb0ab085df9f4p-1, -0x1.9e0c06p-21, INEXACT) // 8.745093102756761327398749017448e-01
T(RN,    0x1.7a907486deb39p-7,    0x1.7a929c6a1584cp-7,   0x1.fffffep-2, INEXACT) // 1.155286493098160900683257779065e-02
T(RN,    0x1.a10983b33e9f5p+6,  0x1.552c798f6b072p+149,   0x1.ffffcap-2, INEXACT) // 1.042592914587947490190344979055e+02
T(RN,    -0x1.8f6c6a4d260fp+0,   -0x1.2331da637bfd4p+1,   0x1.fffff4p-2, INEXACT) // -1.560248035273669842126764706336e+00
T(RD,     0x1.7de8be6ade92p-3,     0x1.80205f48d41ap-3, -0x1.013b6cp-21, INEXACT) // 1.864790798534352589399532007519e-01
T(RU,     0x1.7de8be6ade92p-3,    0x1.80205f48d41a1p-3,    0x1.fffffp-1, INEXACT) // 1.864790798534352589399532007519e-01
T(RZ,     0x1.7de8be6ade92p-3,     0x1.80205f48d41ap-3, -0x1.013b6cp-21, INEXACT) // 1.864790798534352589399532007519e-01
T(RD,    0x1.18512239f801ap-3,    0x1.193168fc960cbp-3, -0x1.1cb28ap-21, INEXACT) // 1.368735002461115013439041376841e-01
T(RU,    0x1.18512239f801ap-3,    0x1.193168fc960ccp-3,   0x1.ffffeep-1, INEXACT) // 1.368735002461115013439041376841e-01
T(RZ,    0x1.18512239f801ap-3,    0x1.193168fc960cbp-3, -0x1.1cb28ap-21, INEXACT) // 1.368735002461115013439041376841e-01
T(RD,    0x1.a9f05a3b6c219p-3,    0x1.ad0424329dec8p-3, -0x1.2d5bfap-22, INEXACT) // 2.079779672035478033098598871220e-01
T(RU,    0x1.a9f05a3b6c219p-3,    0x1.ad0424329dec9p-3,   0x1.fffff6p-1, INEXACT) // 2.079779672035478033098598871220e-01
T(RZ,    0x1.a9f05a3b6c219p-3,    0x1.ad0424329dec8p-3, -0x1.2d5bfap-22, INEXACT) // 2.079779672035478033098598871220e-01
T(RN,   -0x1.e710f1576ff21p-7,   -0x1.e71588c60cc65p-7,  -0x1.ffffe2p-2, INEXACT) // -1.486408027892555279436681558991e-02
T(RN,   -0x1.77787954ed369p+3,  -0x1.e701d5fa7bc4bp+15,   0x1.ffffe4p-2, INEXACT) // -1.173345629298428782760765898274e+01
T(RD,   -0x1.8eb2f07296763p-9,   -0x1.8eb318bdf2851p-9,         -0x1p+0, INEXACT) // -3.041831828608219847470683916413e-03
T(RU,   -0x1.8eb2f07296763p-9,    -0x1.8eb318bdf285p-9,  0x1.a73c5cp-26, INEXACT) // -3.041831828608219847470683916413e-03
T(RZ,   -0x1.8eb2f07296763p-9,    -0x1.8eb318bdf285p-9,  0x1.a73c5cp-26, INEXACT) // -3.041831828608219847470683916413e-03
T(RN,    0x1.e973d923d5f9ep-2,    0x1.fc4dc50da0c54p-2,  -0x1.ffffd8p-2, INEXACT) // 4.779809883234465983647965003911e-01
T(RN,   -0x1.f477b642d18d8p-5,   -0x1.f4c76c41dbcbfp-5,   0x1.ffffe2p-2, INEXACT) // -6.109223935941238137203868063807e-02
T(RN,    0x1.8f45f8987b708p-3,    0x1.91ceb3dde1311p-3,   -0x1.ffffep-2, INEXACT) // 1.949576779874677701087648529210e-01
T(RN,    0x1.1999f9d11a1f6p+4,    0x1.4fd3282c9de9p+24,  -0x1.ffffccp-2, INEXACT) // 1.760009175949559079299433506094e+01
T(RN,   -0x1.40a201b97e9dfp-5,   -0x1.40b6f72c6639dp-5,   0x1.ffffccp-2, INEXACT) // -3.913975083192488407801690186716e-02
T(RN,    0x1.51a69fb21b7bcp+9,  0x1.316277f3b6a8fp+973,   0x1.ffffd6p-2, INEXACT) // 6.753017485269733697350602596998e+02
T(RD,    0x1.2716a98faa414p+1,    0x1.3db44a6f41a3ap+2, -0x1.08929cp-21, INEXACT) // 2.305379099987939994775842933450e+00
T(RU,    0x1.2716a98faa414p+1,    0x1.3db44a6f41a3bp+2,    0x1.fffffp-1, INEXACT) // 2.305379099987939994775842933450e+00
T(RZ,    0x1.2716a98faa414p+1,    0x1.3db44a6f41a3ap+2, -0x1.08929cp-21, INEXACT) // 2.305379099987939994775842933450e+00
T(RD,   -0x1.0ef0358d22c25p+7, -0x1.5b74896f241a3p+194, -0x1.1c2dd2p-22, INEXACT) // -1.354691585640840969517739722505e+02
T(RU,   -0x1.0ef0358d22c25p+7, -0x1.5b74896f241a2p+194,   0x1.fffff8p-1, INEXACT) // -1.354691585640840969517739722505e+02
T(RZ,   -0x1.0ef0358d22c25p+7, -0x1.5b74896f241a2p+194,   0x1.fffff8p-1, INEXACT) // -1.354691585640840969517739722505e+02
T(RD,   -0x1.06565a7aae79cp+8, -0x1.634398532ae53p+377,  -0x1.fffffep-1, INEXACT) // -2.623373181034055505733704194427e+02
T(RU,   -0x1.06565a7aae79cp+8, -0x1.634398532ae52p+377,  0x1.abefb8p-25, INEXACT) // -2.623373181034055505733704194427e+02
T(RZ,   -0x1.06565a7aae79cp+8, -0x1.634398532ae52p+377,  0x1.abefb8p-25, INEXACT) // -2.623373181034055505733704194427e+02
T(RD,   -0x1.1a2f4daa6b55dp-5,    -0x1.1a3d9716f6c2p-5,  -0x1.ffffe6p-1, INEXACT) // -3.444638413507548208025710323454e-02
T(RU,   -0x1.1a2f4daa6b55dp-5,   -0x1.1a3d9716f6c1fp-5,  0x1.993a5ep-21, INEXACT) // -3.444638413507548208025710323454e-02
T(RZ,   -0x1.1a2f4daa6b55dp-5,   -0x1.1a3d9716f6c1fp-5,  0x1.993a5ep-21, INEXACT) // -3.444638413507548208025710323454e-02
T(RN,    0x1.e6f383457c5f3p+8,   0x1.6fa16b80aa08p+701,   0x1.ffffcap-2, INEXACT) // 4.869512217930452493419579695910e+02
T(RN,   -0x1.db7eb66f21027p+5,  -0x1.ae52f41a57e1ap+84,  -0x1.ffffdcp-2, INEXACT) // -5.943687140292632165028408053331e+01
T(RD,   -0x1.dd9d644a625d7p+1,   -0x1.4db2661383df3p+4, -0x1.f28bc6p-21, INEXACT) // -3.731365715332440213813924856368e+00
T(RU,   -0x1.dd9d644a625d7p+1,   -0x1.4db2661383df2p+4,    0x1.ffffep-1, INEXACT) // -3.731365715332440213813924856368e+00
T(RZ,   -0x1.dd9d644a625d7p+1,   -0x1.4db2661383df2p+4,    0x1.ffffep-1, INEXACT) // -3.731365715332440213813924856368e+00
T(RD,    0x1.a089039d2a1adp-2,    0x1.ac1e17d0da3f6p-2,         -0x1p+0, INEXACT) // 4.067726673770504786098456406762e-01
T(RU,    0x1.a089039d2a1adp-2,    0x1.ac1e17d0da3f7p-2,   0x1.10a7cp-26, INEXACT) // 4.067726673770504786098456406762e-01
T(RZ,    0x1.a089039d2a1adp-2,    0x1.ac1e17d0da3f6p-2,         -0x1p+0, INEXACT) // 4.067726673770504786098456406762e-01
T(RN,   -0x1.9876d95338c31p-3,   -0x1.9b2d7b1681148p-3,   0x1.ffffd4p-2, INEXACT) // -1.994454363367324234435074004068e-01
T(RN,   -0x1.c0bb70d7c3b61p-5,   -0x1.c0f4e59688a14p-5,  -0x1.fffff6p-2, INEXACT) // -5.477687873473403162849493241993e-02
T(RD,    0x1.f10b282bd71fap-9,    0x1.f10b763e25436p-9, -0x1.364612p-24, INEXACT) // 3.792141584126659976938800156177e-03
T(RU,    0x1.f10b282bd71fap-9,    0x1.f10b763e25437p-9,   0x1.fffffep-1, INEXACT) // 3.792141584126659976938800156177e-03
T(RZ,    0x1.f10b282bd71fap-9,    0x1.f10b763e25436p-9, -0x1.364612p-24, INEXACT) // 3.792141584126659976938800156177e-03
T(RN,   -0x1.1f958c9759ab2p+1,   -0x1.2b3d3517355d5p+2,   -0x1.ffffep-2, INEXACT) // -2.246751378919122466015778627479e+00
T(RD,  -0x1.961aff81e05aap-10,  -0x1.961b0a271ebd6p-10,  -0x1.ffffe8p-1, INEXACT) // -1.549169392518793490071127294527e-03
T(RU,  -0x1.961aff81e05aap-10,  -0x1.961b0a271ebd5p-10,  0x1.7e309cp-21, INEXACT) // -1.549169392518793490071127294527e-03
T(RZ,  -0x1.961aff81e05aap-10,  -0x1.961b0a271ebd5p-10,  0x1.7e309cp-21, INEXACT) // -1.549169392518793490071127294527e-03
T(RN,    0x1.a65b68095b6e1p-7,    0x1.a65e667711a0ep-7,  -0x1.ffffd6p-2, INEXACT) // 1.288931445989355446812840710891e-02
T(RD,    0x1.a8b2783f62c55p+8,  0x1.a2524dcb6611cp+611,  -0x1.fffff8p-1, INEXACT) // 4.246971473327769786010321695358e+02
T(RU,    0x1.a8b2783f62c55p+8,  0x1.a2524dcb6611dp+611,  0x1.ec4862p-23, INEXACT) // 4.246971473327769786010321695358e+02
T(RZ,    0x1.a8b2783f62c55p+8,  0x1.a2524dcb6611cp+611,  -0x1.fffff8p-1, INEXACT) // 4.246971473327769786010321695358e+02
T(RN,    0x1.ed753610405bep-5,    0x1.edc19e7747b8ap-5,   0x1.ffffc2p-2, INEXACT) // 6.023655471109233550119910205467e-02
T(RN,    -0x1.2b6816bb2b7dp+2,   -0x1.ae47aa5a5e517p+5,   0x1.ffffd2p-2, INEXACT) // -4.678228075774271133013826329261e+00
T(RN,    0x1.61951e427d264p+4,   0x1.d7c8a1cf5ff3bp+30,   0x1.ffffc8p-2, INEXACT) // 2.209890581104481555030361050740e+01
T(RD,    0x1.c043a6035246ap-7,    0x1.c0473a4ec63dcp-7, -0x1.ee3d8cp-22, INEXACT) // 1.367993932821516891995550224692e-02
T(RU,    0x1.c043a6035246ap-7,    0x1.c0473a4ec63ddp-7,    0x1.fffffp-1, INEXACT) // 1.367993932821516891995550224692e-02
T(RZ,    0x1.c043a6035246ap-7,    0x1.c0473a4ec63dcp-7, -0x1.ee3d8cp-22, INEXACT) // 1.367993932821516891995550224692e-02
T(RD,    -0x1.8e147da6d528p+4,   -0x1.dbd098c4b671p+34,  -0x1.fffff8p-1, INEXACT) // -2.488000264328957200632430613041e+01
T(RU,    -0x1.8e147da6d528p+4,  -0x1.dbd098c4b670fp+34,  0x1.114ea8p-22, INEXACT) // -2.488000264328957200632430613041e+01
T(RZ,    -0x1.8e147da6d528p+4,  -0x1.dbd098c4b670fp+34,  0x1.114ea8p-22, INEXACT) // -2.488000264328957200632430613041e+01
T(RD,   0x1.698c2db4c98d6p-10,   0x1.698c3537d03fdp-10,  -0x1.ffffecp-1, INEXACT) // 1.379194535908780713112653515395e-03
T(RU,   0x1.698c2db4c98d6p-10,   0x1.698c3537d03fep-10,  0x1.464014p-21, INEXACT) // 1.379194535908780713112653515395e-03
T(RZ,   0x1.698c2db4c98d6p-10,   0x1.698c3537d03fdp-10,  -0x1.ffffecp-1, INEXACT) // 1.379194535908780713112653515395e-03
T(RD,    0x1.cc913d8aef435p+6,  0x1.152806cc553b2p+165,   -0x1.fffffp-1, INEXACT) // 1.151418363293203839248235453852e+02
T(RU,    0x1.cc913d8aef435p+6,  0x1.152806cc553b3p+165,  0x1.f3578ap-22, INEXACT) // 1.151418363293203839248235453852e+02
T(RZ,    0x1.cc913d8aef435p+6,  0x1.152806cc553b2p+165,   -0x1.fffffp-1, INEXACT) // 1.151418363293203839248235453852e+02
T(RD,    -0x1.2fe0e7ac64b9p-2,   -0x1.345bbd73b5348p-2, -0x1.2437aep-22, INEXACT) // -2.967563818903551364769555220846e-01
T(RU,    -0x1.2fe0e7ac64b9p-2,   -0x1.345bbd73b5347p-2,   0x1.fffff6p-1, INEXACT) // -2.967563818903551364769555220846e-01
T(RZ,    -0x1.2fe0e7ac64b9p-2,   -0x1.345bbd73b5347p-2,   0x1.fffff6p-1, INEXACT) // -2.967563818903551364769555220846e-01
T(RD,   -0x1.d0a726a180382p+8, -0x1.46d975d0e2dc6p+669, -0x1.d4cfd2p-21, INEXACT) // -4.646529332101855516157229430974e+02
T(RU,   -0x1.d0a726a180382p+8, -0x1.46d975d0e2dc5p+669,   0x1.ffffe2p-1, INEXACT) // -4.646529332101855516157229430974e+02
T(RZ,   -0x1.d0a726a180382p+8, -0x1.46d975d0e2dc5p+669,   0x1.ffffe2p-1, INEXACT) // -4.646529332101855516157229430974e+02
T(RD,   -0x1.5d3283642c4e4p-2,   -0x1.64013a693dcecp-2,  -0x1.fffff4p-1, INEXACT) // -3.410130052462376770705532180727e-01
T(RU,   -0x1.5d3283642c4e4p-2,   -0x1.64013a693dcebp-2,  0x1.7a9d1ap-22, INEXACT) // -3.410130052462376770705532180727e-01
T(RZ,   -0x1.5d3283642c4e4p-2,   -0x1.64013a693dcebp-2,  0x1.7a9d1ap-22, INEXACT) // -3.410130052462376770705532180727e-01
T(RN,    0x1.04fcfdd96e076p-3,    0x1.05b1fa31751b6p-3,   -0x1.ffffep-2, INEXACT) // 1.274356681803998081470297165652e-01
T(RN,    0x1.692a334904888p-9,    0x1.692a513cb8e49p-9,  -0x1.ffffdap-2, INEXACT) // 2.755469093707555577887902131806e-03
T(RN,    0x1.36bc3e2aa5a4fp+9,  0x1.820b36870e956p+895,  -0x1.ffffd2p-2, INEXACT) // 6.214706471737680431033368222415e+02
T(RD,   -0x1.1bf619239df86p-2,   -0x1.1f9d5dbaec06fp-2,         -0x1p+0, INEXACT) // -2.773059776295599965223459548724e-01
T(RU,   -0x1.1bf619239df86p-2,   -0x1.1f9d5dbaec06ep-2,   0x1.a0fddp-26, INEXACT) // -2.773059776295599965223459548724e-01
T(RZ,   -0x1.1bf619239df86p-2,   -0x1.1f9d5dbaec06ep-2,   0x1.a0fddp-26, INEXACT) // -2.773059776295599965223459548724e-01
T(RN,   -0x1.e350012f7e9b8p+3,  -0x1.ba92654f1e715p+20,   0x1.ffffd2p-2, INEXACT) // -1.510351619030267045218351995572e+01
T(RD,    0x1.1c55fdb0e8361p+3,   0x1.c3a679f646ba1p+11,  -0x1.ffffeap-1, INEXACT) // 8.885496945878630370430073526222e+00
T(RU,    0x1.1c55fdb0e8361p+3,   0x1.c3a679f646ba2p+11,  0x1.59574ap-21, INEXACT) // 8.885496945878630370430073526222e+00
T(RZ,    0x1.1c55fdb0e8361p+3,   0x1.c3a679f646ba1p+11,  -0x1.ffffeap-1, INEXACT) // 8.885496945878630370430073526222e+00
T(RD,    0x1.d1dc736431955p-9,     0x1.d1dcb3abf9a2p-9, -0x1.b101acp-21, INEXACT) // 3.554238401281365703626713425933e-03
T(RU,    0x1.d1dc736431955p-9,    0x1.d1dcb3abf9a21p-9,   0x1.ffffe4p-1, INEXACT) // 3.554238401281365703626713425933e-03
T(RZ,    0x1.d1dc736431955p-9,     0x1.d1dcb3abf9a2p-9, -0x1.b101acp-21, INEXACT) // 3.554238401281365703626713425933e-03
T(RN,  -0x1.da5ad85da0f01p-10,  -0x1.da5ae954b847bp-10,  -0x1.fffffap-2, INEXACT) // -1.809520202557146845503965870705e-03
T(RN,   -0x1.f12c684c846cap-7,   -0x1.f1314a6f9c409p-7,   0x1.ffffecp-2, INEXACT) // -1.517253010482324040997248459917e-02
T(RD,   -0x1.fea3702be28c4p+7, -0x1.45c85608b64c1p+367,  -0x1.b2075p-22, INEXACT) // -2.553192151750610037197475321591e+02
T(RU,   -0x1.fea3702be28c4p+7,  -0x1.45c85608b64cp+367,   0x1.fffff2p-1, INEXACT) // -2.553192151750610037197475321591e+02
T(RZ,   -0x1.fea3702be28c4p+7,  -0x1.45c85608b64cp+367,   0x1.fffff2p-1, INEXACT) // -2.553192151750610037197475321591e+02
T(RD,    -0x1.857add62fa2bp-1,   -0x1.ac252c29bb71bp-1,   -0x1.92e7p-23, INEXACT) // -7.607030089685249407693845569156e-01
T(RU,    -0x1.857add62fa2bp-1,   -0x1.ac252c29bb71ap-1,   0x1.fffffap-1, INEXACT) // -7.607030089685249407693845569156e-01
T(RZ,    -0x1.857add62fa2bp-1,   -0x1.ac252c29bb71ap-1,   0x1.fffffap-1, INEXACT) // -7.607030089685249407693845569156e-01
T(RN,    0x1.da71cfc780aecp+5,   0x1.795ffaff15069p+84,  -0x1.ffffc8p-2, INEXACT) // 5.930557208882768804869556333870e+01
T(RD,   -0x1.11600e5499f78p+3,  -0x1.40a9685183662p+11,  -0x1.f9613p-21, INEXACT) // -8.542975583302663267204479780048e+00
T(RU,   -0x1.11600e5499f78p+3,  -0x1.40a9685183661p+11,    0x1.ffffep-1, INEXACT) // -8.542975583302663267204479780048e+00
T(RZ,   -0x1.11600e5499f78p+3,  -0x1.40a9685183661p+11,    0x1.ffffep-1, INEXACT) // -8.542975583302663267204479780048e+00
T(RD,    0x1.f985c85228916p+1,    0x1.9f13ddce74957p+4,  -0x1.fffffcp-1, INEXACT) // 3.949395218006553243128564645303e+00
T(RU,    0x1.f985c85228916p+1,    0x1.9f13ddce74958p+4,  0x1.b38006p-24, INEXACT) // 3.949395218006553243128564645303e+00
T(RZ,    0x1.f985c85228916p+1,    0x1.9f13ddce74957p+4,  -0x1.fffffcp-1, INEXACT) // 3.949395218006553243128564645303e+00
T(RD,    0x1.c7a036a994a6fp-3,    0x1.cb64c59cf5378p-3, -0x1.9337bep-21, INEXACT) // 2.224735517980493681999831778739e-01
T(RU,    0x1.c7a036a994a6fp-3,    0x1.cb64c59cf5379p-3,   0x1.ffffe6p-1, INEXACT) // 2.224735517980493681999831778739e-01
T(RZ,    0x1.c7a036a994a6fp-3,    0x1.cb64c59cf5378p-3, -0x1.9337bep-21, INEXACT) // 2.224735517980493681999831778739e-01
T(RD,   -0x1.7cb096dfee8f3p+5,  -0x1.92610651413f9p+67, -0x1.27ed2cp-24, INEXACT) // -4.758622527071738517179255723022e+01
T(RU,   -0x1.7cb096dfee8f3p+5,  -0x1.92610651413f8p+67,   0x1.fffffep-1, INEXACT) // -4.758622527071738517179255723022e+01
T(RZ,   -0x1.7cb096dfee8f3p+5,  -0x1.92610651413f8p+67,   0x1.fffffep-1, INEXACT) // -4.758622527071738517179255723022e+01
T(RD,    0x1.f126ce42b121ep+2,    0x1.27772572a4a8p+10, -0x1.babf5ep-21, INEXACT) // 7.767993512276488488055292691570e+00
T(RU,    0x1.f126ce42b121ep+2,   0x1.27772572a4a81p+10,   0x1.ffffe4p-1, INEXACT) // 7.767993512276488488055292691570e+00
T(RZ,    0x1.f126ce42b121ep+2,    0x1.27772572a4a8p+10, -0x1.babf5ep-21, INEXACT) // 7.767993512276488488055292691570e+00
T(RN,   -0x1.2f02d175ef5ccp-5,   -0x1.2f1481f433f97p-5,  -0x1.fffffcp-2, INEXACT) // -3.698864851274272225190031804232e-02
T(RN,   -0x1.6a9fc7b2f2629p-8,   -0x1.6aa040f715651p-8,  -0x1.ffffe8p-2, INEXACT) // -5.533205275193555684742907629925e-03
T(RD,   -0x1.6b78fd6eb489ep-9,   -0x1.6b791bf6561b8p-9, -0x1.9434a2p-24, INEXACT) // -2.773075996949605180608156018707e-03
T(RU,   -0x1.6b78fd6eb489ep-9,   -0x1.6b791bf6561b7p-9,   0x1.fffffcp-1, INEXACT) // -2.773075996949605180608156018707e-03
T(RZ,   -0x1.6b78fd6eb489ep-9,   -0x1.6b791bf6561b7p-9,   0x1.fffffcp-1, INEXACT) // -2.773075996949605180608156018707e-03
T(RN,    0x1.e031f83fc6573p-1,    0x1.14e0af196eac4p+0,   0x1.ffffd2p-2, INEXACT) // 9.378812387323435251218484154379e-01
T(RD,    0x1.3afe8a1874f81p+7,  0x1.2a3eae799b15ap+226, -0x1.75bdc6p-21, INEXACT) // 1.574971473353180329013412119821e+02
T(RU,    0x1.3afe8a1874f81p+7,  0x1.2a3eae799b15bp+226,   0x1.ffffe8p-1, INEXACT) // 1.574971473353180329013412119821e+02
T(RZ,    0x1.3afe8a1874f81p+7,  0x1.2a3eae799b15ap+226, -0x1.75bdc6p-21, INEXACT) // 1.574971473353180329013412119821e+02
T(RD,    0x1.9d2211b75da55p+8,  0x1.047bda1eab29cp+595, -0x1.b06c94p-25, INEXACT) // 4.131330828288676570991810876876e+02
T(RU,    0x1.9d2211b75da55p+8,  0x1.047bda1eab29dp+595,   0x1.fffffep-1, INEXACT) // 4.131330828288676570991810876876e+02
T(RZ,    0x1.9d2211b75da55p+8,  0x1.047bda1eab29cp+595, -0x1.b06c94p-25, INEXACT) // 4.131330828288676570991810876876e+02
T(RN,   -0x1.9fca72c2b99acp+6, -0x1.f3abe96913cdfp+148,  -0x1.ffffdcp-2, INEXACT) // -1.039477034021171562017116229981e+02
T(RD,    0x1.d42ff8f159a07p-3,    0x1.d846ac730bb07p-3, -0x1.c4b112p-21, INEXACT) // 2.286071251539427418020267168686e-01
T(RU,    0x1.d42ff8f159a07p-3,    0x1.d846ac730bb08p-3,   0x1.ffffe4p-1, INEXACT) // 2.286071251539427418020267168686e-01
T(RZ,    0x1.d42ff8f159a07p-3,    0x1.d846ac730bb07p-3, -0x1.c4b112p-21, INEXACT) // 2.286071251539427418020267168686e-01
T(RD,   -0x1.f75a54466a762p-3,   -0x1.fc6f923054efcp-3,  -0x1.ffffe4p-1, INEXACT) // -2.457777580250946614093265907286e-01
T(RU,   -0x1.f75a54466a762p-3,   -0x1.fc6f923054efbp-3,  0x1.cce03ep-21, INEXACT) // -2.457777580250946614093265907286e-01
T(RZ,   -0x1.f75a54466a762p-3,   -0x1.fc6f923054efbp-3,  0x1.cce03ep-21, INEXACT) // -2.457777580250946614093265907286e-01
T(RD,    0x1.81dacec5c1d7ep-3,    0x1.84243b7d18cb1p-3,  -0x1.ffffe8p-1, INEXACT) // 1.884056238270481187235816378234e-01
T(RU,    0x1.81dacec5c1d7ep-3,    0x1.84243b7d18cb2p-3,  0x1.879e8ep-21, INEXACT) // 1.884056238270481187235816378234e-01
T(RZ,    0x1.81dacec5c1d7ep-3,    0x1.84243b7d18cb1p-3,  -0x1.ffffe8p-1, INEXACT) // 1.884056238270481187235816378234e-01
T(RN,   -0x1.0143840232575p+0,   -0x1.2ece22f9291c4p+0,   0x1.ffffc4p-2, INEXACT) // -1.004936457191744070271965938446e+00
T(RD,    0x1.766fa873005b1p-9,    0x1.766fc9d36a96ep-9,  -0x1.ffffe8p-1, INEXACT) // 2.856721222543178329705826357099e-03
T(RU,    0x1.766fa873005b1p-9,    0x1.766fc9d36a96fp-9,  0x1.70abe2p-21, INEXACT) // 2.856721222543178329705826357099e-03
T(RZ,    0x1.766fa873005b1p-9,    0x1.766fc9d36a96ep-9,  -0x1.ffffe8p-1, INEXACT) // 2.856721222543178329705826357099e-03
T(RD,    0x1.719ba2eaa72ddp+3,   0x1.957ad6553a91cp+15, -0x1.1f9d28p-21, INEXACT) // 1.155024858313248081742585782195e+01
T(RU,    0x1.719ba2eaa72ddp+3,   0x1.957ad6553a91dp+15,   0x1.ffffeep-1, INEXACT) // 1.155024858313248081742585782195e+01
T(RZ,    0x1.719ba2eaa72ddp+3,   0x1.957ad6553a91cp+15, -0x1.1f9d28p-21, INEXACT) // 1.155024858313248081742585782195e+01
T(RD,   -0x1.f491d2641353bp+7,  -0x1.0f7873d75977p+360,  -0x1.ffffeap-1, INEXACT) // -2.502848082803337490531703224406e+02
T(RU,   -0x1.f491d2641353bp+7, -0x1.0f7873d75976fp+360,  0x1.665ab8p-21, INEXACT) // -2.502848082803337490531703224406e+02
T(RZ,   -0x1.f491d2641353bp+7, -0x1.0f7873d75976fp+360,  0x1.665ab8p-21, INEXACT) // -2.502848082803337490531703224406e+02
T(RN,   -0x1.4afbd6e9b2c67p+0,   -0x1.af3796779b88ep+0,  -0x1.ffffdap-2, INEXACT) // -1.292905265860804453481591735908e+00
T(RN,    0x1.059e0d39d71efp+3,   0x1.bc1f8407ad2e8p+10,   0x1.ffffdep-2, INEXACT) // 8.175543415994040330474490474444e+00
T(RN,    0x1.0a83e33dc56fep+6,   0x1.172d37759aefep+95,   0x1.ffffccp-2, INEXACT) // 6.662879654424247632960032206029e+01
T(RN,    0x1.0e764049fc979p-6,    0x1.0e796552276cap-6,  -0x1.fffffep-2, INEXACT) // 1.650768545364076148040943792239e-02
T(RD,    0x1.4c107a1fd4a7ap+7,  0x1.729f43e575b9cp+238,  -0x1.ffffeap-1, INEXACT) // 1.660321817347610817705572117120e+02
T(RU,    0x1.4c107a1fd4a7ap+7,  0x1.729f43e575b9dp+238,   0x1.637afp-21, INEXACT) // 1.660321817347610817705572117120e+02
T(RZ,    0x1.4c107a1fd4a7ap+7,  0x1.729f43e575b9cp+238,  -0x1.ffffeap-1, INEXACT) // 1.660321817347610817705572117120e+02
T(RD,    0x1.7d5d5cf02c208p-2,    0x1.863df4b61af02p-2,  -0x1.fffff8p-1, INEXACT) // 3.724264642324048857346951990621e-01
T(RU,    0x1.7d5d5cf02c208p-2,    0x1.863df4b61af03p-2,  0x1.e08cbep-23, INEXACT) // 3.724264642324048857346951990621e-01
T(RZ,    0x1.7d5d5cf02c208p-2,    0x1.863df4b61af02p-2,  -0x1.fffff8p-1, INEXACT) // 3.724264642324048857346951990621e-01
T(RD,    0x1.19fe092386502p-5,    0x1.1a0c4b159c427p-5,  -0x1.ffffeep-1, INEXACT) // 3.442289147296585805069213392926e-02
T(RU,    0x1.19fe092386502p-5,    0x1.1a0c4b159c428p-5,  0x1.282c54p-21, INEXACT) // 3.442289147296585805069213392926e-02
T(RZ,    0x1.19fe092386502p-5,    0x1.1a0c4b159c427p-5,  -0x1.ffffeep-1, INEXACT) // 3.442289147296585805069213392926e-02
T(RN,    0x1.16cdfb30e5ccep+3,    0x1.7bf4bc0d9ad4p+11,   0x1.ffffeap-2, INEXACT) // 8.712644191268193338828496052884e+00
T(RN,    0x1.ea19c61fec27dp-6,    0x1.ea2c7c70c4f44p-6,  -0x1.ffffecp-2, INEXACT) // 2.991337154498062769758526258101e-02
T(RD,   -0x1.858d7b7b5354ep-8,   -0x1.858e11d1cbf32p-8,  -0x1.fffffap-1, INEXACT) // -5.944101950558900934740158561453e-03
T(RU,   -0x1.858d7b7b5354ep-8,   -0x1.858e11d1cbf31p-8,  0x1.624554p-23, INEXACT) // -5.944101950558900934740158561453e-03
T(RZ,   -0x1.858d7b7b5354ep-8,   -0x1.858e11d1cbf31p-8,  0x1.624554p-23, INEXACT) // -5.944101950558900934740158561453e-03
T(RN,    0x1.7d3a0c523bd48p-9,    0x1.7d3a2f8c008c1p-9,   0x1.ffffc2p-2, INEXACT) // 2.908529285484160592512026255463e-03
T(RN,   -0x1.fddb7764fe058p-5,   -0x1.fe2fbfc926769p-5,   0x1.ffffe2p-2, INEXACT) // -6.223843878973472909521547080658e-02
T(RN,   0x1.d1b3dd20fdd92p-10,   0x1.d1b3ed2ebc7a2p-10,   0x1.ffffe2p-2, INEXACT) // 1.776514407763805664802747585895e-03
T(RD,   -0x1.ff18c093be283p+8, -0x1.47cbfa409329ap+736, -0x1.d9880ap-22, INEXACT) // -5.110966884936571545949846040457e+02
T(RU,   -0x1.ff18c093be283p+8, -0x1.47cbfa4093299p+736,   0x1.fffff2p-1, INEXACT) // -5.110966884936571545949846040457e+02
T(RZ,   -0x1.ff18c093be283p+8, -0x1.47cbfa4093299p+736,   0x1.fffff2p-1, INEXACT) // -5.110966884936571545949846040457e+02
T(RN,    0x1.abada25ec6c6bp+0,    0x1.48260b6c1c999p+1,   0x1.fffff8p-2, INEXACT) // 1.670618198527132447495091582823e+00
T(RD,   -0x1.67a9a13ddf9f7p-7,   -0x1.67ab7a85529c7p-7,  -0x1.fffffap-1, INEXACT) // -1.097603200082362777389999308753e-02
T(RU,   -0x1.67a9a13ddf9f7p-7,   -0x1.67ab7a85529c6p-7,  0x1.bb6fdep-23, INEXACT) // -1.097603200082362777389999308753e-02
T(RZ,   -0x1.67a9a13ddf9f7p-7,   -0x1.67ab7a85529c6p-7,  0x1.bb6fdep-23, INEXACT) // -1.097603200082362777389999308753e-02
T(RN,    0x1.ea09e4ed7087fp+4,   0x1.233b28f185a69p+43,  -0x1.ffffd2p-2, INEXACT) // 3.062741558790048301830211130437e+01
T(RN,   -0x1.e044eb9ab61fep-3,   -0x1.e4aeeabf83cdep-3,  -0x1.fffff8p-2, INEXACT) // -2.345064550961665772454978196038e-01
T(RN,   -0x1.9206db095841fp-1,   -0x1.bca185c37a835p-1,   0x1.ffffc6p-2, INEXACT) // -7.852085541636631971229576265614e-01
T(RN,    0x1.41ee7ac59e7b8p+7,  0x1.2b1c345bde735p+231,  -0x1.fffffcp-2, INEXACT) // 1.609657804256401050224667415023e+02
T(RD,   -0x1.a4115d7c85767p+8, -0x1.0556ceb077bf6p+605, -0x1.3d9716p-22, INEXACT) // -4.200678327394329585331433918327e+02
T(RU,   -0x1.a4115d7c85767p+8, -0x1.0556ceb077bf5p+605,   0x1.fffff6p-1, INEXACT) // -4.200678327394329585331433918327e+02
T(RZ,   -0x1.a4115d7c85767p+8, -0x1.0556ceb077bf5p+605,   0x1.fffff6p-1, INEXACT) // -4.200678327394329585331433918327e+02
T(RN,   -0x1.c8292f6699374p-9,   -0x1.c8296bbfb2aadp-9,  -0x1.ffffeap-2, INEXACT) // -3.480231319644417134484548626006e-03
T(RD,    0x1.b7dd0fd0a5bfcp-9,    0x1.b7dd45ec57597p-9,  -0x1.fffff6p-1, INEXACT) // 3.355892353578136463876369077752e-03
T(RU,    0x1.b7dd0fd0a5bfcp-9,    0x1.b7dd45ec57598p-9,  0x1.378a4ap-22, INEXACT) // 3.355892353578136463876369077752e-03
T(RZ,    0x1.b7dd0fd0a5bfcp-9,    0x1.b7dd45ec57597p-9,  -0x1.fffff6p-1, INEXACT) // 3.355892353578136463876369077752e-03
T(RN,    0x1.dee8eed2f9f42p-6,     0x1.defa646ce80fp-6,   0x1.ffffe6p-2, INEXACT) // 2.923034022015192495702606834129e-02
T(RN,   -0x1.2c2645c7030dcp-2,   -0x1.307748f1d4cb4p-2,   -0x1.ffffep-2, INEXACT) // -2.931147482602349807478958609863e-01
T(RD,   -0x1.ea675453c1528p-3,   -0x1.ef1a856ac1eefp-3, -0x1.7b27a2p-22, INEXACT) // -2.394548976955459540505444238079e-01
T(RU,   -0x1.ea675453c1528p-3,   -0x1.ef1a856ac1eeep-3,   0x1.fffff4p-1, INEXACT) // -2.394548976955459540505444238079e-01
T(RZ,   -0x1.ea675453c1528p-3,   -0x1.ef1a856ac1eeep-3,   0x1.fffff4p-1, INEXACT) // -2.394548976955459540505444238079e-01
T(RN,    0x1.f0b8fa6663d1fp+7,  0x1.3d46aafbda77ap+357,  -0x1.ffffd4p-2, INEXACT) // 2.483612854000902814277651486918e+02
T(RD,   -0x1.f61892e8c114cp+3,  -0x1.8dfeb24bb213ep+21, -0x1.32ee94p-22, INEXACT) // -1.569049973926362184784011333250e+01
T(RU,   -0x1.f61892e8c114cp+3,  -0x1.8dfeb24bb213dp+21,   0x1.fffff6p-1, INEXACT) // -1.569049973926362184784011333250e+01
T(RZ,   -0x1.f61892e8c114cp+3,  -0x1.8dfeb24bb213dp+21,   0x1.fffff6p-1, INEXACT) // -1.569049973926362184784011333250e+01
T(RD,    0x1.597a250dcb63bp-2,    0x1.60118b75edb19p-2,  -0x1.fffffap-1, INEXACT) // 3.373800077123154106395475082536e-01
T(RU,    0x1.597a250dcb63bp-2,    0x1.60118b75edb1ap-2,  0x1.a87374p-23, INEXACT) // 3.373800077123154106395475082536e-01
T(RZ,    0x1.597a250dcb63bp-2,    0x1.60118b75edb19p-2,  -0x1.fffffap-1, INEXACT) // 3.373800077123154106395475082536e-01
T(RD,    0x1.b56723508b2efp+2,    0x1.d0a4e2b403b6fp+8,  -0x1.ffffe2p-1, INEXACT) // 6.834420040756170600104724144330e+00
T(RU,    0x1.b56723508b2efp+2,     0x1.d0a4e2b403b7p+8,  0x1.daf2f2p-21, INEXACT) // 6.834420040756170600104724144330e+00
T(RZ,    0x1.b56723508b2efp+2,    0x1.d0a4e2b403b6fp+8,  -0x1.ffffe2p-1, INEXACT) // 6.834420040756170600104724144330e+00
T(RD,    0x1.198b9a4a8e1f6p-3,    0x1.1a6ed7a526a49p-3,  -0x1.ffffe8p-1, INEXACT) // 1.374733022692137818232538393204e-01
T(RU,    0x1.198b9a4a8e1f6p-3,    0x1.1a6ed7a526a4ap-3,  0x1.755296p-21, INEXACT) // 1.374733022692137818232538393204e-01
T(RZ,    0x1.198b9a4a8e1f6p-3,    0x1.1a6ed7a526a49p-3,  -0x1.ffffe8p-1, INEXACT) // 1.374733022692137818232538393204e-01
T(RN,   -0x1.5a86640de562cp+3,  -0x1.8a34dcc1e4efdp+14,  -0x1.fffffcp-2, INEXACT) // -1.082890513147420818995669833384e+01
T(RN,    0x1.23d32408e3fc7p-5,    0x1.23e2f142c4633p-5,   0x1.ffffcap-2, INEXACT) // 3.562314069779364683610012320969e-02
T(RD,   -0x1.11c4b173e0ba2p-6,   -0x1.11c7f45f37a55p-6,   -0x1.fffffp-1, INEXACT) // -1.670949296341073947447242176167e-02
T(RU,   -0x1.11c4b173e0ba2p-6,   -0x1.11c7f45f37a54p-6,  0x1.e7b776p-22, INEXACT) // -1.670949296341073947447242176167e-02
T(RZ,   -0x1.11c4b173e0ba2p-6,   -0x1.11c7f45f37a54p-6,  0x1.e7b776p-22, INEXACT) // -1.670949296341073947447242176167e-02
T(RN,    0x1.3b0d4d38be423p+8,  0x1.70160e4ab4f72p+453,  -0x1.ffffe4p-2, INEXACT) // 3.150519595589159393966838251799e+02
T(RD,    0x1.174c5bd06882ep-1,    0x1.255b9df059ce4p-1,         -0x1p+0, INEXACT) // 5.455044452576254254694276824011e-01
T(RU,    0x1.174c5bd06882ep-1,    0x1.255b9df059ce5p-1,   0x1.bb719p-26, INEXACT) // 5.455044452576254254694276824011e-01
T(RZ,    0x1.174c5bd06882ep-1,    0x1.255b9df059ce4p-1,         -0x1p+0, INEXACT) // 5.455044452576254254694276824011e-01
T(RD,    0x1.657da67bc99ffp+0,    0x1.e58c77e18059dp+0,  -0x1.28c34p-25, INEXACT) // 1.396448521825391031470076086407e+00
T(RU,    0x1.657da67bc99ffp+0,    0x1.e58c77e18059ep+0,   0x1.fffffep-1, INEXACT) // 1.396448521825391031470076086407e+00
T(RZ,    0x1.657da67bc99ffp+0,    0x1.e58c77e18059dp+0,  -0x1.28c34p-25, INEXACT) // 1.396448521825391031470076086407e+00
T(RN,    0x1.bca4655f4aed9p-9,     0x1.bca49d435c55p-9,   0x1.ffffdap-2, INEXACT) // 3.392350554028183712979016561917e-03
T(RD,    0x1.e26145c02af1cp-3,    0x1.e6da42ddf35eap-3, -0x1.b147d6p-21, INEXACT) // 2.355370950002616536878008446365e-01
T(RU,    0x1.e26145c02af1cp-3,    0x1.e6da42ddf35ebp-3,   0x1.ffffe4p-1, INEXACT) // 2.355370950002616536878008446365e-01
T(RZ,    0x1.e26145c02af1cp-3,    0x1.e6da42ddf35eap-3, -0x1.b147d6p-21, INEXACT) // 2.355370950002616536878008446365e-01
T(RD,    -0x1.ae582b131392p+1,   -0x1.cd0661c10a80ap+3,  -0x1.ffffecp-1, INEXACT) // -3.362065681757613333502376917750e+00
T(RU,    -0x1.ae582b131392p+1,   -0x1.cd0661c10a809p+3,  0x1.46a6a8p-21, INEXACT) // -3.362065681757613333502376917750e+00
T(RZ,    -0x1.ae582b131392p+1,   -0x1.cd0661c10a809p+3,  0x1.46a6a8p-21, INEXACT) // -3.362065681757613333502376917750e+00
T(RN,   -0x1.80741e589066fp+7, -0x1.409a461bf2fd1p+276,   0x1.fffff4p-2, INEXACT) // -1.922267940212509245156979886815e+02
T(RD,    0x1.9f82f38f8ecaep-8,    0x1.9f83aa001357ep-8,   -0x1.fffffp-1, INEXACT) // 6.340202773169751823689743730483e-03
T(RU,    0x1.9f82f38f8ecaep-8,    0x1.9f83aa001357fp-8,  0x1.f39882p-22, INEXACT) // 6.340202773169751823689743730483e-03
T(RZ,    0x1.9f82f38f8ecaep-8,    0x1.9f83aa001357ep-8,   -0x1.fffffp-1, INEXACT) // 6.340202773169751823689743730483e-03
T(RD,    0x1.1d01fc63b2911p+4,   0x1.9f800432809f6p+24,  -0x1.fffff8p-1, INEXACT) // 1.781298483795496068182728777174e+01
T(RU,    0x1.1d01fc63b2911p+4,   0x1.9f800432809f7p+24,  0x1.fb3584p-23, INEXACT) // 1.781298483795496068182728777174e+01
T(RZ,    0x1.1d01fc63b2911p+4,   0x1.9f800432809f6p+24,  -0x1.fffff8p-1, INEXACT) // 1.781298483795496068182728777174e+01
T(RN,    0x1.3bcd633bb1dd8p+5,   0x1.eed57e117dd87p+55,  -0x1.ffffe8p-2, INEXACT) // 3.947528692852546328140306286514e+01
T(RN,   -0x1.aab09768c4137p+7, -0x1.bb253feb69db8p+306,   0x1.fffffep-2, INEXACT) // -2.133449051608419893000245792791e+02
T(RD,    0x1.3b23237892f2bp-8,    0x1.3b2373101641fp-8,  -0x1.ffffecp-1, INEXACT) // 4.808612975988594932796882375214e-03
T(RU,    0x1.3b23237892f2bp-8,     0x1.3b2373101642p-8,  0x1.30feaep-21, INEXACT) // 4.808612975988594932796882375214e-03
T(RZ,    0x1.3b23237892f2bp-8,    0x1.3b2373101641fp-8,  -0x1.ffffecp-1, INEXACT) // 4.808612975988594932796882375214e-03
T(RD,    0x1.d498b30b7d413p-1,    0x1.0c67cda51ae27p+0,  -0x1.ffffeap-1, INEXACT) // 9.152275039219851526794968776812e-01
T(RU,    0x1.d498b30b7d413p-1,    0x1.0c67cda51ae28p+0,  0x1.52872ap-21, INEXACT) // 9.152275039219851526794968776812e-01
T(RZ,    0x1.d498b30b7d413p-1,    0x1.0c67cda51ae27p+0,  -0x1.ffffeap-1, INEXACT) // 9.152275039219851526794968776812e-01
T(RN,    0x1.14268b054dcabp+9,  0x1.be5db3abbebe1p+795,   0x1.fffff8p-2, INEXACT) // 5.523011175756304282913333736360e+02
T(RN,    0x1.5a8c36cad6078p-5,    0x1.5aa6ad48e0c1fp-5,   0x1.ffffe6p-2, INEXACT) // 4.230318738581301252210664642917e-02
T(RN,    0x1.b9af199d6a72dp+3,   0x1.e207942c23977p+18,  -0x1.fffff2p-2, INEXACT) // 1.380262451882625818200267531211e+01
T(RN,   -0x1.400cc9dacf4f8p-8,   -0x1.400d1d3a2941fp-8,   0x1.fffffcp-2, INEXACT) // -4.883574753703039117436190963417e-03
T(RN,    0x1.2d8e9dad564f3p+2,    0x1.bcfc74301eba1p+5,  -0x1.ffffdap-2, INEXACT) // 4.711829585337215853257930575637e+00
T(RD,   -0x1.83101f2d1f70cp+8,  -0x1.550c90ac881bp+557,  -0x1.fffffcp-1, INEXACT) // -3.870629757119902478734729811549e+02
T(RU,   -0x1.83101f2d1f70cp+8, -0x1.550c90ac881afp+557,  0x1.2f310cp-23, INEXACT) // -3.870629757119902478734729811549e+02
T(RZ,   -0x1.83101f2d1f70cp+8, -0x1.550c90ac881afp+557,  0x1.2f310cp-23, INEXACT) // -3.870629757119902478734729811549e+02
T(RD,   -0x1.9ff0975b11c45p-2,   -0x1.ab78e75099f45p-2, -0x1.4bd924p-21, INEXACT) // -4.061912202200271271301801334630e-01
T(RU,   -0x1.9ff0975b11c45p-2,   -0x1.ab78e75099f44p-2,   0x1.ffffecp-1, INEXACT) // -4.061912202200271271301801334630e-01
T(RZ,   -0x1.9ff0975b11c45p-2,   -0x1.ab78e75099f44p-2,   0x1.ffffecp-1, INEXACT) // -4.061912202200271271301801334630e-01
T(RD,   0x1.92a019c51340cp-10,   0x1.92a02424db502p-10, -0x1.d97a9cp-22, INEXACT) // 1.535893986573502560666337757311e-03
T(RU,   0x1.92a019c51340cp-10,   0x1.92a02424db503p-10,   0x1.fffff2p-1, INEXACT) // 1.535893986573502560666337757311e-03
T(RZ,   0x1.92a019c51340cp-10,   0x1.92a02424db502p-10, -0x1.d97a9cp-22, INEXACT) // 1.535893986573502560666337757311e-03
T(RN,  -0x1.081673bc9dd4dp-10,  -0x1.081676aa0cec4p-10,  -0x1.ffffe2p-2, INEXACT) // -1.007414640438703034089340526691e-03
T(RD,    0x1.04c8b17b3cc79p-4,    0x1.04f5ce597f1c2p-4,   -0x1.fffffp-1, INEXACT) // 6.366795853300456775603066716940e-02
T(RU,    0x1.04c8b17b3cc79p-4,    0x1.04f5ce597f1c3p-4,   0x1.e068fp-22, INEXACT) // 6.366795853300456775603066716940e-02
T(RZ,    0x1.04c8b17b3cc79p-4,    0x1.04f5ce597f1c2p-4,   -0x1.fffffp-1, INEXACT) // 6.366795853300456775603066716940e-02
T(RN,   -0x1.8476194b205c2p-2,   -0x1.8dd88fb29cfe5p-2,   0x1.ffffccp-2, INEXACT) // -3.793567611793059457525600919325e-01
T(RN,   -0x1.67f621b13620bp+1,   -0x1.0961ed92dc9eap+3,  -0x1.ffffe6p-2, INEXACT) // -2.812198840645810715699326465256e+00
T(RD,   -0x1.b08abbf2543e9p-1,   -0x1.e5dc452bdb7adp-1,  -0x1.ffffe8p-1, INEXACT) // -8.448084576904167919408905618184e-01
T(RU,   -0x1.b08abbf2543e9p-1,   -0x1.e5dc452bdb7acp-1,  0x1.8c908ap-21, INEXACT) // -8.448084576904167919408905618184e-01
T(RZ,   -0x1.b08abbf2543e9p-1,   -0x1.e5dc452bdb7acp-1,  0x1.8c908ap-21, INEXACT) // -8.448084576904167919408905618184e-01
T(RD,    0x1.ca14ce4faa0a1p+2,    0x1.40ee3c4a4a282p+9, -0x1.0cb6e6p-21, INEXACT) // 7.157519891545377710428965656320e+00
T(RU,    0x1.ca14ce4faa0a1p+2,    0x1.40ee3c4a4a283p+9,    0x1.fffffp-1, INEXACT) // 7.157519891545377710428965656320e+00
T(RZ,    0x1.ca14ce4faa0a1p+2,    0x1.40ee3c4a4a282p+9, -0x1.0cb6e6p-21, INEXACT) // 7.157519891545377710428965656320e+00
T(RN,   -0x1.5c5a99e25ddd6p+8, -0x1.7ba1e4551ec57p+501,    0x1.ffffep-2, INEXACT) // -3.483539105872308709876961074769e+02
T(RD,   -0x1.ca9a3ed6b8c1bp-1,   -0x1.053752ead83a1p+0,  -0x1.ffffe4p-1, INEXACT) // -8.957080494986969787518660268688e-01
T(RU,   -0x1.ca9a3ed6b8c1bp-1,    -0x1.053752ead83ap+0,  0x1.cf09e2p-21, INEXACT) // -8.957080494986969787518660268688e-01
T(RZ,   -0x1.ca9a3ed6b8c1bp-1,    -0x1.053752ead83ap+0,  0x1.cf09e2p-21, INEXACT) // -8.957080494986969787518660268688e-01
T(RN,    -0x1.374228a0444dp+5,  -0x1.1867fee1bc8ebp+55,   0x1.ffffe4p-2, INEXACT) // -3.890730405052602236537495627999e+01
T(RD,    0x1.2e19d6ae9f765p+2,    0x1.c0c8bcbe8b96bp+5, -0x1.f59528p-23, INEXACT) // 4.720327063112425669544336415129e+00
T(RU,    0x1.2e19d6ae9f765p+2,    0x1.c0c8bcbe8b96cp+5,   0x1.fffff8p-1, INEXACT) // 4.720327063112425669544336415129e+00
T(RZ,    0x1.2e19d6ae9f765p+2,    0x1.c0c8bcbe8b96bp+5, -0x1.f59528p-23, INEXACT) // 4.720327063112425669544336415129e+00
T(RD,   -0x1.c364cdf3af275p+4,  -0x1.a04c37e02c84ep+39,   -0x1.fffffp-1, INEXACT) // -2.821211047352922562936328176875e+01
T(RU,   -0x1.c364cdf3af275p+4,  -0x1.a04c37e02c84dp+39,  0x1.00dfa2p-21, INEXACT) // -2.821211047352922562936328176875e+01
T(RZ,   -0x1.c364cdf3af275p+4,  -0x1.a04c37e02c84dp+39,  0x1.00dfa2p-21, INEXACT) // -2.821211047352922562936328176875e+01
T(RN,  -0x1.f2cec2748f32ap-10,  -0x1.f2ced62e85c36p-10,   0x1.ffffeep-2, INEXACT) // -1.902800196275931336048481412604e-03
T(RD,    0x1.0e329a41ca418p-3,     0x1.0efb7174abeep-3, -0x1.d7f95cp-24, INEXACT) // 1.319324542357953600202336019720e-01
T(RU,    0x1.0e329a41ca418p-3,    0x1.0efb7174abee1p-3,   0x1.fffffcp-1, INEXACT) // 1.319324542357953600202336019720e-01
T(RZ,    0x1.0e329a41ca418p-3,     0x1.0efb7174abeep-3, -0x1.d7f95cp-24, INEXACT) // 1.319324542357953600202336019720e-01
T(RN,   -0x1.b551f425982c6p+7,   -0x1.60168cbd086p+314,   0x1.ffffd6p-2, INEXACT) // -2.186600658176668616761162411422e+02
T(RD,    -0x1.3ecc51d2010bp+3,  -0x1.4b7a195c0eb14p+13,  -0x1.ffffeep-1, INEXACT) // -9.962441358722884388043894432485e+00
T(RU,    -0x1.3ecc51d2010bp+3,  -0x1.4b7a195c0eb13p+13,  0x1.1e14e2p-21, INEXACT) // -9.962441358722884388043894432485e+00
T(RZ,    -0x1.3ecc51d2010bp+3,  -0x1.4b7a195c0eb13p+13,  0x1.1e14e2p-21, INEXACT) // -9.962441358722884388043894432485e+00
T(RD,     0x1.bf0b844e06cdp+8,  0x1.ee6aeefaf29d5p+643,   -0x1.fffffp-1, INEXACT) // 4.470449875609019727562554180622e+02
T(RU,     0x1.bf0b844e06cdp+8,  0x1.ee6aeefaf29d6p+643,  0x1.ebe1c6p-22, INEXACT) // 4.470449875609019727562554180622e+02
T(RZ,     0x1.bf0b844e06cdp+8,  0x1.ee6aeefaf29d5p+643,   -0x1.fffffp-1, INEXACT) // 4.470449875609019727562554180622e+02
T(RN,   -0x1.14a8b1682f1a6p+7, -0x1.7b50a47eccff4p+198,  -0x1.ffffdap-2, INEXACT) // -1.383294785077570736575580667704e+02
T(RD,  -0x1.faf2cdf34c4cbp-10,  -0x1.faf2e2a89293dp-10, -0x1.5c19aep-24, INEXACT) // -1.933854885305219149446709359097e-03
T(RU,  -0x1.faf2cdf34c4cbp-10,  -0x1.faf2e2a89293cp-10,   0x1.fffffep-1, INEXACT) // -1.933854885305219149446709359097e-03
T(RZ,  -0x1.faf2cdf34c4cbp-10,  -0x1.faf2e2a89293cp-10,   0x1.fffffep-1, INEXACT) // -1.933854885305219149446709359097e-03
T(RN,   -0x1.561779a6dfeecp+0,   -0x1.c563b58d781bap+0,   -0x1.ffffep-2, INEXACT) // -1.336295703164007697694160015089e+00
T(RD,    0x1.80add29bf2b79p-3,    0x1.82f1e7ea29e91p-3,  -0x1.ffffe2p-1, INEXACT) // 1.878315404740893701518444913745e-01
T(RU,    0x1.80add29bf2b79p-3,    0x1.82f1e7ea29e92p-3,  0x1.da3e06p-21, INEXACT) // 1.878315404740893701518444913745e-01
T(RZ,    0x1.80add29bf2b79p-3,    0x1.82f1e7ea29e91p-3,  -0x1.ffffe2p-1, INEXACT) // 1.878315404740893701518444913745e-01
T(RN,   0x1.8513852ff3dc7p-10,   0x1.85138e8c89e03p-10,   -0x1.ffffep-2, INEXACT) // 1.484208110912864494665419634600e-03
T(RN,   -0x1.0ca4d3544abd9p-5,   -0x1.0cb12714c7003p-5,  -0x1.fffff2p-2, INEXACT) // -3.279343867537649198640181680275e-02
T(RN,    0x1.0c447c9b43f7cp-9,    0x1.0c4488e19b0d8p-9,  -0x1.ffffe6p-2, INEXACT) // 2.046718798403844227773440422880e-03
T(RD,    0x1.c605f593a5c91p-9,    0x1.c606311493947p-9,  -0x1.fffff8p-1, INEXACT) // 3.463922717695640685758862176158e-03
T(RU,    0x1.c605f593a5c91p-9,    0x1.c606311493948p-9,  0x1.da3874p-23, INEXACT) // 3.463922717695640685758862176158e-03
T(RZ,    0x1.c605f593a5c91p-9,    0x1.c606311493947p-9,  -0x1.fffff8p-1, INEXACT) // 3.463922717695640685758862176158e-03
T(RN,   -0x1.35a951f433996p-8,   -0x1.35a99d77ec262p-8,   0x1.ffffd2p-2, INEXACT) // -4.725058086661701114983280547222e-03
T(RD,    0x1.e609cf281ee9dp+5,   0x1.91e230c844794p+86,  -0x1.ffffe6p-1, INEXACT) // 6.075478965133991238189992145635e+01
T(RU,    0x1.e609cf281ee9dp+5,   0x1.91e230c844795p+86,  0x1.a21ea4p-21, INEXACT) // 6.075478965133991238189992145635e+01
T(RZ,    0x1.e609cf281ee9dp+5,   0x1.91e230c844794p+86,  -0x1.ffffe6p-1, INEXACT) // 6.075478965133991238189992145635e+01
T(RD,   -0x1.3896d37d94036p-2,   -0x1.3d7774d1c5818p-2, -0x1.97b616p-22, INEXACT) // -3.052628560444675676066594860458e-01
T(RU,   -0x1.3896d37d94036p-2,   -0x1.3d7774d1c5817p-2,   0x1.fffff4p-1, INEXACT) // -3.052628560444675676066594860458e-01
T(RZ,   -0x1.3896d37d94036p-2,   -0x1.3d7774d1c5817p-2,   0x1.fffff4p-1, INEXACT) // -3.052628560444675676066594860458e-01
T(RN,   -0x1.689d02432d436p+3,  -0x1.321f9edba57d4p+15,  -0x1.ffffe8p-2, INEXACT) // -1.126916611786337441003524872940e+01
T(RN,   -0x1.0977d0381d7a9p-6,   -0x1.097ac979d5d3bp-6,   0x1.ffffcep-2, INEXACT) // -1.620288213640433752638081443820e-02
T(RN,   -0x1.4d6c5fe2cb49bp-7,   -0x1.4d6dd8f40fb32p-7,   0x1.ffffd2p-2, INEXACT) // -1.017527276925483080416423575798e-02
T(RD,   -0x1.fdf4207caa46ep-8,   -0x1.fdf571beb21ccp-8, -0x1.71cd5cp-21, INEXACT) // -7.781274730100580169778190509078e-03
T(RU,   -0x1.fdf4207caa46ep-8,   -0x1.fdf571beb21cbp-8,   0x1.ffffe8p-1, INEXACT) // -7.781274730100580169778190509078e-03
T(RZ,   -0x1.fdf4207caa46ep-8,   -0x1.fdf571beb21cbp-8,   0x1.ffffe8p-1, INEXACT) // -7.781274730100580169778190509078e-03
T(RD,    0x1.cccc677fd1c9bp+5,   0x1.122cea832c49dp+82,   -0x1.fffffp-1, INEXACT) // 5.759980678423854527636649436317e+01
T(RU,    0x1.cccc677fd1c9bp+5,   0x1.122cea832c49ep+82,  0x1.fef5ecp-22, INEXACT) // 5.759980678423854527636649436317e+01
T(RZ,    0x1.cccc677fd1c9bp+5,   0x1.122cea832c49dp+82,   -0x1.fffffp-1, INEXACT) // 5.759980678423854527636649436317e+01
T(RD,   -0x1.2e36ad97181f5p-8,   -0x1.2e36f3c93932dp-8, -0x1.637d7cp-21, INEXACT) // -4.611413364813622857429908918903e-03
T(RU,   -0x1.2e36ad97181f5p-8,   -0x1.2e36f3c93932cp-8,   0x1.ffffeap-1, INEXACT) // -4.611413364813622857429908918903e-03
T(RZ,   -0x1.2e36ad97181f5p-8,   -0x1.2e36f3c93932cp-8,   0x1.ffffeap-1, INEXACT) // -4.611413364813622857429908918903e-03
T(RD,    0x1.2528674f20097p+5,   0x1.d2f6ce5cc57f4p+51,  -0x1.fffff4p-1, INEXACT) // 3.664472829643744233862889814191e+01
T(RU,    0x1.2528674f20097p+5,   0x1.d2f6ce5cc57f5p+51,  0x1.7ee5fep-22, INEXACT) // 3.664472829643744233862889814191e+01
T(RZ,    0x1.2528674f20097p+5,   0x1.d2f6ce5cc57f4p+51,  -0x1.fffff4p-1, INEXACT) // 3.664472829643744233862889814191e+01
T(RN,   -0x1.242d50776ae55p+4,   -0x1.4530fd229dcdp+25,   0x1.ffffe2p-2, INEXACT) // -1.826106306693539593766217876691e+01
T(RD,    0x1.b9f42f255379cp+2,    0x1.f2e333a9438d5p+8, -0x1.fea0aap-21, INEXACT) // 6.905528818560835446760393097065e+00
T(RU,    0x1.b9f42f255379cp+2,    0x1.f2e333a9438d6p+8,    0x1.ffffep-1, INEXACT) // 6.905528818560835446760393097065e+00
T(RZ,    0x1.b9f42f255379cp+2,    0x1.f2e333a9438d5p+8, -0x1.fea0aap-21, INEXACT) // 6.905528818560835446760393097065e+00
T(RN,    0x1.3a6dc3bb899c5p+4,   0x1.46a37bbdd4bf7p+27,  -0x1.ffffe6p-2, INEXACT) // 1.965179799324848275432486843783e+01
T(RD,   -0x1.152964dfb0fe8p+9,  -0x1.a59054640693p+798,  -0x1.fffffep-1, INEXACT) // -5.543233909239033891935832798481e+02
T(RU,   -0x1.152964dfb0fe8p+9, -0x1.a59054640692fp+798,  0x1.56c882p-25, INEXACT) // -5.543233909239033891935832798481e+02
T(RZ,   -0x1.152964dfb0fe8p+9, -0x1.a59054640692fp+798,  0x1.56c882p-25, INEXACT) // -5.543233909239033891935832798481e+02
T(RN,   -0x1.f0be00119fa58p-5,   -0x1.f10bf1b1418e1p-5,  -0x1.fffff2p-2, INEXACT) // -6.063747418828729918161002387933e-02
T(RN,   -0x1.3337ed2419ef4p-8,   -0x1.333836e1e4a9ap-8,  -0x1.ffffcep-2, INEXACT) // -4.687781711346639818005499478204e-03
T(RD,    0x1.4ae87d4ec23a8p+4,   0x1.c973679179ad4p+28, -0x1.283f36p-21, INEXACT) // 2.068176012768859095558582339436e+01
T(RU,    0x1.4ae87d4ec23a8p+4,   0x1.c973679179ad5p+28,   0x1.ffffeep-1, INEXACT) // 2.068176012768859095558582339436e+01
T(RZ,    0x1.4ae87d4ec23a8p+4,   0x1.c973679179ad4p+28, -0x1.283f36p-21, INEXACT) // 2.068176012768859095558582339436e+01
T(RN,    0x1.c2f0cd9e0e20bp-8,    0x1.c2f1b6d12d11bp-8,  -0x1.ffffdap-2, INEXACT) // 6.880808066903397295088762319892e-03
T(RN,    0x1.87ef61033eab9p+3,   0x1.9756dac1f9d64p+16,  -0x1.ffffeap-2, INEXACT) // 1.224797106393576662242139718728e+01
T(RD,    0x1.d989a87cabd39p-6,     0x1.d99a895a1c27p-6, -0x1.63e7b4p-21, INEXACT) // 2.890244916733062177649493662557e-02
T(RU,    0x1.d989a87cabd39p-6,    0x1.d99a895a1c271p-6,   0x1.ffffeap-1, INEXACT) // 2.890244916733062177649493662557e-02
T(RZ,    0x1.d989a87cabd39p-6,     0x1.d99a895a1c27p-6, -0x1.63e7b4p-21, INEXACT) // 2.890244916733062177649493662557e-02
T(RN,   -0x1.4c7d1998eb02fp+7, -0x1.ca36e33f81172p+238,   0x1.ffffeap-2, INEXACT) // -1.662443359171752206293604103848e+02
T(RD,   -0x1.6adccd72f2bd8p+1,   -0x1.0f8271d84a62fp+3, -0x1.eff8d8p-22, INEXACT) // -2.834863358618786577380888047628e+00
T(RU,   -0x1.6adccd72f2bd8p+1,   -0x1.0f8271d84a62ep+3,    0x1.fffffp-1, INEXACT) // -2.834863358618786577380888047628e+00
T(RZ,   -0x1.6adccd72f2bd8p+1,   -0x1.0f8271d84a62ep+3,    0x1.fffffp-1, INEXACT) // -2.834863358618786577380888047628e+00
T(RD,    0x1.a7adb664b2b69p+6,  0x1.c0bdd590fdcf6p+151, -0x1.ea898ep-25, INEXACT) // 1.059196410879209366839859285392e+02
T(RU,    0x1.a7adb664b2b69p+6,  0x1.c0bdd590fdcf7p+151,   0x1.fffffep-1, INEXACT) // 1.059196410879209366839859285392e+02
T(RZ,    0x1.a7adb664b2b69p+6,  0x1.c0bdd590fdcf6p+151, -0x1.ea898ep-25, INEXACT) // 1.059196410879209366839859285392e+02
T(RN,    -0x1.29fdbdc1b1c7p+5,  -0x1.ab35920da226ep+52,   0x1.ffffd4p-2, INEXACT) // -3.724889708827765844034729525447e+01
T(RN,     0x1.f6ee2e444f85p-2,    0x1.05b2980cbaa03p-1,   -0x1.ffffep-2, INEXACT) // 4.911429623788352571978066407610e-01
T(RN,    0x1.837336bba885bp+3,   0x1.621175c79234ap+16,          0x1p-1, INEXACT) // 1.210781418468484638140125753125e+01
T(RN,   -0x1.76bfc10360c8bp+3,  -0x1.dc260b9ae44cep+15,  -0x1.ffffe4p-2, INEXACT) // -1.171090746555116446359079418471e+01
T(RN,   -0x1.7ff5df358e468p+4,  -0x1.89be6e693892ep+33,  -0x1.ffffdep-2, INEXACT) // -2.399752732200832383568922523409e+01
T(RD,    0x1.ffa51254c8341p+0,    0x1.cf9207eded8aep+1, -0x1.abba7ap-22, INEXACT) // 1.998612542818776427466787026788e+00
T(RU,    0x1.ffa51254c8341p+0,    0x1.cf9207eded8afp+1,   0x1.fffff2p-1, INEXACT) // 1.998612542818776427466787026788e+00
T(RZ,    0x1.ffa51254c8341p+0,    0x1.cf9207eded8aep+1, -0x1.abba7ap-22, INEXACT) // 1.998612542818776427466787026788e+00
T(RD,   -0x1.ee91e4b0e7d2ep-2,   -0x1.0102fbc8f3566p-1, -0x1.1498eap-22, INEXACT) // -4.829784138655267566875295415230e-01
T(RU,   -0x1.ee91e4b0e7d2ep-2,   -0x1.0102fbc8f3565p-1,   0x1.fffff8p-1, INEXACT) // -4.829784138655267566875295415230e-01
T(RZ,   -0x1.ee91e4b0e7d2ep-2,   -0x1.0102fbc8f3565p-1,   0x1.fffff8p-1, INEXACT) // -4.829784138655267566875295415230e-01
T(RD,   -0x1.6a4fb243c0db7p-6,   -0x1.6a57418cea862p-6, -0x1.0b1152p-21, INEXACT) // -2.211372765215255040138764286439e-02
T(RU,   -0x1.6a4fb243c0db7p-6,   -0x1.6a57418cea861p-6,    0x1.fffffp-1, INEXACT) // -2.211372765215255040138764286439e-02
T(RZ,   -0x1.6a4fb243c0db7p-6,   -0x1.6a57418cea861p-6,    0x1.fffffp-1, INEXACT) // -2.211372765215255040138764286439e-02
T(RN,  -0x1.f10ff2e2d02f6p-10,  -0x1.f1100667f38c1p-10,   0x1.ffffd2p-2, INEXACT) // -1.896142196258829900473719121123e-03
T(RD,   -0x1.b4abac3342957p+2,   -0x1.cb5ba10f7350fp+8,  -0x1.ffffe8p-1, INEXACT) // -6.822978067454037010008960351115e+00
T(RU,   -0x1.b4abac3342957p+2,   -0x1.cb5ba10f7350ep+8,   0x1.70647p-21, INEXACT) // -6.822978067454037010008960351115e+00
T(RZ,   -0x1.b4abac3342957p+2,   -0x1.cb5ba10f7350ep+8,   0x1.70647p-21, INEXACT) // -6.822978067454037010008960351115e+00
T(RN,    0x1.26d4d41ed07d2p+6,  0x1.43920628f1b1cp+105,  -0x1.ffffe6p-2, INEXACT) // 7.370784042499079191657074261457e+01
T(RN,   -0x1.0f4f467863614p-3,   -0x1.101a9b757e649p-3,   0x1.ffffeep-2, INEXACT) // -1.324754243363918115861110891274e-01
T(RD,     0x1.1d6911fff361p+4,   0x1.aa16f5de86dfep+24,  -0x1.fffff6p-1, INEXACT) // 1.783815193157903422616072930396e+01
T(RU,     0x1.1d6911fff361p+4,   0x1.aa16f5de86dffp+24,  0x1.347dc6p-22, INEXACT) // 1.783815193157903422616072930396e+01
T(RZ,     0x1.1d6911fff361p+4,   0x1.aa16f5de86dfep+24,  -0x1.fffff6p-1, INEXACT) // 1.783815193157903422616072930396e+01
T(RD,   -0x1.76239ac9c9f07p+5,  -0x1.62da2b332ec82p+66,  -0x1.623c6p-23, INEXACT) // -4.676738507888335760753761860542e+01
T(RU,   -0x1.76239ac9c9f07p+5,  -0x1.62da2b332ec81p+66,   0x1.fffffap-1, INEXACT) // -4.676738507888335760753761860542e+01
T(RZ,   -0x1.76239ac9c9f07p+5,  -0x1.62da2b332ec81p+66,   0x1.fffffap-1, INEXACT) // -4.676738507888335760753761860542e+01
T(RN,    0x1.3017db4a3d84cp-9,    0x1.3017ed2b1d5c2p-9,   0x1.ffffe8p-2, INEXACT) // 2.320046919630979961879369000144e-03
T(RD,    -0x1.f3f357adcb27p+7, -0x1.8e67d9ea16628p+359,  -0x1.fffff6p-1, INEXACT) // -2.499752783117760372988414019346e+02
T(RU,    -0x1.f3f357adcb27p+7, -0x1.8e67d9ea16627p+359,  0x1.21073ep-22, INEXACT) // -2.499752783117760372988414019346e+02
T(RZ,    -0x1.f3f357adcb27p+7, -0x1.8e67d9ea16627p+359,  0x1.21073ep-22, INEXACT) // -2.499752783117760372988414019346e+02
T(RN,   -0x1.575be51cc0dbep+8, -0x1.4913609bbb1d2p+494,  -0x1.ffffeap-2, INEXACT) // -3.433589647265288249400327913463e+02
T(RN,    0x1.48ac4424d3077p-9,    0x1.48ac5ab7aa18dp-9,  -0x1.ffffeap-2, INEXACT) // 2.507575338688335358366954253029e-03
T(RN,   -0x1.2a0b866896f5ap+5,  -0x1.ae181fb1038fbp+52,  -0x1.ffffc2p-2, INEXACT) // -3.725562745772067785310355247930e+01
T(RN,    0x1.a52ac18c68102p+1,    0x1.ad0c39fa4a7bcp+3,   -0x1.ffffcp-2, INEXACT) // 3.290367311056002996849656483391e+00
T(RD,    0x1.adc22d546c638p-2,    0x1.ba7c70c14e1c3p-2, -0x1.57ec04p-22, INEXACT) // 4.196860392358732205764226819156e-01
T(RU,    0x1.adc22d546c638p-2,    0x1.ba7c70c14e1c4p-2,   0x1.fffff6p-1, INEXACT) // 4.196860392358732205764226819156e-01
T(RZ,    0x1.adc22d546c638p-2,    0x1.ba7c70c14e1c3p-2, -0x1.57ec04p-22, INEXACT) // 4.196860392358732205764226819156e-01
T(RD,   -0x1.e109b07e71b0ap-3,    -0x1.e5792151ffbap-3, -0x1.82ff2cp-22, INEXACT) // -2.348817623698880585614290339436e-01
T(RU,   -0x1.e109b07e71b0ap-3,   -0x1.e5792151ffb9fp-3,   0x1.fffff4p-1, INEXACT) // -2.348817623698880585614290339436e-01
T(RZ,   -0x1.e109b07e71b0ap-3,   -0x1.e5792151ffb9fp-3,   0x1.fffff4p-1, INEXACT) // -2.348817623698880585614290339436e-01
T(RN,    0x1.c4d2b6179a5dep-5,    0x1.c50dc0d66cc02p-5,   0x1.ffffc2p-2, INEXACT) // 5.527625622637420688132436907836e-02
T(RN,   -0x1.9f48199b2c24bp-3,   -0x1.a2222534864ccp-3,  -0x1.fffff8p-2, INEXACT) // -2.027742386321896572720646645394e-01
T(RD,     0x1.07d9c7b6ce9fp-8,    0x1.07d9f66d815d5p-8, -0x1.14f0aep-21, INEXACT) // 4.026042230913948194448437334358e-03
T(RU,     0x1.07d9c7b6ce9fp-8,    0x1.07d9f66d815d6p-8,   0x1.ffffeep-1, INEXACT) // 4.026042230913948194448437334358e-03
T(RZ,     0x1.07d9c7b6ce9fp-8,    0x1.07d9f66d815d5p-8, -0x1.14f0aep-21, INEXACT) // 4.026042230913948194448437334358e-03
T(RD,    0x1.1f0103da4f8a6p-5,    0x1.1f100be38c897p-5,  -0x1.fffff2p-1, INEXACT) // 3.503466370101308846596310786481e-02
T(RU,    0x1.1f0103da4f8a6p-5,    0x1.1f100be38c898p-5,  0x1.d18ff8p-22, INEXACT) // 3.503466370101308846596310786481e-02
T(RZ,    0x1.1f0103da4f8a6p-5,    0x1.1f100be38c897p-5,  -0x1.fffff2p-1, INEXACT) // 3.503466370101308846596310786481e-02
T(RN,   -0x1.7fcdd6c66fad7p+3,  -0x1.3bf0a158e97d5p+16,   0x1.ffffe4p-2, INEXACT) // -1.199387682683065570188318815781e+01
T(RN,    0x1.7ea9c9239021fp+0,    0x1.0efaaa1bf33d5p+1,  -0x1.ffffcap-2, INEXACT) // 1.494778224165322688676837969979e+00
T(RN,   -0x1.a11879b231c26p-7,   -0x1.a11b5bd63941cp-7,  -0x1.fffffap-2, INEXACT) // -1.272874777022365774814538497139e-02
T(RD,    0x1.de2942a649106p-4,    0x1.df3f7adb9eefcp-4, -0x1.7b1528p-22, INEXACT) // 1.167385676859034882024701573755e-01
T(RU,    0x1.de2942a649106p-4,    0x1.df3f7adb9eefdp-4,   0x1.fffff4p-1, INEXACT) // 1.167385676859034882024701573755e-01
T(RZ,    0x1.de2942a649106p-4,    0x1.df3f7adb9eefcp-4, -0x1.7b1528p-22, INEXACT) // 1.167385676859034882024701573755e-01
T(RD,   -0x1.d2ce490c99af1p-4,   -0x1.d3d1246440891p-4,  -0x1.ffffecp-1, INEXACT) // -1.139662602887303727294820987481e-01
T(RU,   -0x1.d2ce490c99af1p-4,    -0x1.d3d124644089p-4,   0x1.45353p-21, INEXACT) // -1.139662602887303727294820987481e-01
T(RZ,   -0x1.d2ce490c99af1p-4,    -0x1.d3d124644089p-4,   0x1.45353p-21, INEXACT) // -1.139662602887303727294820987481e-01
T(RD,   -0x1.59eaeab11f4c9p+5,  -0x1.4d89ce084d931p+61, -0x1.addc88p-21, INEXACT) // -4.323970545174376667318938416429e+01
T(RU,   -0x1.59eaeab11f4c9p+5,   -0x1.4d89ce084d93p+61,   0x1.ffffe6p-1, INEXACT) // -4.323970545174376667318938416429e+01
T(RZ,   -0x1.59eaeab11f4c9p+5,   -0x1.4d89ce084d93p+61,   0x1.ffffe6p-1, INEXACT) // -4.323970545174376667318938416429e+01
T(RD,    0x1.fb82230d42aa2p+8,  0x1.21f925df2046ep+731,   -0x1.5e67p-21, INEXACT) // 5.075083473479991198473726399243e+02
T(RU,    0x1.fb82230d42aa2p+8,  0x1.21f925df2046fp+731,   0x1.ffffeap-1, INEXACT) // 5.075083473479991198473726399243e+02
T(RZ,    0x1.fb82230d42aa2p+8,  0x1.21f925df2046ep+731,   -0x1.5e67p-21, INEXACT) // 5.075083473479991198473726399243e+02
T(RD,   -0x1.9e8c4fdc0bba7p-6,   -0x1.9e97a2b898893p-6,  -0x1.ffffeep-1, INEXACT) // -2.530200766357961969510448341225e-02
T(RU,   -0x1.9e8c4fdc0bba7p-6,   -0x1.9e97a2b898892p-6,  0x1.18e5b8p-21, INEXACT) // -2.530200766357961969510448341225e-02
T(RZ,   -0x1.9e8c4fdc0bba7p-6,   -0x1.9e97a2b898892p-6,  0x1.18e5b8p-21, INEXACT) // -2.530200766357961969510448341225e-02
T(RD,    0x1.2f6e6303e05d1p-3,    0x1.308ae3aae959bp-3,  -0x1.fffffap-1, INEXACT) // 1.481597648199071415309191479537e-01
T(RU,    0x1.2f6e6303e05d1p-3,    0x1.308ae3aae959cp-3,  0x1.97ecf6p-23, INEXACT) // 1.481597648199071415309191479537e-01
T(RZ,    0x1.2f6e6303e05d1p-3,    0x1.308ae3aae959bp-3,  -0x1.fffffap-1, INEXACT) // 1.481597648199071415309191479537e-01
T(RD,    0x1.b3c1defc96217p-3,    0x1.b70d7d3572e56p-3,  -0x1.ffffe6p-1, INEXACT) // 2.127721234162584795779338264765e-01
T(RU,    0x1.b3c1defc96217p-3,    0x1.b70d7d3572e57p-3,  0x1.a452d4p-21, INEXACT) // 2.127721234162584795779338264765e-01
T(RZ,    0x1.b3c1defc96217p-3,    0x1.b70d7d3572e56p-3,  -0x1.ffffe6p-1, INEXACT) // 2.127721234162584795779338264765e-01
T(RD,   -0x1.ff0c5e1f88fefp+5,  -0x1.1e32175a79245p+91,  -0x1.fffff2p-1, INEXACT) // -6.388103890072658685994611005299e+01
T(RU,   -0x1.ff0c5e1f88fefp+5,  -0x1.1e32175a79244p+91,  0x1.b2216ap-22, INEXACT) // -6.388103890072658685994611005299e+01
T(RZ,   -0x1.ff0c5e1f88fefp+5,  -0x1.1e32175a79244p+91,  0x1.b2216ap-22, INEXACT) // -6.388103890072658685994611005299e+01
T(RN,   -0x1.e85ac9cd24c26p+2,  -0x1.0185426159c29p+10,   0x1.fffff8p-2, INEXACT) // -7.630541277251756682176164758857e+00
T(RN,    0x1.297e2fc3f835bp+3,   0x1.54abd2517a718p+12,   -0x1.ffffcp-2, INEXACT) // 9.296653635743203025754155532923e+00
T(RN,    0x1.4996397daa937p+8,  0x1.685a1ec1a572cp+474,  -0x1.ffffeep-2, INEXACT) // 3.295868147412724624700786080211e+02
T(RN,   -0x1.c5781713053b4p-2,   -0x1.d46fc56546f0ap-2,   0x1.fffffep-2, INEXACT) // -4.428409200057175088005578800221e-01
T(RN,    0x1.80d5ef94db737p-4,    0x1.8166f129f9f7ap-4,   0x1.ffffc4p-2, INEXACT) // 9.395402513993365845035299344090e-02
T(RN,    0x1.e9a5da3d319acp-3,    0x1.ee537abeb2941p-3,  -0x1.ffffe6p-2, INEXACT) // 2.390858697819572276088706530572e-01
T(RN,   -0x1.e42c02de36642p-9,   -0x1.e42c4b07a832ap-9,   0x1.ffffc4p-2, INEXACT) // -3.693938589191232170494405551153e-03
T(RD,     0x1.66b13ff42ce3p-3,    0x1.68876d417eaafp-3,  -0x1.fffffep-1, INEXACT) // 1.751427647010230792545826261630e-01
T(RU,     0x1.66b13ff42ce3p-3,     0x1.68876d417eabp-3,  0x1.52eb5ap-25, INEXACT) // 1.751427647010230792545826261630e-01
T(RZ,     0x1.66b13ff42ce3p-3,    0x1.68876d417eaafp-3,  -0x1.fffffep-1, INEXACT) // 1.751427647010230792545826261630e-01
T(RD,   -0x1.1c98d93e76feap+1,   -0x1.242dc024641f4p+2, -0x1.b3f058p-21, INEXACT) // -2.223414569378282301670424203621e+00
T(RU,   -0x1.1c98d93e76feap+1,   -0x1.242dc024641f3p+2,   0x1.ffffe4p-1, INEXACT) // -2.223414569378282301670424203621e+00
T(RZ,   -0x1.1c98d93e76feap+1,   -0x1.242dc024641f3p+2,   0x1.ffffe4p-1, INEXACT) // -2.223414569378282301670424203621e+00
T(RN,    0x1.5b58a98d736cdp-5,    0x1.5b734efdd8812p-5,   0x1.ffffcep-2, INEXACT) // 4.240067592364269583038449695778e-02
T(RD,   -0x1.b0dfc1941ac92p+4,  -0x1.05aa42cfb3c69p+38, -0x1.4c028ep-21, INEXACT) // -2.705462797025081300716919940896e+01
T(RU,   -0x1.b0dfc1941ac92p+4,  -0x1.05aa42cfb3c68p+38,   0x1.ffffecp-1, INEXACT) // -2.705462797025081300716919940896e+01
T(RZ,   -0x1.b0dfc1941ac92p+4,  -0x1.05aa42cfb3c68p+38,   0x1.ffffecp-1, INEXACT) // -2.705462797025081300716919940896e+01
T(RD,   -0x1.0dbf358c91075p+9,  -0x1.40b21887eb22p+777,  -0x1.ffffe2p-1, INEXACT) // -5.394938216884753501290106214583e+02
T(RU,   -0x1.0dbf358c91075p+9, -0x1.40b21887eb21fp+777,  0x1.e19d32p-21, INEXACT) // -5.394938216884753501290106214583e+02
T(RZ,   -0x1.0dbf358c91075p+9, -0x1.40b21887eb21fp+777,  0x1.e19d32p-21, INEXACT) // -5.394938216884753501290106214583e+02
T(RN,   -0x1.f6001d78c7fccp-3,    -0x1.fb0ae0319e29p-3,   0x1.ffffe2p-2, INEXACT) // -2.451174070820328898534512518381e-01
T(RN,   -0x1.ce140dca802edp+1,   -0x1.278216b8494a3p+4,  -0x1.ffffdcp-2, INEXACT) // -3.609986995580007462791627403931e+00
T(RN,  -0x1.422aaf7e92ed5p-10,  -0x1.422ab4cf2ce8cp-10,   0x1.fffff4p-2, INEXACT) // -1.228968583421631956612007918750e-03
T(RN,    0x1.8dc4909241944p+1,    0x1.6525c4252b25cp+3,  -0x1.ffffd6p-2, INEXACT) // 3.107561179556030950266176660080e+00
T(RD,   -0x1.53c34070d3d34p-4,   -0x1.5427083a8c5bfp-4,   -0x1.fffffp-1, INEXACT) // -8.294987842713369419200830634509e-02
T(RU,   -0x1.53c34070d3d34p-4,   -0x1.5427083a8c5bep-4,   0x1.fa67ep-22, INEXACT) // -8.294987842713369419200830634509e-02
T(RZ,   -0x1.53c34070d3d34p-4,   -0x1.5427083a8c5bep-4,   0x1.fa67ep-22, INEXACT) // -8.294987842713369419200830634509e-02
T(RN,   -0x1.ee34aee4eacc5p-3,   -0x1.f30422079f066p-3,    0x1.ffffdp-2, INEXACT) // -2.413114226922969118849238157054e-01
T(RD,   -0x1.1d26461b733d6p-4,   -0x1.1d61408a822c8p-4,  -0x1.fffffcp-1, INEXACT) // -6.961657891879666215650956928584e-02
T(RU,   -0x1.1d26461b733d6p-4,   -0x1.1d61408a822c7p-4,  0x1.94200ep-24, INEXACT) // -6.961657891879666215650956928584e-02
T(RZ,   -0x1.1d26461b733d6p-4,   -0x1.1d61408a822c7p-4,  0x1.94200ep-24, INEXACT) // -6.961657891879666215650956928584e-02
T(RN,    0x1.cbe204d2eb5b8p-9,     0x1.cbe242a947a5p-9,  -0x1.ffffd8p-2, INEXACT) // 3.508627976279678900572989164175e-03
T(RD,    0x1.5cb0c9b1d4ad6p-5,    0x1.5ccbbea4951d2p-5,  -0x1.fffff6p-1, INEXACT) // 4.256476777540789402376475436540e-02
T(RU,    0x1.5cb0c9b1d4ad6p-5,    0x1.5ccbbea4951d3p-5,  0x1.5628e6p-22, INEXACT) // 4.256476777540789402376475436540e-02
T(RZ,    0x1.5cb0c9b1d4ad6p-5,    0x1.5ccbbea4951d2p-5,  -0x1.fffff6p-1, INEXACT) // 4.256476777540789402376475436540e-02
T(RN,    0x1.19db4db08890ap+6,  0x1.94064beeed0c5p+100,  -0x1.fffffap-2, INEXACT) // 7.046416354974294904423004481941e+01
T(RN,   -0x1.c795a1c78c012p+6, -0x1.3efdd9ce43f3cp+163,  -0x1.ffffe6p-2, INEXACT) // -1.138961249522401715239539043978e+02
T(RD,    0x1.33cba7af759bcp-2,    0x1.38738c65376f4p-2,  -0x1.ffffe8p-1, INEXACT) // 3.005815697519229612311164601124e-01
T(RU,    0x1.33cba7af759bcp-2,    0x1.38738c65376f5p-2,  0x1.8e7ca4p-21, INEXACT) // 3.005815697519229612311164601124e-01
T(RZ,    0x1.33cba7af759bcp-2,    0x1.38738c65376f4p-2,  -0x1.ffffe8p-1, INEXACT) // 3.005815697519229612311164601124e-01
T(RN,     0x1.2eeebfe1cf76p+7,  0x1.6f0390428ac85p+217,    0x1.ffffep-2, INEXACT) // 1.514663076940296377870254218578e+02
T(RN,   -0x1.a96f9e8a3b5fdp-6,   -0x1.a97bdbded0a07p-6,   0x1.ffffe4p-2, INEXACT) // -2.596655352038189715213611918898e-02
T(RN,   -0x1.e8c77cea8921cp+0,   -0x1.a668a6e86061fp+1,   0x1.ffffc6p-2, INEXACT) // -1.909293944606480941672543849563e+00
T(RD,    0x1.d745bde736dd3p+6,  0x1.f769c2e76c6f3p+168, -0x1.5b9062p-22, INEXACT) // 1.178181072356449448079729336314e+02
T(RU,    0x1.d745bde736dd3p+6,  0x1.f769c2e76c6f4p+168,   0x1.fffff6p-1, INEXACT) // 1.178181072356449448079729336314e+02
T(RZ,    0x1.d745bde736dd3p+6,  0x1.f769c2e76c6f3p+168, -0x1.5b9062p-22, INEXACT) // 1.178181072356449448079729336314e+02
T(RN,   -0x1.bc7a1562902b9p+2,   -0x1.03795125f6d25p+9,   0x1.fffffep-2, INEXACT) // -6.944951387646761453709132183576e+00
T(RD,   -0x1.60ec92338698cp+3,  -0x1.e178d3e9ec90cp+14, -0x1.bd6dc2p-21, INEXACT) // -1.102887830794932000344488187693e+01
T(RU,   -0x1.60ec92338698cp+3,  -0x1.e178d3e9ec90bp+14,   0x1.ffffe4p-1, INEXACT) // -1.102887830794932000344488187693e+01
T(RZ,   -0x1.60ec92338698cp+3,  -0x1.e178d3e9ec90bp+14,   0x1.ffffe4p-1, INEXACT) // -1.102887830794932000344488187693e+01
T(RN,    0x1.58e3f320edfc6p+2,    0x1.b5ebdbefb4049p+6,  -0x1.ffffccp-2, INEXACT) // 5.388912946851581509122297575232e+00
T(RD,    0x1.7dc9d6d9d1b66p-7,    0x1.7dcc0cf5b974ep-7,  -0x1.fffff8p-1, INEXACT) // 1.165125838055098769774353684170e-02
T(RU,    0x1.7dc9d6d9d1b66p-7,    0x1.7dcc0cf5b974fp-7,  0x1.1e0f74p-22, INEXACT) // 1.165125838055098769774353684170e-02
T(RZ,    0x1.7dc9d6d9d1b66p-7,    0x1.7dcc0cf5b974ep-7,  -0x1.fffff8p-1, INEXACT) // 1.165125838055098769774353684170e-02
T(RD,   -0x1.c7d15cffebe0ap-2,   -0x1.d705498e6ddd1p-2, -0x1.fbb8d2p-21, INEXACT) // -4.451345950319313127252485173813e-01
T(RU,   -0x1.c7d15cffebe0ap-2,    -0x1.d705498e6dddp-2,    0x1.ffffep-1, INEXACT) // -4.451345950319313127252485173813e-01
T(RZ,   -0x1.c7d15cffebe0ap-2,    -0x1.d705498e6dddp-2,    0x1.ffffep-1, INEXACT) // -4.451345950319313127252485173813e-01
T(RD,    0x1.37150b63ee395p+0,    0x1.897f037a0d1ddp+0,  -0x1.fffffep-1, INEXACT) // 1.215164863488302104954641436052e+00
T(RU,    0x1.37150b63ee395p+0,    0x1.897f037a0d1dep+0,  0x1.5b1742p-25, INEXACT) // 1.215164863488302104954641436052e+00
T(RZ,    0x1.37150b63ee395p+0,    0x1.897f037a0d1ddp+0,  -0x1.fffffep-1, INEXACT) // 1.215164863488302104954641436052e+00
T(RD,    0x1.bb81cb2aa2e6dp+5,   0x1.f92f8646d6f81p+78,  -0x1.ffffe4p-1, INEXACT) // 5.543837579068790688552326173522e+01
T(RU,    0x1.bb81cb2aa2e6dp+5,   0x1.f92f8646d6f82p+78,  0x1.b9fb14p-21, INEXACT) // 5.543837579068790688552326173522e+01
T(RZ,    0x1.bb81cb2aa2e6dp+5,   0x1.f92f8646d6f81p+78,  -0x1.ffffe4p-1, INEXACT) // 5.543837579068790688552326173522e+01
T(RN,   -0x1.def6ecaed39ecp+7,   -0x1.6a02d2185a4p+344,  -0x1.ffffecp-2, INEXACT) // -2.394822744973492945064208470285e+02
T(RN,   -0x1.f275af033c72bp-3,   -0x1.f765455588922p-3,  -0x1.fffff8p-2, INEXACT) // -2.433885262358271572846746266805e-01
T(RN,   -0x1.5417022e39254p+4,  -0x1.9602b8a650bf2p+29,  -0x1.ffffc8p-2, INEXACT) // -2.125561731391856312711752252653e+01
T(RD,   -0x1.3cdb3d6be6f6cp-9,   -0x1.3cdb51a598ac9p-9,  -0x1.fffff2p-1, INEXACT) // -2.417422530880777506445689084558e-03
T(RU,   -0x1.3cdb3d6be6f6cp-9,   -0x1.3cdb51a598ac8p-9,  0x1.aa699cp-22, INEXACT) // -2.417422530880777506445689084558e-03
T(RZ,   -0x1.3cdb3d6be6f6cp-9,   -0x1.3cdb51a598ac8p-9,  0x1.aa699cp-22, INEXACT) // -2.417422530880777506445689084558e-03
T(RN,    0x1.4daf1d9c1492ep+8,  0x1.52ce76e633cc1p+480,  -0x1.fffffcp-2, INEXACT) // 3.336840455579975923683377914131e+02
T(RN,    0x1.f7c61a831cfbfp+8,  0x1.bb43aed68b27bp+725,  -0x1.ffffeep-2, INEXACT) // 5.037738420434724844199081417173e+02
T(RD,   -0x1.ec448dacc4d3dp-3,   -0x1.f1058b810c4eap-3,   -0x1.fffffp-1, INEXACT) // -2.403651302671309386571607547012e-01
T(RU,   -0x1.ec448dacc4d3dp-3,   -0x1.f1058b810c4e9p-3,  0x1.e88962p-22, INEXACT) // -2.403651302671309386571607547012e-01
T(RZ,   -0x1.ec448dacc4d3dp-3,   -0x1.f1058b810c4e9p-3,  0x1.e88962p-22, INEXACT) // -2.403651302671309386571607547012e-01
T(RN,   -0x1.5e24dbf48472dp-3,   -0x1.5fda2ef3741cap-3,  -0x1.ffffe4p-2, INEXACT) // -1.709687408443242573330422828803e-01
T(RD,     0x1.cd4cc8db7627p-5,    0x1.cd8b34875285bp-5,  -0x1.ffffeap-1, INEXACT) // 5.631102781234609278016023381497e-02
T(RU,     0x1.cd4cc8db7627p-5,    0x1.cd8b34875285cp-5,  0x1.5c8b6ap-21, INEXACT) // 5.631102781234609278016023381497e-02
T(RZ,     0x1.cd4cc8db7627p-5,    0x1.cd8b34875285bp-5,  -0x1.ffffeap-1, INEXACT) // 5.631102781234609278016023381497e-02
T(RN,    0x1.ca6e7e49ea5c6p+6,  0x1.44fd986b97b8fp+164,   0x1.ffffd2p-2, INEXACT) // 1.146079036282818321978993481025e+02
T(RN,    0x1.1b724fa5f3c88p+4,   0x1.78df431f3a8b1p+24,   0x1.ffffecp-2, INEXACT) // 1.771540798974140784594055730850e+01
T(RD,    0x1.096b8ca06ad81p-9,    0x1.096b9883c1b67p-9,  -0x1.ffffe6p-1, INEXACT) // 2.024994770371158370886321975490e-03
T(RU,    0x1.096b8ca06ad81p-9,    0x1.096b9883c1b68p-9,  0x1.96b85ep-21, INEXACT) // 2.024994770371158370886321975490e-03
T(RZ,    0x1.096b8ca06ad81p-9,    0x1.096b9883c1b67p-9,  -0x1.ffffe6p-1, INEXACT) // 2.024994770371158370886321975490e-03
T(RD,    0x1.62dc155e02b6ap-2,    0x1.6a014e013cd71p-2, -0x1.fd3226p-23, INEXACT) // 3.465426767949596476015017287864e-01
T(RU,    0x1.62dc155e02b6ap-2,    0x1.6a014e013cd72p-2,   0x1.fffff8p-1, INEXACT) // 3.465426767949596476015017287864e-01
T(RZ,    0x1.62dc155e02b6ap-2,    0x1.6a014e013cd71p-2, -0x1.fd3226p-23, INEXACT) // 3.465426767949596476015017287864e-01
T(RN,   -0x1.80629b1a240b4p-2,   -0x1.8979e1d74df41p-2,   0x1.ffffecp-2, INEXACT) // -3.753761515336109244600493184407e-01
T(RN,   -0x1.5445476d76a95p+2,   -0x1.976c3e8f80024p+6,   0x1.ffffc8p-2, INEXACT) // -5.316728455446214418600447970675e+00
T(RN,   -0x1.29357e851eb72p+6,  -0x1.25254916e646p+106,  -0x1.ffffeap-2, INEXACT) // -7.430224044799777516345784533769e+01
T(RN,    0x1.1013fdcb7d023p-1,    0x1.1d10bea46d401p-1,  -0x1.ffffecp-2, INEXACT) // 5.314025221728154724232240369020e-01
T(RN,   -0x1.1db56fd865395p-6,   -0x1.1db924d842ef8p-6,  -0x1.ffffdap-2, INEXACT) // -1.743827745811506527151557577326e-02
T(RN,    0x1.bcf707e4ae211p-4,    0x1.bdd736b8c2ebap-4,  -0x1.ffffd6p-2, INEXACT) // 1.086340244609192012825715778490e-01
T(RN,   -0x1.89b0230de9315p+7, -0x1.fb042027efffcp+282,   0x1.ffffcap-2, INEXACT) // -1.968440174433859795044554630294e+02
T(RD,   -0x1.04580666065e5p-6,   -0x1.045ad46b049a2p-6, -0x1.77a026p-21, INEXACT) // -1.589012741906072403996752484545e-02
T(RU,   -0x1.04580666065e5p-6,   -0x1.045ad46b049a1p-6,   0x1.ffffe8p-1, INEXACT) // -1.589012741906072403996752484545e-02
T(RZ,   -0x1.04580666065e5p-6,   -0x1.045ad46b049a1p-6,   0x1.ffffe8p-1, INEXACT) // -1.589012741906072403996752484545e-02
T(RN,   -0x1.6ae8dc714ad45p+2,    -0x1.222a528dc4fbp+7,   0x1.ffffd4p-2, INEXACT) // -5.670462713849080849115580349462e+00
T(RD,   -0x1.4b4b1358ec934p+7, -0x1.f81a5901e701bp+237,  -0x1.fffff4p-1, INEXACT) // -1.656466319836414413657621480525e+02
T(RU,   -0x1.4b4b1358ec934p+7, -0x1.f81a5901e701ap+237,  0x1.66dee8p-22, INEXACT) // -1.656466319836414413657621480525e+02
T(RZ,   -0x1.4b4b1358ec934p+7, -0x1.f81a5901e701ap+237,  0x1.66dee8p-22, INEXACT) // -1.656466319836414413657621480525e+02
T(RN,    0x1.76ea4e653d614p-2,    0x1.7f59098bd174ep-2,   0x1.ffffe6p-2, INEXACT) // 3.661281823436592919307486226899e-01
T(RN,   -0x1.969c59a0dd37ap+6, -0x1.92c60dd3a193dp+145,   0x1.ffffecp-2, INEXACT) // -1.016526856551189723631978267804e+02
T(RD,    0x1.6054d6a3c2967p+3,   0x1.d8a2def59cc48p+14,  -0x1.293b9p-21, INEXACT) // 1.101035625442882626146001712186e+01
T(RU,    0x1.6054d6a3c2967p+3,   0x1.d8a2def59cc49p+14,   0x1.ffffeep-1, INEXACT) // 1.101035625442882626146001712186e+01
T(RZ,    0x1.6054d6a3c2967p+3,   0x1.d8a2def59cc48p+14,  -0x1.293b9p-21, INEXACT) // 1.101035625442882626146001712186e+01
T(RN,   -0x1.15bae5a071d4dp+7, -0x1.440291d273772p+199,  -0x1.ffffeep-2, INEXACT) // -1.388650331629709455683041596785e+02
T(RN,    0x1.ace5e36c95742p+8,  0x1.b440a7503d7bep+617,   0x1.ffffccp-2, INEXACT) // 4.288980014672162042188574559987e+02
T(RD,   -0x1.dc12b3938f487p-1,   -0x1.11d9c339faeebp+0,  -0x1.40899p-22, INEXACT) // -9.298301808954797520456736492633e-01
T(RU,   -0x1.dc12b3938f487p-1,   -0x1.11d9c339faeeap+0,   0x1.fffff6p-1, INEXACT) // -9.298301808954797520456736492633e-01
T(RZ,   -0x1.dc12b3938f487p-1,   -0x1.11d9c339faeeap+0,   0x1.fffff6p-1, INEXACT) // -9.298301808954797520456736492633e-01
T(RD,   -0x1.dc148abf9749ap+6, -0x1.a2aa22ac216a6p+170, -0x1.ad63acp-21, INEXACT) // -1.190200605331505414596904302016e+02
T(RU,   -0x1.dc148abf9749ap+6, -0x1.a2aa22ac216a5p+170,   0x1.ffffe6p-1, INEXACT) // -1.190200605331505414596904302016e+02
T(RZ,   -0x1.dc148abf9749ap+6, -0x1.a2aa22ac216a5p+170,   0x1.ffffe6p-1, INEXACT) // -1.190200605331505414596904302016e+02
T(RD,    -0x1.92fc7c3b779ep-9,   -0x1.92fca5d72ffc6p-9,  -0x1.fffffap-1, INEXACT) // -3.074541249346682270093822353374e-03
T(RU,    -0x1.92fc7c3b779ep-9,   -0x1.92fca5d72ffc5p-9,  0x1.631accp-23, INEXACT) // -3.074541249346682270093822353374e-03
T(RZ,    -0x1.92fc7c3b779ep-9,   -0x1.92fca5d72ffc5p-9,  0x1.631accp-23, INEXACT) // -3.074541249346682270093822353374e-03
T(RN,   -0x1.d50024d38176fp+3,  -0x1.1af9491548022p+20,  -0x1.fffffap-2, INEXACT) // -1.465626756009780073952697421191e+01
T(RD,    0x1.3c51229c27cd8p+9,  0x1.9f394675303d5p+911,  -0x1.ffffeap-1, INEXACT) // 6.326338687128400124493055045605e+02
T(RU,    0x1.3c51229c27cd8p+9,  0x1.9f394675303d6p+911,  0x1.630ba2p-21, INEXACT) // 6.326338687128400124493055045605e+02
T(RZ,    0x1.3c51229c27cd8p+9,  0x1.9f394675303d5p+911,  -0x1.ffffeap-1, INEXACT) // 6.326338687128400124493055045605e+02
T(RN,   -0x1.4e2cba3c20e16p-2,   -0x1.542350cb552dcp-2,  -0x1.ffffd2p-2, INEXACT) // -3.263424967956053412976302752213e-01
T(RN,    0x1.a27d0e5585ebdp-6,    0x1.a288b4a63bde2p-6,  -0x1.ffffeap-2, INEXACT) // 2.554251098453507243246640712186e-02
T(RN,    0x1.4b68311caba0dp-4,    0x1.4bc4c9e4df9dep-4,   0x1.ffffeep-2, INEXACT) // 8.090991196034043320128859022589e-02
T(RD,    0x1.9e83e23cadd18p-2,    0x1.a9edcc93490eep-2, -0x1.b425ccp-23, INEXACT) // 4.047999715362080586089632561198e-01
T(RU,    0x1.9e83e23cadd18p-2,    0x1.a9edcc93490efp-2,   0x1.fffffap-1, INEXACT) // 4.047999715362080586089632561198e-01
T(RZ,    0x1.9e83e23cadd18p-2,    0x1.a9edcc93490eep-2, -0x1.b425ccp-23, INEXACT) // 4.047999715362080586089632561198e-01
T(RD,    0x1.a4c87c8599072p+6,  0x1.b32bf54f47b41p+150, -0x1.2c8f78p-22, INEXACT) // 1.051957875132227684389363275841e+02
T(RU,    0x1.a4c87c8599072p+6,  0x1.b32bf54f47b42p+150,   0x1.fffff6p-1, INEXACT) // 1.051957875132227684389363275841e+02
T(RZ,    0x1.a4c87c8599072p+6,  0x1.b32bf54f47b41p+150, -0x1.2c8f78p-22, INEXACT) // 1.051957875132227684389363275841e+02
T(RN,   -0x1.9b3e5018fadedp-4,   -0x1.9bef46d7fef4bp-4,   0x1.ffffdcp-2, INEXACT) // -1.004012230693473589626663056151e-01
T(RD,    0x1.15a849145a5bfp-3,    0x1.16823c1b2dd32p-3, -0x1.97e9e8p-25, INEXACT) // 1.355748853050453284208032300739e-01
T(RU,    0x1.15a849145a5bfp-3,    0x1.16823c1b2dd33p-3,   0x1.fffffep-1, INEXACT) // 1.355748853050453284208032300739e-01
T(RZ,    0x1.15a849145a5bfp-3,    0x1.16823c1b2dd32p-3, -0x1.97e9e8p-25, INEXACT) // 1.355748853050453284208032300739e-01
T(RD,    0x1.b900bed0554e6p+7,  0x1.1580a19f36e39p+317,   -0x1.fffffp-1, INEXACT) // 2.205014557937749373195401858538e+02
T(RU,    0x1.b900bed0554e6p+7,  0x1.1580a19f36e3ap+317,  0x1.0e6b16p-21, INEXACT) // 2.205014557937749373195401858538e+02
T(RZ,    0x1.b900bed0554e6p+7,  0x1.1580a19f36e39p+317,   -0x1.fffffp-1, INEXACT) // 2.205014557937749373195401858538e+02
T(RD,   -0x1.0fbf12c2b2efap+8, -0x1.0881736c3cbd5p+391, -0x1.b6f98cp-23, INEXACT) // -2.717463800131660036640823818743e+02
T(RU,   -0x1.0fbf12c2b2efap+8, -0x1.0881736c3cbd4p+391,   0x1.fffffap-1, INEXACT) // -2.717463800131660036640823818743e+02
T(RZ,   -0x1.0fbf12c2b2efap+8, -0x1.0881736c3cbd4p+391,   0x1.fffffap-1, INEXACT) // -2.717463800131660036640823818743e+02
T(RN,   -0x1.d9a51a6068dacp-7,   -0x1.d9a9534af69fap-7,   0x1.ffffeep-2, INEXACT) // -1.445449626846236762522934782282e-02
T(RD,     0x1.7ce525515195p-4,    0x1.7d71bde050649p-4,  -0x1.ffffeep-1, INEXACT) // 9.299196793754060941239458770724e-02
T(RU,     0x1.7ce525515195p-4,    0x1.7d71bde05064ap-4,  0x1.218ceap-21, INEXACT) // 9.299196793754060941239458770724e-02
T(RZ,     0x1.7ce525515195p-4,    0x1.7d71bde050649p-4,  -0x1.ffffeep-1, INEXACT) // 9.299196793754060941239458770724e-02
T(RN,   -0x1.568a4c447631ep+5,  -0x1.b558eb60e3044p+60,   0x1.fffffcp-2, INEXACT) // -4.281752828107549646574625512585e+01
T(RN,    0x1.fad760a611b8ep-9,    0x1.fad7b36dbce22p-9,   -0x1.ffffcp-2, INEXACT) // 3.866892383516291019363020353694e-03
T(RN,   -0x1.0e3229a759f23p-9,   -0x1.0e323631f1fe7p-9,  -0x1.fffff8p-2, INEXACT) // -2.061431488687663540065875267260e-03
T(RD,    0x1.f6a2420cc6f58p-1,    0x1.25acd099f6342p+0,  -0x1.fffffep-1, INEXACT) // 9.817066803548000208934354304802e-01
T(RU,    0x1.f6a2420cc6f58p-1,    0x1.25acd099f6343p+0,  0x1.7a95b8p-25, INEXACT) // 9.817066803548000208934354304802e-01
T(RZ,    0x1.f6a2420cc6f58p-1,    0x1.25acd099f6342p+0,  -0x1.fffffep-1, INEXACT) // 9.817066803548000208934354304802e-01
T(RN,     0x1.ac6521a25b09p+6,  0x1.6cc5a7de468eep+153,   0x1.ffffeep-2, INEXACT) // 1.070987611167968225345248356462e+02
T(RD,    0x1.4903eaa41bdf1p-7,    0x1.490554f33f06cp-7,   -0x1.ffffep-1, INEXACT) // 1.004075009424718230299777843584e-02
T(RU,    0x1.4903eaa41bdf1p-7,    0x1.490554f33f06dp-7,  0x1.ff2d7ap-21, INEXACT) // 1.004075009424718230299777843584e-02
T(RZ,    0x1.4903eaa41bdf1p-7,    0x1.490554f33f06cp-7,   -0x1.ffffep-1, INEXACT) // 1.004075009424718230299777843584e-02
T(RD,   -0x1.312b5e5b28adfp-7,    -0x1.312c7f75b624p-7,  -0x1.ffffeap-1, INEXACT) // -9.313031265553771073650857204029e-03
T(RU,   -0x1.312b5e5b28adfp-7,   -0x1.312c7f75b623fp-7,  0x1.5ea49ap-21, INEXACT) // -9.313031265553771073650857204029e-03
T(RZ,   -0x1.312b5e5b28adfp-7,   -0x1.312c7f75b623fp-7,  0x1.5ea49ap-21, INEXACT) // -9.313031265553771073650857204029e-03
T(RD,     0x1.e487d3c67116p+4,   0x1.9cd1b48297569p+42,  -0x1.fffff4p-1, INEXACT) // 3.028316094890885779022937640548e+01
T(RU,     0x1.e487d3c67116p+4,   0x1.9cd1b4829756ap+42,  0x1.7807c6p-22, INEXACT) // 3.028316094890885779022937640548e+01
T(RZ,     0x1.e487d3c67116p+4,   0x1.9cd1b48297569p+42,  -0x1.fffff4p-1, INEXACT) // 3.028316094890885779022937640548e+01
T(RD,    0x1.3384437658115p+8,  0x1.9279615013cf8p+442, -0x1.270c2ap-24, INEXACT) // 3.075166543927201132646587211639e+02
T(RU,    0x1.3384437658115p+8,  0x1.9279615013cf9p+442,   0x1.fffffep-1, INEXACT) // 3.075166543927201132646587211639e+02
T(RZ,    0x1.3384437658115p+8,  0x1.9279615013cf8p+442, -0x1.270c2ap-24, INEXACT) // 3.075166543927201132646587211639e+02
T(RD,   -0x1.2dc8a00318781p+5,  -0x1.5728764ca754bp+53, -0x1.21b7c4p-21, INEXACT) // -3.772296144884513324768704478629e+01
T(RU,   -0x1.2dc8a00318781p+5,  -0x1.5728764ca754ap+53,   0x1.ffffeep-1, INEXACT) // -3.772296144884513324768704478629e+01
T(RZ,   -0x1.2dc8a00318781p+5,  -0x1.5728764ca754ap+53,   0x1.ffffeep-1, INEXACT) // -3.772296144884513324768704478629e+01
T(RN,    0x1.7b6c79ba57037p+8,  0x1.5019076c92979p+546,    0x1.fffffp-2, INEXACT) // 3.794237324201998831085802521557e+02
T(RN,   -0x1.c7124efe6b697p+3,  -0x1.6e36de672354ap+19,  -0x1.ffffcep-2, INEXACT) // -1.422098493281673192711878073169e+01
T(RN,   -0x1.ee1e276235feap-2,   -0x1.00c23d07365a2p-1,    0x1.ffffcp-2, INEXACT) // -4.825369027798830368070071017428e-01
T(RD,    0x1.82d629224b0ccp+5,   0x1.b1cdcd91c4838p+68, -0x1.e44c64p-21, INEXACT) // 4.835457064429792239934613462538e+01
T(RU,    0x1.82d629224b0ccp+5,   0x1.b1cdcd91c4839p+68,   0x1.ffffe2p-1, INEXACT) // 4.835457064429792239934613462538e+01
T(RZ,    0x1.82d629224b0ccp+5,   0x1.b1cdcd91c4838p+68, -0x1.e44c64p-21, INEXACT) // 4.835457064429792239934613462538e+01
T(RN,   -0x1.bafae44f69419p+6, -0x1.b4efadd4ad1d6p+158,  -0x1.ffffe8p-2, INEXACT) // -1.107450115592950083964751684107e+02
T(RN,    0x1.c286ba567272fp+8,  0x1.f62b6f6c2646fp+648,   0x1.fffffcp-2, INEXACT) // 4.505262807874123041074199136347e+02
T(RD,    0x1.83c011b909ec2p-8,    0x1.83c0a5fbc40c2p-8,   -0x1.ffffep-1, INEXACT) // 5.916599585397088259530740117498e-03
T(RU,    0x1.83c011b909ec2p-8,    0x1.83c0a5fbc40c3p-8,  0x1.f62dfap-21, INEXACT) // 5.916599585397088259530740117498e-03
T(RZ,    0x1.83c011b909ec2p-8,    0x1.83c0a5fbc40c2p-8,   -0x1.ffffep-1, INEXACT) // 5.916599585397088259530740117498e-03
T(RD,    0x1.69ab3da849d9ep+7,  0x1.da132b499295dp+259, -0x1.736e6ap-21, INEXACT) // 1.808344547834539639552531298250e+02
T(RU,    0x1.69ab3da849d9ep+7,  0x1.da132b499295ep+259,   0x1.ffffe8p-1, INEXACT) // 1.808344547834539639552531298250e+02
T(RZ,    0x1.69ab3da849d9ep+7,  0x1.da132b499295dp+259, -0x1.736e6ap-21, INEXACT) // 1.808344547834539639552531298250e+02
T(RD,   -0x1.5c457153eb83cp+2,   -0x1.cdad78a471f59p+6,  -0x1.ffffeap-1, INEXACT) // -5.441738445237259469422497204505e+00
T(RU,   -0x1.5c457153eb83cp+2,   -0x1.cdad78a471f58p+6,  0x1.5e20eap-21, INEXACT) // -5.441738445237259469422497204505e+00
T(RZ,   -0x1.5c457153eb83cp+2,   -0x1.cdad78a471f58p+6,  0x1.5e20eap-21, INEXACT) // -5.441738445237259469422497204505e+00
T(RN,    0x1.1329f7ae8da85p-6,    0x1.132d476f62afep-6,   0x1.ffffc8p-2, INEXACT) // 1.679467380219048025513650657103e-02
T(RD,   -0x1.e7b9029cb1601p-3,   -0x1.ec588a33ae2d8p-3, -0x1.94ac76p-24, INEXACT) // -2.381458477085942881945612725758e-01
T(RU,   -0x1.e7b9029cb1601p-3,   -0x1.ec588a33ae2d7p-3,   0x1.fffffcp-1, INEXACT) // -2.381458477085942881945612725758e-01
T(RZ,   -0x1.e7b9029cb1601p-3,   -0x1.ec588a33ae2d7p-3,   0x1.fffffcp-1, INEXACT) // -2.381458477085942881945612725758e-01
T(RD,   -0x1.4af22b3eaca11p+8, -0x1.5eb46a06f59c5p+476,  -0x1.fffff8p-1, INEXACT) // -3.309459723636110197730886284262e+02
T(RU,   -0x1.4af22b3eaca11p+8, -0x1.5eb46a06f59c4p+476,  0x1.c0ec24p-23, INEXACT) // -3.309459723636110197730886284262e+02
T(RZ,   -0x1.4af22b3eaca11p+8, -0x1.5eb46a06f59c4p+476,  0x1.c0ec24p-23, INEXACT) // -3.309459723636110197730886284262e+02
T(RD,   -0x1.4b7c74640e57dp-9,   -0x1.4b7c8b8c8f4d5p-9,  -0x1.5f636p-21, INEXACT) // -2.529038627497369549207428818249e-03
T(RU,   -0x1.4b7c74640e57dp-9,   -0x1.4b7c8b8c8f4d4p-9,   0x1.ffffeap-1, INEXACT) // -2.529038627497369549207428818249e-03
T(RZ,   -0x1.4b7c74640e57dp-9,   -0x1.4b7c8b8c8f4d4p-9,   0x1.ffffeap-1, INEXACT) // -2.529038627497369549207428818249e-03
T(RD,   -0x1.409d063d261ccp-4,   -0x1.40f0dd0e89de3p-4, -0x1.96e958p-22, INEXACT) // -7.827475010925083465096463442023e-02
T(RU,   -0x1.409d063d261ccp-4,   -0x1.40f0dd0e89de2p-4,   0x1.fffff4p-1, INEXACT) // -7.827475010925083465096463442023e-02
T(RZ,   -0x1.409d063d261ccp-4,   -0x1.40f0dd0e89de2p-4,   0x1.fffff4p-1, INEXACT) // -7.827475010925083465096463442023e-02
T(RN,   -0x1.1599126adc5bbp+5,  -0x1.0b1552d2d7366p+49,   -0x1.fffffp-2, INEXACT) // -3.469974215970020026134079671465e+01
T(RN,   -0x1.99bbb5142a20cp+0,   -0x1.303e9392fcfe1p+1,  -0x1.ffffdep-2, INEXACT) // -1.600520436690319847627961280523e+00
T(RD,   -0x1.53efae01addefp+5,  -0x1.3bd69e465ef17p+60, -0x1.0d6c68p-22, INEXACT) // -4.249203110992299770032332162373e+01
T(RU,   -0x1.53efae01addefp+5,  -0x1.3bd69e465ef16p+60,   0x1.fffff8p-1, INEXACT) // -4.249203110992299770032332162373e+01
T(RZ,   -0x1.53efae01addefp+5,  -0x1.3bd69e465ef16p+60,   0x1.fffff8p-1, INEXACT) // -4.249203110992299770032332162373e+01
T(RN,    0x1.a0cc9ea479034p-7,    0x1.a0cf7f360e8e1p-7,   0x1.ffffe2p-2, INEXACT) // 1.271970506872586309521366843001e-02
T(RN,    0x1.5253e32e75d85p-1,    0x1.6b7e258f11b09p-1,   0x1.ffffccp-2, INEXACT) // 6.607962602819702491174780334404e-01
T(RN,   -0x1.201b920ae355fp+7, -0x1.c5c18abbc451dp+206,   0x1.ffffcap-2, INEXACT) // -1.440538485910901442821341333911e+02
T(RD,  -0x1.e6a914214a493p-10,  -0x1.e6a926733a557p-10, -0x1.32c5b8p-21, INEXACT) // -1.856462339058038936087657866381e-03
T(RU,  -0x1.e6a914214a493p-10,  -0x1.e6a926733a556p-10,   0x1.ffffecp-1, INEXACT) // -1.856462339058038936087657866381e-03
T(RZ,  -0x1.e6a914214a493p-10,  -0x1.e6a926733a556p-10,   0x1.ffffecp-1, INEXACT) // -1.856462339058038936087657866381e-03
T(RN,    -0x1.8a3638936824p+7, -0x1.4966e23ed1073p+283,  -0x1.fffff2p-2, INEXACT) // -1.971059003891587053658440709114e+02
T(RN,   -0x1.ae074f9807fe6p-2,   -0x1.bac7c1b1d03b1p-2,   0x1.fffff6p-2, INEXACT) // -4.199497639219756939255034922098e-01
T(RN,    0x1.bb13a29fa3e3dp+3,    0x1.f778ce392f39p+18,   0x1.ffffc6p-2, INEXACT) // 1.384614688091016354576368030393e+01
T(RD,    0x1.9e91124de3e1dp+7,  0x1.0869caf6fb969p+298, -0x1.6da406p-21, INEXACT) // 2.072833427754093520434253150597e+02
T(RU,    0x1.9e91124de3e1dp+7,  0x1.0869caf6fb96ap+298,   0x1.ffffeap-1, INEXACT) // 2.072833427754093520434253150597e+02
T(RZ,    0x1.9e91124de3e1dp+7,  0x1.0869caf6fb969p+298, -0x1.6da406p-21, INEXACT) // 2.072833427754093520434253150597e+02
T(RN,   -0x1.a7e12769eb299p+6, -0x1.d7dc3af4ca13bp+151,  -0x1.ffffc6p-2, INEXACT) // -1.059698769140035352620543562807e+02
T(RN,  -0x1.cd4332b4a389bp-10,  -0x1.cd43424df386fp-10,   0x1.ffffeep-2, INEXACT) // -1.759576768708670828009199560427e-03
T(RN,   -0x1.600de3f8514bap-9,   -0x1.600dffb6451f9p-9,  -0x1.ffffd6p-2, INEXACT) // -2.685960844390847430951385632625e-03
T(RN,   -0x1.ee6ab591ee95dp-5,    -0x1.eeb7903f8538p-5,  -0x1.ffffdep-2, INEXACT) // -6.035361731433639548294323162736e-02
T(RD,    0x1.1bd8dfebda824p+9,  0x1.01beadced464ap+818,  -0x1.ffffe8p-1, INEXACT) // 5.676943335358560034364927560091e+02
T(RU,    0x1.1bd8dfebda824p+9,  0x1.01beadced464bp+818,   0x1.7093bp-21, INEXACT) // 5.676943335358560034364927560091e+02
T(RZ,    0x1.1bd8dfebda824p+9,  0x1.01beadced464ap+818,  -0x1.ffffe8p-1, INEXACT) // 5.676943335358560034364927560091e+02
T(RD,   -0x1.d28ced51a97b9p-7,   -0x1.d290f6633c0aep-7, -0x1.b2017cp-24, INEXACT) // -1.423799121705458976816505156648e-02
T(RU,   -0x1.d28ced51a97b9p-7,   -0x1.d290f6633c0adp-7,   0x1.fffffcp-1, INEXACT) // -1.423799121705458976816505156648e-02
T(RZ,   -0x1.d28ced51a97b9p-7,   -0x1.d290f6633c0adp-7,   0x1.fffffcp-1, INEXACT) // -1.423799121705458976816505156648e-02
T(RN,   -0x1.dde5c87a0a7fdp+7, -0x1.a8aeca2fdb8a6p+343,  -0x1.fffffep-2, INEXACT) // -2.389487951410118569128826493397e+02
T(RD,   -0x1.9eb0ece3ec0dbp+0,   -0x1.36b1c0ae9c9c9p+1, -0x1.d28cbcp-21, INEXACT) // -1.619887166638412479002795407723e+00
T(RU,   -0x1.9eb0ece3ec0dbp+0,   -0x1.36b1c0ae9c9c8p+1,   0x1.ffffe2p-1, INEXACT) // -1.619887166638412479002795407723e+00
T(RZ,   -0x1.9eb0ece3ec0dbp+0,   -0x1.36b1c0ae9c9c8p+1,   0x1.ffffe2p-1, INEXACT) // -1.619887166638412479002795407723e+00
T(RD,    0x1.9c895c0f0b6d3p+7,   0x1.7f45ab3c3317p+296,  -0x1.ffffeap-1, INEXACT) // 2.062682804776619320819008862600e+02
T(RU,    0x1.9c895c0f0b6d3p+7,  0x1.7f45ab3c33171p+296,  0x1.503c0ap-21, INEXACT) // 2.062682804776619320819008862600e+02
T(RZ,    0x1.9c895c0f0b6d3p+7,   0x1.7f45ab3c3317p+296,  -0x1.ffffeap-1, INEXACT) // 2.062682804776619320819008862600e+02
T(RN,   -0x1.2ff68d5a7664p-10,  -0x1.2ff691d13681bp-10,  -0x1.ffffc4p-2, INEXACT) // -1.159527184987033110452614437236e-03
T(RN,    0x1.fd29af140cf34p+1,    0x1.ab0f74ec1b04dp+4,  -0x1.ffffc8p-2, INEXACT) // 3.977834591665578400920821877662e+00
T(RD,   -0x1.c75889c906034p+5,  -0x1.155ddb3efb1f6p+81, -0x1.929e24p-22, INEXACT) // -5.691823155450438775915245059878e+01
T(RU,   -0x1.c75889c906034p+5,  -0x1.155ddb3efb1f5p+81,   0x1.fffff4p-1, INEXACT) // -5.691823155450438775915245059878e+01
T(RZ,   -0x1.c75889c906034p+5,  -0x1.155ddb3efb1f5p+81,   0x1.fffff4p-1, INEXACT) // -5.691823155450438775915245059878e+01
T(RN,    0x1.c632656db2962p+2,    0x1.2e08080506ba1p+9,  -0x1.ffffd4p-2, INEXACT) // 7.096825940252843523126102809329e+00
T(RD,    0x1.d3e56ea6a1957p+7,  0x1.6e05115eb1f8ap+336, -0x1.f44968p-22, INEXACT) // 2.339481098243947769788064761087e+02
T(RU,    0x1.d3e56ea6a1957p+7,  0x1.6e05115eb1f8bp+336,    0x1.fffffp-1, INEXACT) // 2.339481098243947769788064761087e+02
T(RZ,    0x1.d3e56ea6a1957p+7,  0x1.6e05115eb1f8ap+336, -0x1.f44968p-22, INEXACT) // 2.339481098243947769788064761087e+02
T(RD,    0x1.e52969be40d54p-7,    0x1.e52df370f89d6p-7, -0x1.24a3fep-24, INEXACT) // 1.480596221200040224497129770498e-02
T(RU,    0x1.e52969be40d54p-7,    0x1.e52df370f89d7p-7,   0x1.fffffep-1, INEXACT) // 1.480596221200040224497129770498e-02
T(RZ,    0x1.e52969be40d54p-7,    0x1.e52df370f89d6p-7, -0x1.24a3fep-24, INEXACT) // 1.480596221200040224497129770498e-02
T(RD,    0x1.5687140d8125ap+1,    0x1.cea7dde5cb96dp+2,  -0x1.fffff6p-1, INEXACT) // 2.675997263521179725387355574640e+00
T(RU,    0x1.5687140d8125ap+1,    0x1.cea7dde5cb96ep+2,  0x1.23d49ep-22, INEXACT) // 2.675997263521179725387355574640e+00
T(RZ,    0x1.5687140d8125ap+1,    0x1.cea7dde5cb96dp+2,  -0x1.fffff6p-1, INEXACT) // 2.675997263521179725387355574640e+00
T(RN,   -0x1.7dc307c0c4be1p-4,   -0x1.7e5096a5fea96p-4,  -0x1.fffff6p-2, INEXACT) // -9.320357349888254427927591905245e-02
T(RD,  -0x1.d5ef4fe2e15c2p-10,  -0x1.d5ef6061b12efp-10, -0x1.d3311ap-21, INEXACT) // -1.792659045095277171172343244621e-03
T(RU,  -0x1.d5ef4fe2e15c2p-10,  -0x1.d5ef6061b12eep-10,   0x1.ffffe2p-1, INEXACT) // -1.792659045095277171172343244621e-03
T(RZ,  -0x1.d5ef4fe2e15c2p-10,  -0x1.d5ef6061b12eep-10,   0x1.ffffe2p-1, INEXACT) // -1.792659045095277171172343244621e-03
T(RD,    0x1.a590b3cf23c24p+1,    0x1.ae636cddc6d23p+3,  -0x1.5ebc6p-22, INEXACT) // 3.293478466169760920934095338453e+00
T(RU,    0x1.a590b3cf23c24p+1,    0x1.ae636cddc6d24p+3,   0x1.fffff6p-1, INEXACT) // 3.293478466169760920934095338453e+00
T(RZ,    0x1.a590b3cf23c24p+1,    0x1.ae636cddc6d23p+3,  -0x1.5ebc6p-22, INEXACT) // 3.293478466169760920934095338453e+00
T(RD,   -0x1.fbbeadf849dbcp+7, -0x1.32a83be895951p+365,  -0x1.fffff6p-1, INEXACT) // -2.538724210348281076221610419452e+02
T(RU,   -0x1.fbbeadf849dbcp+7,  -0x1.32a83be89595p+365,  0x1.458002p-22, INEXACT) // -2.538724210348281076221610419452e+02
T(RZ,   -0x1.fbbeadf849dbcp+7,  -0x1.32a83be89595p+365,  0x1.458002p-22, INEXACT) // -2.538724210348281076221610419452e+02
T(RD,    0x1.93f47b1bdf94ap-3,    0x1.969454cd90ea1p-3,  -0x1.ffffeep-1, INEXACT) // 1.972436540490412615334037127468e-01
T(RU,    0x1.93f47b1bdf94ap-3,    0x1.969454cd90ea2p-3,  0x1.2ad486p-21, INEXACT) // 1.972436540490412615334037127468e-01
T(RZ,    0x1.93f47b1bdf94ap-3,    0x1.969454cd90ea1p-3,  -0x1.ffffeep-1, INEXACT) // 1.972436540490412615334037127468e-01
T(RN,    0x1.471f96c5a25a9p-4,    0x1.4778a400bd80cp-4,  -0x1.fffffcp-2, INEXACT) // 7.986410994830940579536360246493e-02
T(RN,   -0x1.8028aeb668694p-9,   -0x1.8028d2c1dbc6bp-9,  -0x1.ffffeap-2, INEXACT) // -2.930899932110994990375196778132e-03
T(RD,     -0x1.248abb67c79p-2,   -0x1.28899d03d27c1p-2, -0x1.390558p-23, INEXACT) // -2.856854707805638327045016922057e-01
T(RU,     -0x1.248abb67c79p-2,    -0x1.28899d03d27cp-2,   0x1.fffffcp-1, INEXACT) // -2.856854707805638327045016922057e-01
T(RZ,     -0x1.248abb67c79p-2,    -0x1.28899d03d27cp-2,   0x1.fffffcp-1, INEXACT) // -2.856854707805638327045016922057e-01
T(RN,   -0x1.f2b20962b1c5bp+8, -0x1.6179615baa769p+718,   0x1.ffffcep-2, INEXACT) // -4.986954557117475701488729100674e+02
T(RD,   0x1.427977aaa6562p-10,   0x1.42797cff276d7p-10,  -0x1.ffffeap-1, INEXACT) // 1.230142525548615518166117865917e-03
T(RU,   0x1.427977aaa6562p-10,   0x1.42797cff276d8p-10,  0x1.5d1f14p-21, INEXACT) // 1.230142525548615518166117865917e-03
T(RZ,   0x1.427977aaa6562p-10,   0x1.42797cff276d7p-10,  -0x1.ffffeap-1, INEXACT) // 1.230142525548615518166117865917e-03
T(RD,    0x1.83ec3f7adf87dp+2,    0x1.aced8f4308fedp+7, -0x1.48848cp-21, INEXACT) // 6.061294431680036787213339266600e+00
T(RU,    0x1.83ec3f7adf87dp+2,    0x1.aced8f4308feep+7,   0x1.ffffecp-1, INEXACT) // 6.061294431680036787213339266600e+00
T(RZ,    0x1.83ec3f7adf87dp+2,    0x1.aced8f4308fedp+7, -0x1.48848cp-21, INEXACT) // 6.061294431680036787213339266600e+00
T(RD,   -0x1.38f85dd4e8023p-6,   -0x1.38fd3d3b36464p-6, -0x1.514d4ep-22, INEXACT) // -1.910218394516517356751528211589e-02
T(RU,   -0x1.38f85dd4e8023p-6,   -0x1.38fd3d3b36463p-6,   0x1.fffff6p-1, INEXACT) // -1.910218394516517356751528211589e-02
T(RZ,   -0x1.38f85dd4e8023p-6,   -0x1.38fd3d3b36463p-6,   0x1.fffff6p-1, INEXACT) // -1.910218394516517356751528211589e-02
T(RD,    0x1.b2fb00498bf5fp-6,    0x1.b3081546146bfp-6,  -0x1.fffff6p-1, INEXACT) // 2.654910114341590618436406145975e-02
T(RU,    0x1.b2fb00498bf5fp-6,     0x1.b3081546146cp-6,  0x1.3926d6p-22, INEXACT) // 2.654910114341590618436406145975e-02
T(RZ,    0x1.b2fb00498bf5fp-6,    0x1.b3081546146bfp-6,  -0x1.fffff6p-1, INEXACT) // 2.654910114341590618436406145975e-02
T(RD,   -0x1.241a5a04f9be6p+4,  -0x1.43b079273f5e8p+25, -0x1.afddc6p-23, INEXACT) // -1.825643350547388621407662867568e+01
T(RU,   -0x1.241a5a04f9be6p+4,  -0x1.43b079273f5e7p+25,   0x1.fffffap-1, INEXACT) // -1.825643350547388621407662867568e+01
T(RZ,   -0x1.241a5a04f9be6p+4,  -0x1.43b079273f5e7p+25,   0x1.fffffap-1, INEXACT) // -1.825643350547388621407662867568e+01
T(RD,    -0x1.bdd0af89ab91p-9,    -0x1.bdd0e7df4672p-9,  -0x1.ffffeep-1, INEXACT) // -3.401299884749360569191622971630e-03
T(RU,    -0x1.bdd0af89ab91p-9,   -0x1.bdd0e7df4671fp-9,  0x1.2742fep-21, INEXACT) // -3.401299884749360569191622971630e-03
T(RZ,    -0x1.bdd0af89ab91p-9,   -0x1.bdd0e7df4671fp-9,  0x1.2742fep-21, INEXACT) // -3.401299884749360569191622971630e-03
T(RN,    0x1.0593a1c86bee3p-3,    0x1.0649d8653cd32p-3,   0x1.ffffecp-2, INEXACT) // 1.277229918755359017179529246278e-01
T(RD,   -0x1.5d87738a4e4dfp-7,   -0x1.5d8925ee87e5cp-7,  -0x1.ffffe4p-1, INEXACT) // -1.066678182233932008216026332548e-02
T(RU,   -0x1.5d87738a4e4dfp-7,   -0x1.5d8925ee87e5bp-7,  0x1.cd9b3ep-21, INEXACT) // -1.066678182233932008216026332548e-02
T(RZ,   -0x1.5d87738a4e4dfp-7,   -0x1.5d8925ee87e5bp-7,  0x1.cd9b3ep-21, INEXACT) // -1.066678182233932008216026332548e-02
T(RN,   -0x1.002af2602959fp+8, -0x1.7c8de1ad3c97ap+368,  -0x1.ffffdep-2, INEXACT) // -2.561677608586268775070493575186e+02
T(RN,   -0x1.25a4fabdb3fd2p-9,   -0x1.25a50ad6d05e5p-9,  -0x1.ffffd8p-2, INEXACT) // -2.240329368625262364267403114582e-03
T(RN,   -0x1.2f69c4626df8ep+9, -0x1.616f68aee4fb2p+874,  -0x1.ffffe4p-2, INEXACT) // -6.068263056790326572809135541320e+02
T(RN,     0x1.5d254aea2602p+1,    0x1.e76f03441d49fp+2,    0x1.ffffep-2, INEXACT) // 2.727700580911928796012944076210e+00
T(RD,    0x1.2ee9cfd65c9a3p-9,    0x1.2ee9e1822b286p-9, -0x1.d33c5ap-24, INEXACT) // 2.311045285005878992951044992310e-03
T(RU,    0x1.2ee9cfd65c9a3p-9,    0x1.2ee9e1822b287p-9,   0x1.fffffcp-1, INEXACT) // 2.311045285005878992951044992310e-03
T(RZ,    0x1.2ee9cfd65c9a3p-9,    0x1.2ee9e1822b286p-9, -0x1.d33c5ap-24, INEXACT) // 2.311045285005878992951044992310e-03
T(RD,   -0x1.d09b38540e165p+2,    -0x1.63607effcc21p+9,   -0x1.ffffep-1, INEXACT) // -7.259473878941524738195312238531e+00
T(RU,   -0x1.d09b38540e165p+2,   -0x1.63607effcc20fp+9,  0x1.f2dc38p-21, INEXACT) // -7.259473878941524738195312238531e+00
T(RZ,   -0x1.d09b38540e165p+2,   -0x1.63607effcc20fp+9,  0x1.f2dc38p-21, INEXACT) // -7.259473878941524738195312238531e+00
T(RD,    -0x1.abfcee21b2dcp-8,    -0x1.abfdb580f9c5p-8, -0x1.7b86dep-21, INEXACT) // -6.530578744512849365122519884608e-03
T(RU,    -0x1.abfcee21b2dcp-8,   -0x1.abfdb580f9c4fp-8,   0x1.ffffe8p-1, INEXACT) // -6.530578744512849365122519884608e-03
T(RZ,    -0x1.abfcee21b2dcp-8,   -0x1.abfdb580f9c4fp-8,   0x1.ffffe8p-1, INEXACT) // -6.530578744512849365122519884608e-03
T(RD,   -0x1.ad228024775c8p+6, -0x1.b6dec24736a9ap+153,  -0x1.ffffeap-1, INEXACT) // -1.072836919496395466921967454255e+02
T(RU,   -0x1.ad228024775c8p+6, -0x1.b6dec24736a99p+153,  0x1.5b79fap-21, INEXACT) // -1.072836919496395466921967454255e+02
T(RZ,   -0x1.ad228024775c8p+6, -0x1.b6dec24736a99p+153,  0x1.5b79fap-21, INEXACT) // -1.072836919496395466921967454255e+02
T(RD,    0x1.e391460425609p+6,   0x1.542ac0a8fe95p+173,  -0x1.ffffeep-1, INEXACT) // 1.208918686530888777497239061631e+02
T(RU,    0x1.e391460425609p+6,  0x1.542ac0a8fe951p+173,  0x1.258338p-21, INEXACT) // 1.208918686530888777497239061631e+02
T(RZ,    0x1.e391460425609p+6,   0x1.542ac0a8fe95p+173,  -0x1.ffffeep-1, INEXACT) // 1.208918686530888777497239061631e+02
T(RN,    0x1.eeb2c36a12a6cp-5,    0x1.eeffbfb7808afp-5,   0x1.fffff8p-2, INEXACT) // 6.038797537674586712874713612109e-02
T(RN,   -0x1.b72dcaedc8e85p+3,  -0x1.bdbbbdf45d07cp+18,   0x1.ffffc2p-2, INEXACT) // -1.372433992807715164019555231789e+01
T(RN,    0x1.3288573d4ef8fp+9,  0x1.619f8f50d4fb5p+883,  -0x1.ffffdap-2, INEXACT) // 6.130651623378379326823051087558e+02
T(RN,    0x1.7bebf2e638a78p-2,    0x1.84b2b95facb2bp-2,  -0x1.ffffe6p-2, INEXACT) // 3.710172608390744919404369284166e-01
T(RD,    0x1.2c551150d9eb3p+3,    0x1.7447e0714b08p+12,  -0x1.dc6a4p-22, INEXACT) // 9.385384233391368624666029063519e+00
T(RU,    0x1.2c551150d9eb3p+3,   0x1.7447e0714b081p+12,   0x1.fffff2p-1, INEXACT) // 9.385384233391368624666029063519e+00
T(RZ,    0x1.2c551150d9eb3p+3,    0x1.7447e0714b08p+12,  -0x1.dc6a4p-22, INEXACT) // 9.385384233391368624666029063519e+00
T(RD,    -0x1.da569ccb9cfdp+7, -0x1.1e93abac9816ap+341,  -0x1.fffffcp-1, INEXACT) // -2.371691650036941609869245439768e+02
T(RU,    -0x1.da569ccb9cfdp+7, -0x1.1e93abac98169p+341,   0x1.3173dp-23, INEXACT) // -2.371691650036941609869245439768e+02
T(RZ,    -0x1.da569ccb9cfdp+7, -0x1.1e93abac98169p+341,   0x1.3173dp-23, INEXACT) // -2.371691650036941609869245439768e+02
T(RD,    0x1.e52836362d0adp-6,    0x1.e53a5d05a52f1p-6,  -0x1.ffffecp-1, INEXACT) // 2.961163801292403599529912128219e-02
T(RU,    0x1.e52836362d0adp-6,    0x1.e53a5d05a52f2p-6,  0x1.3a9c24p-21, INEXACT) // 2.961163801292403599529912128219e-02
T(RZ,    0x1.e52836362d0adp-6,    0x1.e53a5d05a52f1p-6,  -0x1.ffffecp-1, INEXACT) // 2.961163801292403599529912128219e-02
T(RN,   -0x1.1759be0ee4edep-9,   -0x1.1759cbeb02014p-9,  -0x1.ffffc4p-2, INEXACT) // -2.131275606595524861608392797052e-03
T(RN,    0x1.1547eb271abf6p+7,  0x1.02d6da3daf582p+199,   0x1.fffff2p-2, INEXACT) // 1.386404659481192425118933897465e+02
T(RN,     0x1.bea9cc746d7bp+8,  0x1.5188f46284316p+643,  -0x1.ffffe4p-2, INEXACT) // 4.466632759825979519519023597240e+02
T(RN,   -0x1.47d3eab0c298ap-3,   -0x1.493ac6510c0c7p-3,  -0x1.fffff6p-2, INEXACT) // -1.600721678917803036945599615137e-01
T(RN,    0x1.dd936c0ec5dd1p-7,    0x1.dd97c01c58c14p-7,   0x1.ffffd6p-2, INEXACT) // 1.457445884947975063561376174448e-02
T(RD,    0x1.511fd57f8cb4dp+1,    0x1.bb58912b4c13dp+2,  -0x1.ffffeap-1, INEXACT) // 2.633783995895476071069651879952e+00
T(RU,    0x1.511fd57f8cb4dp+1,    0x1.bb58912b4c13ep+2,  0x1.5e2068p-21, INEXACT) // 2.633783995895476071069651879952e+00
T(RZ,    0x1.511fd57f8cb4dp+1,    0x1.bb58912b4c13dp+2,  -0x1.ffffeap-1, INEXACT) // 2.633783995895476071069651879952e+00
T(RD,    0x1.ab1d909887ff9p+1,    0x1.c1833b14af5a7p+3,  -0x1.fffffep-1, INEXACT) // 3.336839746931215433534134717775e+00
T(RU,    0x1.ab1d909887ff9p+1,    0x1.c1833b14af5a8p+3,  0x1.16413ap-24, INEXACT) // 3.336839746931215433534134717775e+00
T(RZ,    0x1.ab1d909887ff9p+1,    0x1.c1833b14af5a7p+3,  -0x1.fffffep-1, INEXACT) // 3.336839746931215433534134717775e+00
T(RN,   -0x1.0b3014a58b0e1p-3,   -0x1.0bf247beeda25p-3,   0x1.ffffdcp-2, INEXACT) // -1.304628003139276792854417408307e-01
T(RD,   -0x1.aafc2776377eep-2,   -0x1.b77760e081cd9p-2,  -0x1.fffff6p-1, INEXACT) // -4.169775167373462876341250193946e-01
T(RU,   -0x1.aafc2776377eep-2,   -0x1.b77760e081cd8p-2,  0x1.2d738ap-22, INEXACT) // -4.169775167373462876341250193946e-01
T(RZ,   -0x1.aafc2776377eep-2,   -0x1.b77760e081cd8p-2,  0x1.2d738ap-22, INEXACT) // -4.169775167373462876341250193946e-01
T(RN,   -0x1.b1e363a4ddf49p+1,   -0x1.d9ff7d05f88cbp+3,   0x1.fffff6p-2, INEXACT) // -3.389751868726226025074765857426e+00
T(RN,   -0x1.fe0f9b0c565fcp+1,   -0x1.ae11ce3a9f969p+4,   -0x1.fffffp-2, INEXACT) // -3.984851246856804252161055046599e+00
T(RD,    0x1.700ae5be947d1p-5,    0x1.702a98b63cd01p-5,  -0x1.ffffe6p-1, INEXACT) // 4.492707130397344955641258934520e-02
T(RU,    0x1.700ae5be947d1p-5,    0x1.702a98b63cd02p-5,  0x1.9b11a8p-21, INEXACT) // 4.492707130397344955641258934520e-02
T(RZ,    0x1.700ae5be947d1p-5,    0x1.702a98b63cd01p-5,  -0x1.ffffe6p-1, INEXACT) // 4.492707130397344955641258934520e-02
T(RN,    -0x1.57dc8ee4c4b5p-3,   -0x1.597abda173716p-3,  -0x1.ffffd2p-2, INEXACT) // -1.679011500896998576592977769906e-01
T(RN,    0x1.5fe5af1b94cbep-9,    0x1.5fe5cad008771p-9,  -0x1.ffffe8p-2, INEXACT) // 2.684762597519345893315456663686e-03
T(RN,     0x1.125e691cde45p+3,   0x1.4ac632187eff4p+11,  -0x1.fffff4p-2, INEXACT) // 8.574024731047899194891215302050e+00
T(RN,     0x1.c5e549b7af49p-9,    0x1.c5e5852bc5898p-9,   -0x1.ffffdp-2, INEXACT) // 3.462949036331659791176917906341e-03
T(RN,   -0x1.6e2e28b1987dcp+6, -0x1.0d07f178b66aep+131,   0x1.ffffdap-2, INEXACT) // -9.154507710927231300956918857992e+01
T(RN,   -0x1.3bb04148d3509p-2,   -0x1.40b683c35f1ffp-2,   0x1.fffffap-2, INEXACT) // -3.082895470332265852597686262015e-01
T(RN,    0x1.afa9ecf190fe9p+2,    0x1.a8ca8f3b3a7d7p+8,  -0x1.ffffe2p-2, INEXACT) // 6.744746433167144950004967540735e+00
T(RN,    0x1.a9d691c77ac26p-4,    0x1.aa9b0ed960bb9p-4,  -0x1.ffffe4p-2, INEXACT) // 1.039643949986134019436434527961e-01
T(RD,   -0x1.e6cde68591adcp-3,   -0x1.eb66be8909843p-3,  -0x1.ffffe2p-1, INEXACT) // -2.376974114906350576958971032582e-01
T(RU,   -0x1.e6cde68591adcp-3,   -0x1.eb66be8909842p-3,  0x1.e8fb42p-21, INEXACT) // -2.376974114906350576958971032582e-01
T(RZ,   -0x1.e6cde68591adcp-3,   -0x1.eb66be8909842p-3,  0x1.e8fb42p-21, INEXACT) // -2.376974114906350576958971032582e-01
T(RN,    0x1.291abead2f2c7p+9,  0x1.330affc4a2b5dp+856,   0x1.ffffc8p-2, INEXACT) // 5.942089439850177541302400641143e+02
T(RN,   -0x1.b3eeff58ccf47p+4,  -0x1.3cce135e8e4e5p+38,  -0x1.ffffeap-2, INEXACT) // -2.724584898650871522818306402769e+01
T(RN,    0x1.4480669025aa2p+6,  0x1.070d194e41f4cp+116,   -0x1.ffffep-2, INEXACT) // 8.112539124708067106439557392150e+01
T(RD,   -0x1.54ac7459f004ep+9, -0x1.f7aed24272658p+981, -0x1.84525ep-22, INEXACT) // -6.813473007604568465467309579253e+02
T(RU,   -0x1.54ac7459f004ep+9, -0x1.f7aed24272657p+981,   0x1.fffff4p-1, INEXACT) // -6.813473007604568465467309579253e+02
T(RZ,   -0x1.54ac7459f004ep+9, -0x1.f7aed24272657p+981,   0x1.fffff4p-1, INEXACT) // -6.813473007604568465467309579253e+02
T(RD,   -0x1.335838c5d9fd4p+9, -0x1.c08b6888d9358p+885,   -0x1.ffffep-1, INEXACT) // -6.146892325701141999161336570978e+02
T(RU,   -0x1.335838c5d9fd4p+9, -0x1.c08b6888d9357p+885,  0x1.fecbeap-21, INEXACT) // -6.146892325701141999161336570978e+02
T(RZ,   -0x1.335838c5d9fd4p+9, -0x1.c08b6888d9357p+885,  0x1.fecbeap-21, INEXACT) // -6.146892325701141999161336570978e+02
T(RD,     0x1.ca5239d207bcp-6,     0x1.ca6187614d1cp-6, -0x1.26e5cap-21, INEXACT) // 2.797370573545854277597300097113e-02
T(RU,     0x1.ca5239d207bcp-6,    0x1.ca6187614d1c1p-6,   0x1.ffffeep-1, INEXACT) // 2.797370573545854277597300097113e-02
T(RZ,     0x1.ca5239d207bcp-6,     0x1.ca6187614d1cp-6, -0x1.26e5cap-21, INEXACT) // 2.797370573545854277597300097113e-02
T(RN,    -0x1.27bcb7b4bfb8p+3,  -0x1.427bb0174083ap+12,   0x1.ffffe6p-2, INEXACT) // -9.241786816621015532291494309902e+00
T(RD,   -0x1.d145d622638d2p+6, -0x1.c1591fe3bb02cp+166,  -0x1.fffffap-1, INEXACT) // -1.163181996701489708812005119398e+02
T(RU,   -0x1.d145d622638d2p+6, -0x1.c1591fe3bb02bp+166,  0x1.6a3c26p-23, INEXACT) // -1.163181996701489708812005119398e+02
T(RZ,   -0x1.d145d622638d2p+6, -0x1.c1591fe3bb02bp+166,  0x1.6a3c26p-23, INEXACT) // -1.163181996701489708812005119398e+02
T(RN,   -0x1.6fbdf2d2dd4aep+5,  -0x1.3f01b164f2058p+65,  -0x1.fffff6p-2, INEXACT) // -4.596774830568152481191646074876e+01
T(RD,    0x1.fbc604188b2dap+6,  0x1.1a335ee2b0aa6p+182, -0x1.57758ap-22, INEXACT) // 1.269433749995181699432578170672e+02
T(RU,    0x1.fbc604188b2dap+6,  0x1.1a335ee2b0aa7p+182,   0x1.fffff6p-1, INEXACT) // 1.269433749995181699432578170672e+02
T(RZ,    0x1.fbc604188b2dap+6,  0x1.1a335ee2b0aa6p+182, -0x1.57758ap-22, INEXACT) // 1.269433749995181699432578170672e+02
T(RD,   -0x1.d1e31505934e9p+5,  -0x1.02f7204bee038p+83, -0x1.99d404p-21, INEXACT) // -5.823587993961138664644749951549e+01
T(RU,   -0x1.d1e31505934e9p+5,  -0x1.02f7204bee037p+83,   0x1.ffffe6p-1, INEXACT) // -5.823587993961138664644749951549e+01
T(RZ,   -0x1.d1e31505934e9p+5,  -0x1.02f7204bee037p+83,   0x1.ffffe6p-1, INEXACT) // -5.823587993961138664644749951549e+01
T(RD,    0x1.f34b6d5f0f04ap-3,    0x1.f84163279db63p-3, -0x1.1e3e9cp-22, INEXACT) // 2.437962097773172520653872652474e-01
T(RU,    0x1.f34b6d5f0f04ap-3,    0x1.f84163279db64p-3,   0x1.fffff8p-1, INEXACT) // 2.437962097773172520653872652474e-01
T(RZ,    0x1.f34b6d5f0f04ap-3,    0x1.f84163279db63p-3, -0x1.1e3e9cp-22, INEXACT) // 2.437962097773172520653872652474e-01
T(RN,    0x1.39760dd49177fp+2,    0x1.0bfb898cda3c6p+6,   0x1.fffffep-2, INEXACT) // 4.897830445848625480209648230812e+00
T(RN,   -0x1.29f0e22f6d872p+4,  -0x1.d238a0c9f3272p+25,   0x1.fffff4p-2, INEXACT) // -1.862130945707799156707551446743e+01
T(RN,    0x1.0f1376df96c99p-6,    0x1.0f16a166cc50fp-6,  -0x1.fffffap-2, INEXACT) // 1.654516800622882546911718293359e-02
T(RD,   -0x1.96de35eb86a2fp-4,   -0x1.9789958a64fe3p-4, -0x1.27916ap-22, INEXACT) // -9.933301031598128216781873334185e-02
T(RU,   -0x1.96de35eb86a2fp-4,   -0x1.9789958a64fe2p-4,   0x1.fffff6p-1, INEXACT) // -9.933301031598128216781873334185e-02
T(RZ,   -0x1.96de35eb86a2fp-4,   -0x1.9789958a64fe2p-4,   0x1.fffff6p-1, INEXACT) // -9.933301031598128216781873334185e-02
T(RN,    0x1.2efc095a652e6p+7,   0x1.78a9bba9cd3bp+217,  -0x1.fffffap-2, INEXACT) // 1.514922588585388325554959010333e+02
T(RD,   -0x1.d5fb20f95508cp+0,   -0x1.871bbf6124a24p+1,  -0x1.ffffe4p-1, INEXACT) // -1.835863171455488718208926002262e+00
T(RU,   -0x1.d5fb20f95508cp+0,   -0x1.871bbf6124a23p+1,  0x1.b72192p-21, INEXACT) // -1.835863171455488718208926002262e+00
T(RZ,   -0x1.d5fb20f95508cp+0,   -0x1.871bbf6124a23p+1,  0x1.b72192p-21, INEXACT) // -1.835863171455488718208926002262e+00
T(RN,   -0x1.df2226a8a1ca7p-7,   -0x1.df268596a2086p-7,  -0x1.ffffd6p-2, INEXACT) // -1.462199103958845662620813499188e-02
T(RN,    0x1.7f7728bcda8d2p-7,    0x1.7f796656ee9c1p-7,    0x1.fffffp-2, INEXACT) // 1.170243729730594331450710399167e-02
T(RD,    0x1.d1977895e620dp-3,    0x1.d59cd45f7c146p-3,  -0x1.ffffe4p-1, INEXACT) // 2.273396893258596007658667303986e-01
T(RU,    0x1.d1977895e620dp-3,    0x1.d59cd45f7c147p-3,  0x1.c9757ep-21, INEXACT) // 2.273396893258596007658667303986e-01
T(RZ,    0x1.d1977895e620dp-3,    0x1.d59cd45f7c146p-3,  -0x1.ffffe4p-1, INEXACT) // 2.273396893258596007658667303986e-01
T(RN,    0x1.38937579c8f3bp-5,    0x1.38a6e08445bd2p-5,   0x1.fffffcp-2, INEXACT) // 3.815625137784058734657932632217e-02
T(RN,    0x1.e4fefab88ab9ep-1,     0x1.186cfc1cfd8ap+0,   0x1.ffffdcp-2, INEXACT) // 9.472578382750389547339864293463e-01
T(RD,    0x1.bda0f06d49bd1p+6,  0x1.a79a42dc3bdf7p+159, -0x1.81f258p-21, INEXACT) // 1.114071671558624672115911380388e+02
T(RU,    0x1.bda0f06d49bd1p+6,  0x1.a79a42dc3bdf8p+159,   0x1.ffffe8p-1, INEXACT) // 1.114071671558624672115911380388e+02
T(RZ,    0x1.bda0f06d49bd1p+6,  0x1.a79a42dc3bdf7p+159, -0x1.81f258p-21, INEXACT) // 1.114071671558624672115911380388e+02
T(RD,    0x1.07aab73d650cep-8,    0x1.07aae5db1cda1p-8,  -0x1.ffffe8p-1, INEXACT) // 4.023236976895284630617588561563e-03
T(RU,    0x1.07aab73d650cep-8,    0x1.07aae5db1cda2p-8,  0x1.8d02a6p-21, INEXACT) // 4.023236976895284630617588561563e-03
T(RZ,    0x1.07aab73d650cep-8,    0x1.07aae5db1cda1p-8,  -0x1.ffffe8p-1, INEXACT) // 4.023236976895284630617588561563e-03
T(RN,  -0x1.45976de65bc19p-10,  -0x1.45977362d0749p-10,   0x1.ffffd4p-2, INEXACT) // -1.242033083680876707002860293017e-03
T(RN,    0x1.eae19b169e304p-3,    0x1.ef9852c949006p-3,  -0x1.ffffcep-2, INEXACT) // 2.396881214406435534058914527122e-01
T(RN,   -0x1.fc8d0dc6a985dp+0,   -0x1.c9caca20e65cep+1,   0x1.ffffd4p-2, INEXACT) // -1.986527310372842025643080887676e+00
T(RD,   -0x1.3a2951975f997p+9, -0x1.649b6424863a1p+905, -0x1.e2e936p-21, INEXACT) // -6.283228024689477706488105468452e+02
T(RU,   -0x1.3a2951975f997p+9,  -0x1.649b6424863ap+905,   0x1.ffffe2p-1, INEXACT) // -6.283228024689477706488105468452e+02
T(RZ,   -0x1.3a2951975f997p+9,  -0x1.649b6424863ap+905,   0x1.ffffe2p-1, INEXACT) // -6.283228024689477706488105468452e+02
T(RN,   -0x1.65e7eb2cfe8e9p-4,   -0x1.665c8e96c598ep-4,    0x1.ffffep-2, INEXACT) // -8.737937799006413597258102754495e-02
T(RD,    0x1.709fa28b35ba8p+3,   0x1.8932478382dc5p+15,  -0x1.e9c34p-23, INEXACT) // 1.151948668660573105171351926401e+01
T(RU,    0x1.709fa28b35ba8p+3,   0x1.8932478382dc6p+15,   0x1.fffff8p-1, INEXACT) // 1.151948668660573105171351926401e+01
T(RZ,    0x1.709fa28b35ba8p+3,   0x1.8932478382dc5p+15,  -0x1.e9c34p-23, INEXACT) // 1.151948668660573105171351926401e+01
T(RN,     0x1.e9336ee6c2c8p+7,  0x1.d8665060aa74ep+351,  -0x1.ffffcep-2, INEXACT) // 2.446004554856081085745245218277e+02
T(RD,     0x1.20964fd9dcfcp-9,    0x1.20965f21b1478p-9, -0x1.f400cap-25, INEXACT) // 2.201745269241300873019895334437e-03
T(RU,     0x1.20964fd9dcfcp-9,    0x1.20965f21b1479p-9,   0x1.fffffep-1, INEXACT) // 2.201745269241300873019895334437e-03
T(RZ,     0x1.20964fd9dcfcp-9,    0x1.20965f21b1478p-9, -0x1.f400cap-25, INEXACT) // 2.201745269241300873019895334437e-03
T(RD,   0x1.ce3f8509d8448p-10,   0x1.ce3f94bccf953p-10,  -0x1.fffff8p-1, INEXACT) // 1.763336653731311168269435540878e-03
T(RU,   0x1.ce3f8509d8448p-10,   0x1.ce3f94bccf954p-10,  0x1.c11162p-23, INEXACT) // 1.763336653731311168269435540878e-03
T(RZ,   0x1.ce3f8509d8448p-10,   0x1.ce3f94bccf953p-10,  -0x1.fffff8p-1, INEXACT) // 1.763336653731311168269435540878e-03
T(RD,   -0x1.076db416b1002p+7, -0x1.0435026ca23ebp+189, -0x1.ed486ep-25, INEXACT) // -1.317142645922722863360831979662e+02
T(RU,   -0x1.076db416b1002p+7, -0x1.0435026ca23eap+189,   0x1.fffffep-1, INEXACT) // -1.317142645922722863360831979662e+02
T(RZ,   -0x1.076db416b1002p+7, -0x1.0435026ca23eap+189,   0x1.fffffep-1, INEXACT) // -1.317142645922722863360831979662e+02
T(RD,   -0x1.35c521561df9ap-2,   -0x1.3a842e04193e5p-2, -0x1.a4bb8ap-22, INEXACT) // -3.025098046123219086567246449704e-01
T(RU,   -0x1.35c521561df9ap-2,   -0x1.3a842e04193e4p-2,   0x1.fffff2p-1, INEXACT) // -3.025098046123219086567246449704e-01
T(RZ,   -0x1.35c521561df9ap-2,   -0x1.3a842e04193e4p-2,   0x1.fffff2p-1, INEXACT) // -3.025098046123219086567246449704e-01
T(RN,    0x1.15ca83257d122p+6,   0x1.246e14037440bp+99,    0x1.fffffp-2, INEXACT) // 6.944776590896483980941411573440e+01
T(RN,    0x1.60ce483e4ab9bp-9,     0x1.60ce6429d2b8p-9,  -0x1.ffffd6p-2, INEXACT) // 2.691694563642111400619816308222e-03
T(RN,    0x1.1b221e711aeeap-2,    0x1.1ec135447cb5ap-2,  -0x1.fffffcp-2, INEXACT) // 2.764973408254564057884294925316e-01
T(RD,    0x1.a71895e72109ep+0,     0x1.41e56c4dae86p+1, -0x1.d0c9b6p-21, INEXACT) // 1.652718895843498625453094064142e+00
T(RU,    0x1.a71895e72109ep+0,    0x1.41e56c4dae861p+1,   0x1.ffffe2p-1, INEXACT) // 1.652718895843498625453094064142e+00
T(RZ,    0x1.a71895e72109ep+0,     0x1.41e56c4dae86p+1, -0x1.d0c9b6p-21, INEXACT) // 1.652718895843498625453094064142e+00
T(RD,    -0x1.fbd9c38a7f21p+7, -0x1.4350d3cea7fd9p+365,  -0x1.ffffe2p-1, INEXACT) // -2.539253199844538357865530997515e+02
T(RU,    -0x1.fbd9c38a7f21p+7, -0x1.4350d3cea7fd8p+365,  0x1.d90bf2p-21, INEXACT) // -2.539253199844538357865530997515e+02
T(RZ,    -0x1.fbd9c38a7f21p+7, -0x1.4350d3cea7fd8p+365,  0x1.d90bf2p-21, INEXACT) // -2.539253199844538357865530997515e+02
T(RD,   -0x1.9cc7264a2e331p-5,   -0x1.9cf3deea25cd6p-5, -0x1.e2c5acp-22, INEXACT) // -5.038793066473202381105878089329e-02
T(RU,   -0x1.9cc7264a2e331p-5,   -0x1.9cf3deea25cd5p-5,    0x1.fffffp-1, INEXACT) // -5.038793066473202381105878089329e-02
T(RZ,   -0x1.9cc7264a2e331p-5,   -0x1.9cf3deea25cd5p-5,    0x1.fffffp-1, INEXACT) // -5.038793066473202381105878089329e-02
T(RN,   -0x1.7087da5f2dcabp-3,   -0x1.7285d52a14ce5p-3,  -0x1.fffff4p-2, INEXACT) // -1.799466190620696293134272991665e-01
T(RD,  -0x1.b92f82f4b1253p-10,  -0x1.b92f909aeec82p-10,  -0x1.fffffap-1, INEXACT) // -1.682989471349167999100759907094e-03
T(RU,  -0x1.b92f82f4b1253p-10,  -0x1.b92f909aeec81p-10,  0x1.b9523ap-23, INEXACT) // -1.682989471349167999100759907094e-03
T(RZ,  -0x1.b92f82f4b1253p-10,  -0x1.b92f909aeec81p-10,  0x1.b9523ap-23, INEXACT) // -1.682989471349167999100759907094e-03
T(RN,   -0x1.79ad661b22edap-1,   -0x1.9cdf49b530218p-1,  -0x1.ffffecp-2, INEXACT) // -7.376510532498870009732172547956e-01
T(RN,   -0x1.506189fff073bp+1,   -0x1.b8c088270e826p+2,   0x1.fffff4p-2, INEXACT) // -2.627976655931801186483198762289e+00
T(RD,   -0x1.d2554c3f42664p+7, -0x1.4f106ea67264cp+335, -0x1.6bb628p-21, INEXACT) // -2.331665973442605945820105262101e+02
T(RU,   -0x1.d2554c3f42664p+7, -0x1.4f106ea67264bp+335,   0x1.ffffeap-1, INEXACT) // -2.331665973442605945820105262101e+02
T(RZ,   -0x1.d2554c3f42664p+7, -0x1.4f106ea67264bp+335,   0x1.ffffeap-1, INEXACT) // -2.331665973442605945820105262101e+02
T(RN,  -0x1.635de9cbafeddp-10,  -0x1.635df0edc42abp-10,  -0x1.ffffeap-2, INEXACT) // -1.355616945986008086214025247784e-03
T(RD,    0x1.0631b581d5d48p-3,    0x1.06e9376dcd379p-3, -0x1.79cab2p-24, INEXACT) // 1.280244999167996500233357437537e-01
T(RU,    0x1.0631b581d5d48p-3,    0x1.06e9376dcd37ap-3,   0x1.fffffep-1, INEXACT) // 1.280244999167996500233357437537e-01
T(RZ,    0x1.0631b581d5d48p-3,    0x1.06e9376dcd379p-3, -0x1.79cab2p-24, INEXACT) // 1.280244999167996500233357437537e-01
T(RN,    0x1.213de89628e19p+0,    0x1.62d49ddddb17ap+0,   0x1.ffffe4p-2, INEXACT) // 1.129850899372178085755535903445e+00
T(RN,    0x1.f019794c7e842p+6,  0x1.e7c6a196ca22ep+177,   0x1.fffff2p-2, INEXACT) // 1.240248767807215983793867053464e+02
T(RN,    0x1.d8a2f0a87d4c4p+8,  0x1.d3fbaaf15af5ep+680,   0x1.ffffd6p-2, INEXACT) // 4.726364846521285016933688893914e+02
T(RD,    0x1.16dbfcec6e933p+9,  0x1.88e0e4fdfa197p+803,  -0x1.fffffcp-1, INEXACT) // 5.577186561145703080910607241094e+02
T(RU,    0x1.16dbfcec6e933p+9,  0x1.88e0e4fdfa198p+803,  0x1.34aac2p-23, INEXACT) // 5.577186561145703080910607241094e+02
T(RZ,    0x1.16dbfcec6e933p+9,  0x1.88e0e4fdfa197p+803,  -0x1.fffffcp-1, INEXACT) // 5.577186561145703080910607241094e+02
T(RN,   -0x1.f2f14f7a6e80dp-6,   -0x1.f3050dc66dd56p-6,   0x1.ffffe4p-2, INEXACT) // -3.045304070995063019933191128530e-02
T(RD,    0x1.a124a204b2abfp+2,    0x1.52903e8b4b24ap+8, -0x1.3f17d8p-22, INEXACT) // 6.517860893810108358081834012410e+00
T(RU,    0x1.a124a204b2abfp+2,    0x1.52903e8b4b24bp+8,   0x1.fffff6p-1, INEXACT) // 6.517860893810108358081834012410e+00
T(RZ,    0x1.a124a204b2abfp+2,    0x1.52903e8b4b24ap+8, -0x1.3f17d8p-22, INEXACT) // 6.517860893810108358081834012410e+00
T(RD,   -0x1.40026e9100d4cp+5,  -0x1.a2a001fe4a9e4p+56,  -0x1.ffffe4p-1, INEXACT) // -4.000118745120798280368035193533e+01
T(RU,   -0x1.40026e9100d4cp+5,  -0x1.a2a001fe4a9e3p+56,  0x1.b1ff32p-21, INEXACT) // -4.000118745120798280368035193533e+01
T(RZ,   -0x1.40026e9100d4cp+5,  -0x1.a2a001fe4a9e3p+56,  0x1.b1ff32p-21, INEXACT) // -4.000118745120798280368035193533e+01
T(RN,     0x1.333e559c769bp-8,    0x1.333e9f5edeb66p-8,   0x1.ffffeap-2, INEXACT) // 4.688163663070829545453932496457e-03
T(RN,   -0x1.9ac7a99160c36p+4,  -0x1.0715c781378bbp+36,  -0x1.fffffcp-2, INEXACT) // -2.567374569690965557811068720184e+01
T(RN,    0x1.b1446951c9275p+5,   0x1.18edc7de2aff4p+77,  -0x1.ffffcep-2, INEXACT) // 5.415840400595781289894148358144e+01
T(RN,   -0x1.c3ece0b22c01cp-7,   -0x1.c3f08ba0160bbp-7,   0x1.ffffe4p-2, INEXACT) // -1.379166575893014251574797413014e-02
T(RD,   -0x1.680b532716833p-7,   -0x1.680d2df09e1ffp-7,  -0x1.ffffe4p-1, INEXACT) // -1.098767814817245246084009835386e-02
T(RU,   -0x1.680b532716833p-7,   -0x1.680d2df09e1fep-7,  0x1.b9f58ap-21, INEXACT) // -1.098767814817245246084009835386e-02
T(RZ,   -0x1.680b532716833p-7,   -0x1.680d2df09e1fep-7,  0x1.b9f58ap-21, INEXACT) // -1.098767814817245246084009835386e-02
T(RD,   -0x1.6c2af543de11ep-1,   -0x1.8ba8c2def4592p-1,  -0x1.ffffeap-1, INEXACT) // -7.112652440401097120314943822450e-01
T(RU,   -0x1.6c2af543de11ep-1,   -0x1.8ba8c2def4591p-1,  0x1.6cbb7cp-21, INEXACT) // -7.112652440401097120314943822450e-01
T(RZ,   -0x1.6c2af543de11ep-1,   -0x1.8ba8c2def4591p-1,  0x1.6cbb7cp-21, INEXACT) // -7.112652440401097120314943822450e-01
T(RN,   -0x1.ec46ccb46133ap+4,  -0x1.4ef3a78077c6bp+43,   0x1.ffffeap-2, INEXACT) // -3.076728506527727091679480508901e+01
T(RD,    0x1.1f8ce7fb56059p-9,    0x1.1f8cf719283bbp-9, -0x1.573768p-21, INEXACT) // 2.193835561836759723980394554133e-03
T(RU,    0x1.1f8ce7fb56059p-9,    0x1.1f8cf719283bcp-9,   0x1.ffffeap-1, INEXACT) // 2.193835561836759723980394554133e-03
T(RZ,    0x1.1f8ce7fb56059p-9,    0x1.1f8cf719283bbp-9, -0x1.573768p-21, INEXACT) // 2.193835561836759723980394554133e-03
T(RN,   -0x1.7d5cf5651219dp+3,  -0x1.24bc8ab078c2ap+16,  -0x1.ffffd2p-2, INEXACT) // -1.191759748211262071038163412595e+01
T(RD,   -0x1.391308cbfc3c4p+8, -0x1.978b96126f7e2p+450, -0x1.1f2154p-22, INEXACT) // -3.130743529787835086608538404107e+02
T(RU,   -0x1.391308cbfc3c4p+8, -0x1.978b96126f7e1p+450,   0x1.fffff8p-1, INEXACT) // -3.130743529787835086608538404107e+02
T(RZ,   -0x1.391308cbfc3c4p+8, -0x1.978b96126f7e1p+450,   0x1.fffff8p-1, INEXACT) // -3.130743529787835086608538404107e+02
T(RN,   -0x1.b97a1af972609p-9,   -0x1.b97a51ae20a1bp-9,  -0x1.ffffccp-2, INEXACT) // -3.368202011846181415793965996386e-03
T(RN,   -0x1.120de9dbc9682p-8,   -0x1.120e1e343ba79p-8,   0x1.fffffcp-2, INEXACT) // -4.181737512941931592114208626754e-03
T(RN,   -0x1.9e9ae5424e164p-1,   -0x1.cd6d10e3b5241p-1,   0x1.ffffc6p-2, INEXACT) // -8.097755092085603401130811107578e-01
T(RD,   -0x1.28ea283fda708p-4,   -0x1.292cbe11a0362p-4,  -0x1.ffffe2p-1, INEXACT) // -7.248893473083850569338437708211e-02
T(RU,   -0x1.28ea283fda708p-4,   -0x1.292cbe11a0361p-4,  0x1.e58b24p-21, INEXACT) // -7.248893473083850569338437708211e-02
T(RZ,   -0x1.28ea283fda708p-4,   -0x1.292cbe11a0361p-4,  0x1.e58b24p-21, INEXACT) // -7.248893473083850569338437708211e-02
T(RD,   -0x1.153bc7a6fd3e5p-5,   -0x1.154953e7ef437p-5, -0x1.df387ep-21, INEXACT) // -3.384198183622525585301232808888e-02
T(RU,   -0x1.153bc7a6fd3e5p-5,   -0x1.154953e7ef436p-5,   0x1.ffffe2p-1, INEXACT) // -3.384198183622525585301232808888e-02
T(RZ,   -0x1.153bc7a6fd3e5p-5,   -0x1.154953e7ef436p-5,   0x1.ffffe2p-1, INEXACT) // -3.384198183622525585301232808888e-02
T(RD,   -0x1.07f632d569c3ap-5,   -0x1.0801e46fb073dp-5,  -0x1.ffffeap-1, INEXACT) // -3.222188881346040034703293031271e-02
T(RU,   -0x1.07f632d569c3ap-5,   -0x1.0801e46fb073cp-5,  0x1.6a16d8p-21, INEXACT) // -3.222188881346040034703293031271e-02
T(RZ,   -0x1.07f632d569c3ap-5,   -0x1.0801e46fb073cp-5,  0x1.6a16d8p-21, INEXACT) // -3.222188881346040034703293031271e-02
T(RN,    -0x1.104c65392a65p-2,   -0x1.1384d6166228fp-2,  -0x1.ffffe6p-2, INEXACT) // -2.659164253369441510699289210606e-01
T(RN,    0x1.fd2ba4ba873e1p-5,    0x1.fd7f9608310a6p-5,   0x1.ffffe2p-2, INEXACT) // 6.215459989127914558482146389906e-02
T(RD,    0x1.bfd12db8076ebp-8,    0x1.bfd2121b2a8a8p-8,  -0x1.ffffe8p-1, INEXACT) // 6.833146726447951284366677526805e-03
T(RU,    0x1.bfd12db8076ebp-8,    0x1.bfd2121b2a8a9p-8,  0x1.8066dcp-21, INEXACT) // 6.833146726447951284366677526805e-03
T(RZ,    0x1.bfd12db8076ebp-8,    0x1.bfd2121b2a8a8p-8,  -0x1.ffffe8p-1, INEXACT) // 6.833146726447951284366677526805e-03
T(RN,   -0x1.f1b178de08d85p+7, -0x1.01be55d2d108dp+358,   0x1.fffff6p-2, INEXACT) // -2.488466252694890101793134817854e+02
T(RD,   -0x1.f31e869d3ac75p+2,  -0x1.30b0c33fa77cap+10, -0x1.ddcbdcp-26, INEXACT) // -7.798738149208578995796870003687e+00
T(RU,   -0x1.f31e869d3ac75p+2,  -0x1.30b0c33fa77c9p+10,          0x1p+0, INEXACT) // -7.798738149208578995796870003687e+00
T(RZ,   -0x1.f31e869d3ac75p+2,  -0x1.30b0c33fa77c9p+10,          0x1p+0, INEXACT) // -7.798738149208578995796870003687e+00
T(RN,   -0x1.d417ad0b2e617p+5,  -0x1.552afd0b765e2p+83,  -0x1.ffffe2p-2, INEXACT) // -5.851156052336971669092235970311e+01
T(RD,   -0x1.8e937562dd327p-2,   -0x1.98b77fd9c8789p-2, -0x1.b554e4p-21, INEXACT) // -3.892343846885517044675850684143e-01
T(RU,   -0x1.8e937562dd327p-2,   -0x1.98b77fd9c8788p-2,   0x1.ffffe4p-1, INEXACT) // -3.892343846885517044675850684143e-01
T(RZ,   -0x1.8e937562dd327p-2,   -0x1.98b77fd9c8788p-2,   0x1.ffffe4p-1, INEXACT) // -3.892343846885517044675850684143e-01
T(RD,   -0x1.b6e985b3ac182p-9,   -0x1.b6e9bb75af959p-9,  -0x1.ffffe8p-1, INEXACT) // -3.348634310747112576012174400830e-03
T(RU,   -0x1.b6e985b3ac182p-9,   -0x1.b6e9bb75af958p-9,  0x1.8a1c52p-21, INEXACT) // -3.348634310747112576012174400830e-03
T(RZ,   -0x1.b6e985b3ac182p-9,   -0x1.b6e9bb75af958p-9,  0x1.8a1c52p-21, INEXACT) // -3.348634310747112576012174400830e-03
T(RN,   -0x1.85b11bf238b0ep+5,   -0x1.35eeab469e82p+69,  -0x1.ffffe4p-2, INEXACT) // -4.871147908435351325806550448760e+01
T(RN,    0x1.69e5ad8c1e5a1p+0,    0x1.ef11a904f6c8dp+0,   0x1.ffffe4p-2, INEXACT) // 1.413660856922753561448757864127e+00
T(RD,    0x1.eda4e3842e84fp-4,    0x1.eed7086f7462cp-4, -0x1.7f53eep-21, INEXACT) // 1.205185782772855013211810160101e-01
T(RU,    0x1.eda4e3842e84fp-4,    0x1.eed7086f7462dp-4,   0x1.ffffe8p-1, INEXACT) // 1.205185782772855013211810160101e-01
T(RZ,    0x1.eda4e3842e84fp-4,    0x1.eed7086f7462cp-4, -0x1.7f53eep-21, INEXACT) // 1.205185782772855013211810160101e-01
T(RN,    0x1.1d4f2c2ee190ap+9,  0x1.2bf0bc6ebd89bp+822,  -0x1.ffffd4p-2, INEXACT) // 5.706185358621016803226666525006e+02
T(RN,   -0x1.047a96c07e36ep+0,   -0x1.33cf2478fa095p+0,  -0x1.ffffeep-2, INEXACT) // -1.017495557780616177723231885466e+00
T(RD,    0x1.9aebe61052612p-9,    0x1.9aec122dbe443p-9, -0x1.3e52a8p-22, INEXACT) // 3.135082086519921408529487649730e-03
T(RU,    0x1.9aebe61052612p-9,    0x1.9aec122dbe444p-9,   0x1.fffff6p-1, INEXACT) // 3.135082086519921408529487649730e-03
T(RZ,    0x1.9aebe61052612p-9,    0x1.9aec122dbe443p-9, -0x1.3e52a8p-22, INEXACT) // 3.135082086519921408529487649730e-03
T(RD,    0x1.345391f62f023p-8,    0x1.3453dc80f6265p-8, -0x1.df21d2p-22, INEXACT) // 4.704688201112391769675991071153e-03
T(RU,    0x1.345391f62f023p-8,    0x1.3453dc80f6266p-8,   0x1.fffff2p-1, INEXACT) // 4.704688201112391769675991071153e-03
T(RZ,    0x1.345391f62f023p-8,    0x1.3453dc80f6265p-8, -0x1.df21d2p-22, INEXACT) // 4.704688201112391769675991071153e-03
T(RD,    0x1.467e12241e846p+7,  0x1.6db40724b724cp+234,  -0x1.fffff4p-1, INEXACT) // 1.632462321555378252924128901213e+02
T(RU,    0x1.467e12241e846p+7,  0x1.6db40724b724dp+234,  0x1.6c98f4p-22, INEXACT) // 1.632462321555378252924128901213e+02
T(RZ,    0x1.467e12241e846p+7,  0x1.6db40724b724cp+234,  -0x1.fffff4p-1, INEXACT) // 1.632462321555378252924128901213e+02
T(RN,   -0x1.7c47702973499p+0,   -0x1.0c3326f76bf17p+1,   0x1.ffffe2p-2, INEXACT) // -1.485465059394561970762538294366e+00
T(RN,    0x1.b5a03aa1079c1p-4,    0x1.b6757f3dc1c4ep-4,   0x1.ffffc4p-2, INEXACT) // 1.068422594257532193262605346717e-01
T(RN,    -0x1.a86b1bb411eap+5,   -0x1.73c692d1f574p+75,  -0x1.ffffc8p-2, INEXACT) // -5.305229893378896122158039361238e+01
T(RD,    0x1.6f7a5743c813dp-4,    0x1.6ff897b399069p-4, -0x1.4f8f34p-22, INEXACT) // 8.971628272820893201799918870165e-02
T(RU,    0x1.6f7a5743c813dp-4,    0x1.6ff897b39906ap-4,   0x1.fffff6p-1, INEXACT) // 8.971628272820893201799918870165e-02
T(RZ,    0x1.6f7a5743c813dp-4,    0x1.6ff897b399069p-4, -0x1.4f8f34p-22, INEXACT) // 8.971628272820893201799918870165e-02
T(RD,   -0x1.8d6fd41eb8c55p+3,  -0x1.e3c1003983017p+16,  -0x1.fffff6p-1, INEXACT) // -1.241990095138877769898044789443e+01
T(RU,   -0x1.8d6fd41eb8c55p+3,  -0x1.e3c1003983016p+16,  0x1.323ba2p-22, INEXACT) // -1.241990095138877769898044789443e+01
T(RZ,   -0x1.8d6fd41eb8c55p+3,  -0x1.e3c1003983016p+16,  0x1.323ba2p-22, INEXACT) // -1.241990095138877769898044789443e+01
T(RD,   -0x1.427c81e859a66p-6,   -0x1.4281d696c61c9p-6,  -0x1.ffffe8p-1, INEXACT) // -1.968300520220580412944499926198e-02
T(RU,   -0x1.427c81e859a66p-6,   -0x1.4281d696c61c8p-6,   0x1.83a1ap-21, INEXACT) // -1.968300520220580412944499926198e-02
T(RZ,   -0x1.427c81e859a66p-6,   -0x1.4281d696c61c8p-6,   0x1.83a1ap-21, INEXACT) // -1.968300520220580412944499926198e-02
T(RN,   -0x1.c6e4c86f37d98p-9,   -0x1.c6e50447ec89dp-9,  -0x1.ffffd8p-2, INEXACT) // -3.470563380332424702201521427014e-03
T(RD,    0x1.4e1cc7c3dd324p-7,    0x1.4e1e432cdc84fp-7,  -0x1.ffffe8p-1, INEXACT) // 1.019630197672822397025882423804e-02
T(RU,    0x1.4e1cc7c3dd324p-7,     0x1.4e1e432cdc85p-7,  0x1.7b9f94p-21, INEXACT) // 1.019630197672822397025882423804e-02
T(RZ,    0x1.4e1cc7c3dd324p-7,    0x1.4e1e432cdc84fp-7,  -0x1.ffffe8p-1, INEXACT) // 1.019630197672822397025882423804e-02
T(RD,     0x1.3580189465b1p+2,    0x1.f7cc326f19f56p+5, -0x1.320962p-22, INEXACT) // 4.835943360251590661391674075276e+00
T(RU,     0x1.3580189465b1p+2,    0x1.f7cc326f19f57p+5,   0x1.fffff6p-1, INEXACT) // 4.835943360251590661391674075276e+00
T(RZ,     0x1.3580189465b1p+2,    0x1.f7cc326f19f56p+5, -0x1.320962p-22, INEXACT) // 4.835943360251590661391674075276e+00
T(RN,    0x1.19f8b0e84fe1fp+1,    0x1.1e1ab3d66d4ccp+2,   0x1.ffffccp-2, INEXACT) // 2.202901948388685138269238450448e+00
T(RN,   -0x1.b977ede74501cp-6,   -0x1.b9859aff16ec5p-6,   0x1.ffffd8p-2, INEXACT) // -2.694509728196702036395748791620e-02
T(RD,    0x1.137364f2daa13p-7,    0x1.1374398c5450ep-7,  -0x1.fffffap-1, INEXACT) // 8.406090060550963291574610991574e-03
T(RU,    0x1.137364f2daa13p-7,    0x1.1374398c5450fp-7,  0x1.a3539cp-23, INEXACT) // 8.406090060550963291574610991574e-03
T(RZ,    0x1.137364f2daa13p-7,    0x1.1374398c5450ep-7,  -0x1.fffffap-1, INEXACT) // 8.406090060550963291574610991574e-03
T(RN,   -0x1.a9fbf145be0b5p+5,  -0x1.c425ff5f88774p+75,  -0x1.fffff8p-2, INEXACT) // -5.324801878439158286937527009286e+01
T(RD,   -0x1.c77cc80424208p+8, -0x1.18086716464f1p+656, -0x1.83f702p-22, INEXACT) // -4.554874270046425408509094268084e+02
T(RU,   -0x1.c77cc80424208p+8,  -0x1.18086716464fp+656,   0x1.fffff4p-1, INEXACT) // -4.554874270046425408509094268084e+02
T(RZ,   -0x1.c77cc80424208p+8,  -0x1.18086716464fp+656,   0x1.fffff4p-1, INEXACT) // -4.554874270046425408509094268084e+02
T(RN,     0x1.ccee688bc36ep+5,    0x1.16c407c8ab8ep+82,  -0x1.ffffd2p-2, INEXACT) // 5.761641034307626796362455934286e+01
T(RN,   -0x1.f94b7e75f3c0ep-6,   -0x1.f960004733669p-6,  -0x1.ffffcep-2, INEXACT) // -3.084075307543448357661119985096e-02
T(RD,   -0x1.7f65294220148p+7, -0x1.79b6a8e72cd09p+275,  -0x1.fffffap-1, INEXACT) // -1.916975804008636714570457115769e+02
T(RU,   -0x1.7f65294220148p+7, -0x1.79b6a8e72cd08p+275,  0x1.b548fcp-23, INEXACT) // -1.916975804008636714570457115769e+02
T(RZ,   -0x1.7f65294220148p+7, -0x1.79b6a8e72cd08p+275,  0x1.b548fcp-23, INEXACT) // -1.916975804008636714570457115769e+02
T(RD,    0x1.3e308c5b23a75p+1,     0x1.7db3684978d1p+2,  -0x1.c0c5dp-23, INEXACT) // 2.485856575490567710318146055215e+00
T(RU,    0x1.3e308c5b23a75p+1,    0x1.7db3684978d11p+2,   0x1.fffff8p-1, INEXACT) // 2.485856575490567710318146055215e+00
T(RZ,    0x1.3e308c5b23a75p+1,     0x1.7db3684978d1p+2,  -0x1.c0c5dp-23, INEXACT) // 2.485856575490567710318146055215e+00
T(RD,   -0x1.a154122a1e47cp+4,  -0x1.8c22bf0d4db85p+36, -0x1.7fa496p-22, INEXACT) // -2.608302513554052382005465915427e+01
T(RU,   -0x1.a154122a1e47cp+4,  -0x1.8c22bf0d4db84p+36,   0x1.fffff4p-1, INEXACT) // -2.608302513554052382005465915427e+01
T(RZ,   -0x1.a154122a1e47cp+4,  -0x1.8c22bf0d4db84p+36,   0x1.fffff4p-1, INEXACT) // -2.608302513554052382005465915427e+01
T(RN,   -0x1.fcdeb80f160c5p+1,   -0x1.aa1574179b60dp+4,   0x1.fffff8p-2, INEXACT) // -3.975546843878051905818438171991e+00
T(RD,   -0x1.004bac83c3ed6p+6,  -0x1.5b12dd269b104p+91, -0x1.360b7ap-21, INEXACT) // -6.407390027888627059837745036930e+01
T(RU,   -0x1.004bac83c3ed6p+6,  -0x1.5b12dd269b103p+91,   0x1.ffffecp-1, INEXACT) // -6.407390027888627059837745036930e+01
T(RZ,   -0x1.004bac83c3ed6p+6,  -0x1.5b12dd269b103p+91,   0x1.ffffecp-1, INEXACT) // -6.407390027888627059837745036930e+01
T(RN,   -0x1.51ed39e30c5e2p-5,   -0x1.5205c33d261cdp-5,  -0x1.fffffap-2, INEXACT) // -4.125081354176153569657259367887e-02
T(RN,    0x1.4c8666f495aaep+7,  0x1.d29d8fe12a3b9p+238,   0x1.ffffd4p-2, INEXACT) // 1.662625042374324380034522619098e+02
T(RD,    0x1.2e21dcf5b616ep+4,   0x1.2eebb095c87ebp+26, -0x1.3b2e34p-22, INEXACT) // 1.888326736432048136293815332465e+01
T(RU,    0x1.2e21dcf5b616ep+4,   0x1.2eebb095c87ecp+26,   0x1.fffff6p-1, INEXACT) // 1.888326736432048136293815332465e+01
T(RZ,    0x1.2e21dcf5b616ep+4,   0x1.2eebb095c87ebp+26, -0x1.3b2e34p-22, INEXACT) // 1.888326736432048136293815332465e+01
T(RD,    0x1.37e2691549d0ep+2,    0x1.0575d9ef8589fp+6,  -0x1.ffffecp-1, INEXACT) // 4.873193999089620476183881692123e+00
T(RU,    0x1.37e2691549d0ep+2,     0x1.0575d9ef858ap+6,  0x1.439e04p-21, INEXACT) // 4.873193999089620476183881692123e+00
T(RZ,    0x1.37e2691549d0ep+2,    0x1.0575d9ef8589fp+6,  -0x1.ffffecp-1, INEXACT) // 4.873193999089620476183881692123e+00
T(RD,   -0x1.540a8a80f2fc1p-3,   -0x1.559b0f170fe1dp-3,  -0x1.fffffcp-1, INEXACT) // -1.660357304193649519152842231051e-01
T(RU,   -0x1.540a8a80f2fc1p-3,   -0x1.559b0f170fe1cp-3,  0x1.383aeap-23, INEXACT) // -1.660357304193649519152842231051e-01
T(RZ,   -0x1.540a8a80f2fc1p-3,   -0x1.559b0f170fe1cp-3,  0x1.383aeap-23, INEXACT) // -1.660357304193649519152842231051e-01
T(RD,     0x1.d1b3c39620eap-9,    0x1.d1b403cd12dafp-9,  -0x1.ffffe4p-1, INEXACT) // 3.553025841996973466230258509313e-03
T(RU,     0x1.d1b3c39620eap-9,     0x1.d1b403cd12dbp-9,  0x1.cbeed2p-21, INEXACT) // 3.553025841996973466230258509313e-03
T(RZ,     0x1.d1b3c39620eap-9,    0x1.d1b403cd12dafp-9,  -0x1.ffffe4p-1, INEXACT) // 3.553025841996973466230258509313e-03
T(RN,    0x1.ccd7d446194c3p-8,    0x1.ccd8cd2d1e08ep-8,   0x1.ffffc2p-2, INEXACT) // 7.031907391227667884769925166211e-03
T(RD,    0x1.de341f152b4cap+3,   0x1.7943f67db8514p+20,  -0x1.fffff2p-1, INEXACT) // 1.494386247763249642162008967716e+01
T(RU,    0x1.de341f152b4cap+3,   0x1.7943f67db8515p+20,  0x1.ba131ep-22, INEXACT) // 1.494386247763249642162008967716e+01
T(RZ,    0x1.de341f152b4cap+3,   0x1.7943f67db8514p+20,  -0x1.fffff2p-1, INEXACT) // 1.494386247763249642162008967716e+01
T(RN,   -0x1.3041aa1ef1714p-9,   -0x1.3041bc073209cp-9,   0x1.ffffc8p-2, INEXACT) // -2.321292893131219128854958455577e-03
T(RD,   -0x1.4476e35e3a3ffp+4,  -0x1.31cd0fcf07d42p+28, -0x1.1bfad6p-23, INEXACT) // -2.027902542884475778350861219224e+01
T(RU,   -0x1.4476e35e3a3ffp+4,  -0x1.31cd0fcf07d41p+28,   0x1.fffffcp-1, INEXACT) // -2.027902542884475778350861219224e+01
T(RZ,   -0x1.4476e35e3a3ffp+4,  -0x1.31cd0fcf07d41p+28,   0x1.fffffcp-1, INEXACT) // -2.027902542884475778350861219224e+01
T(RN,   -0x1.5fbe1a78acddcp-5,   -0x1.5fd9c63aab397p-5,   0x1.ffffc6p-2, INEXACT) // -4.293732805436054067449447302351e-02
T(RD,   -0x1.5696f19a07f81p+6, -0x1.7a38ba4c542b7p+122, -0x1.a2e28ep-21, INEXACT) // -8.564740601228369598629797110334e+01
T(RU,   -0x1.5696f19a07f81p+6, -0x1.7a38ba4c542b6p+122,   0x1.ffffe6p-1, INEXACT) // -8.564740601228369598629797110334e+01
T(RZ,   -0x1.5696f19a07f81p+6, -0x1.7a38ba4c542b6p+122,   0x1.ffffe6p-1, INEXACT) // -8.564740601228369598629797110334e+01
T(RN,   -0x1.2d9cd1a31ead7p-4,   -0x1.2de29d97a4bc1p-4,  -0x1.fffff2p-2, INEXACT) // -7.363588227773774919082683254601e-02
T(RN,   -0x1.0e18fb1f01075p-3,    -0x1.0ee1992c6a13p-3,  -0x1.fffff4p-2, INEXACT) // -1.318835848652530062796728316243e-01
T(RN,    0x1.c32b2253d1d18p+1,    0x1.0f53e1ae92f41p+4,  -0x1.ffffe6p-2, INEXACT) // 3.524753848006763945477359811775e+00
T(RN,    0x1.eccaa29223ddap-8,    0x1.eccbd2e950833p-8,  -0x1.fffff6p-2, INEXACT) // 7.519402208472547935458329959602e-03
T(RD,    0x1.a140d0ce2949fp+6,  0x1.681afe66cb73ap+149, -0x1.ff48bcp-24, INEXACT) // 1.043132965290737814711974351667e+02
T(RU,    0x1.a140d0ce2949fp+6,  0x1.681afe66cb73bp+149,   0x1.fffffcp-1, INEXACT) // 1.043132965290737814711974351667e+02
T(RZ,    0x1.a140d0ce2949fp+6,  0x1.681afe66cb73ap+149, -0x1.ff48bcp-24, INEXACT) // 1.043132965290737814711974351667e+02
T(RN,   -0x1.7aca1064a40d6p+5,  -0x1.3d4ba045f5f49p+67,   0x1.fffff8p-2, INEXACT) // -4.734866407991073344874166650698e+01
T(RD,   -0x1.c4e4923d3f5bfp+8,  -0x1.4e98ac6d4c87p+652,   -0x1.fffffp-1, INEXACT) // -4.528928564338384035181661602110e+02
T(RU,   -0x1.c4e4923d3f5bfp+8, -0x1.4e98ac6d4c86fp+652,  0x1.f73b84p-22, INEXACT) // -4.528928564338384035181661602110e+02
T(RZ,   -0x1.c4e4923d3f5bfp+8, -0x1.4e98ac6d4c86fp+652,  0x1.f73b84p-22, INEXACT) // -4.528928564338384035181661602110e+02
T(RN,   -0x1.b2c745dbd10f2p-9,   -0x1.b2c77a1ca36f5p-9,  -0x1.ffffd2p-2, INEXACT) // -3.317096021335890800030288261269e-03
T(RD,   -0x1.0de5a057b487bp+3,  -0x1.1fa28572ac02dp+11,  -0x1.fffff2p-1, INEXACT) // -8.434280558871469324344616325106e+00
T(RU,   -0x1.0de5a057b487bp+3,  -0x1.1fa28572ac02cp+11,  0x1.d03916p-22, INEXACT) // -8.434280558871469324344616325106e+00
T(RZ,   -0x1.0de5a057b487bp+3,  -0x1.1fa28572ac02cp+11,  0x1.d03916p-22, INEXACT) // -8.434280558871469324344616325106e+00
T(RN,   -0x1.65eca24a90ba6p-2,   -0x1.6d41da96c4695p-2,  -0x1.ffffeep-2, INEXACT) // -3.495354993830751544336976621707e-01
T(RN,   -0x1.e376bc219f64ep-5,   -0x1.e3be97d4f253dp-5,   0x1.fffff4p-2, INEXACT) // -5.901657814409287661217007325831e-02
T(RN,    0x1.8a0034d375a2ap+6,  0x1.13785c94798f4p+141,  -0x1.ffffdcp-2, INEXACT) // 9.850020151525009737270011100918e+01
T(RD,   -0x1.0ba326c5c629fp+1,   -0x1.fe0012ad05a01p+1, -0x1.3ee846p-22, INEXACT) // -2.090916487283109415074022763292e+00
T(RU,   -0x1.0ba326c5c629fp+1,     -0x1.fe0012ad05ap+1,   0x1.fffff6p-1, INEXACT) // -2.090916487283109415074022763292e+00
T(RZ,   -0x1.0ba326c5c629fp+1,     -0x1.fe0012ad05ap+1,   0x1.fffff6p-1, INEXACT) // -2.090916487283109415074022763292e+00
T(RD,   0x1.4ca7e9b280f4fp-10,   0x1.4ca7ef8c60117p-10,  -0x1.ffffe6p-1, INEXACT) // 1.268981589078916260779350544396e-03
T(RU,   0x1.4ca7e9b280f4fp-10,   0x1.4ca7ef8c60118p-10,   0x1.9288ep-21, INEXACT) // 1.268981589078916260779350544396e-03
T(RZ,   0x1.4ca7e9b280f4fp-10,   0x1.4ca7ef8c60117p-10,  -0x1.ffffe6p-1, INEXACT) // 1.268981589078916260779350544396e-03
T(RD,    0x1.066008956033cp-4,    0x1.068dfa2b660b5p-4, -0x1.c1d272p-25, INEXACT) // 6.405642846040121574091585898714e-02
T(RU,    0x1.066008956033cp-4,    0x1.068dfa2b660b6p-4,   0x1.fffffep-1, INEXACT) // 6.405642846040121574091585898714e-02
T(RZ,    0x1.066008956033cp-4,    0x1.068dfa2b660b5p-4, -0x1.c1d272p-25, INEXACT) // 6.405642846040121574091585898714e-02
T(RD,    0x1.56c3a6285d736p+0,    0x1.c6c24a1593465p+0,  -0x1.fffffap-1, INEXACT) // 1.338922867636438862604109090171e+00
T(RU,    0x1.56c3a6285d736p+0,    0x1.c6c24a1593466p+0,   0x1.90cdep-23, INEXACT) // 1.338922867636438862604109090171e+00
T(RZ,    0x1.56c3a6285d736p+0,    0x1.c6c24a1593465p+0,  -0x1.fffffap-1, INEXACT) // 1.338922867636438862604109090171e+00
T(RD,    0x1.d1c8218cc3387p-4,    0x1.d2c9498b9bb25p-4, -0x1.06c802p-21, INEXACT) // 1.137162504712262295347713347837e-01
T(RU,    0x1.d1c8218cc3387p-4,    0x1.d2c9498b9bb26p-4,    0x1.fffffp-1, INEXACT) // 1.137162504712262295347713347837e-01
T(RZ,    0x1.d1c8218cc3387p-4,    0x1.d2c9498b9bb25p-4, -0x1.06c802p-21, INEXACT) // 1.137162504712262295347713347837e-01
T(RN,   -0x1.376630cbe8145p+8, -0x1.314b479ffdb8ap+448,   0x1.fffff4p-2, INEXACT) // -3.113991820756530728431243915111e+02
T(RN,    0x1.22a8deedf5488p-8,    0x1.22a91d60d422ep-8,   0x1.ffffecp-2, INEXACT) // 4.435114313271822095163798849171e-03
T(RD,   -0x1.1fed4e4bc8ec3p+4,  -0x1.f2aa29d4263bap+24, -0x1.c2de12p-22, INEXACT) // -1.799543599704226082280911214184e+01
T(RU,   -0x1.1fed4e4bc8ec3p+4,  -0x1.f2aa29d4263b9p+24,   0x1.fffff2p-1, INEXACT) // -1.799543599704226082280911214184e+01
T(RZ,   -0x1.1fed4e4bc8ec3p+4,  -0x1.f2aa29d4263b9p+24,   0x1.fffff2p-1, INEXACT) // -1.799543599704226082280911214184e+01
T(RN,    0x1.9f3c16d3f71edp+5,   0x1.d7d56a74be751p+73,  -0x1.fffffep-2, INEXACT) // 5.190434041593457692442825646140e+01
T(RD,    0x1.54d07a2d0abaap+7,  0x1.cc08b24b4380fp+244,  -0x1.ffffecp-1, INEXACT) // 1.704071821284863403889175970107e+02
T(RU,    0x1.54d07a2d0abaap+7,   0x1.cc08b24b4381p+244,  0x1.37ea94p-21, INEXACT) // 1.704071821284863403889175970107e+02
T(RZ,    0x1.54d07a2d0abaap+7,  0x1.cc08b24b4380fp+244,  -0x1.ffffecp-1, INEXACT) // 1.704071821284863403889175970107e+02
T(RN,  -0x1.99fcf30fcd536p-10,  -0x1.99fcfe03f5e6dp-10,  -0x1.fffff8p-2, INEXACT) // -1.563980422316047554781581752081e-03
T(RN,    0x1.3bf647333173bp-7,    0x1.3bf788131e82cp-7,   0x1.fffff2p-2, INEXACT) // 9.642395749675727531502467115843e-03
T(RN,   -0x1.88c586d0ea4bfp+5,  -0x1.c7778fe56c5a1p+69,  -0x1.fffffep-2, INEXACT) // -4.909644854750649045627142186277e+01
T(RN,   -0x1.4c1dc875dce7ap+4,  -0x1.ed54c0091b559p+28,  -0x1.fffffep-2, INEXACT) // -2.075727125206183387717828736641e+01
T(RD,    0x1.b7d66e8f91749p-7,    0x1.b7d9d025653aap-7, -0x1.a09052p-22, INEXACT) // 1.342277906872947797201067743345e-02
T(RU,    0x1.b7d66e8f91749p-7,    0x1.b7d9d025653abp-7,   0x1.fffff2p-1, INEXACT) // 1.342277906872947797201067743345e-02
T(RZ,    0x1.b7d66e8f91749p-7,    0x1.b7d9d025653aap-7, -0x1.a09052p-22, INEXACT) // 1.342277906872947797201067743345e-02
T(RN,   -0x1.0ea83fa33f59dp-2,    -0x1.11d1d6670dacp-2,  -0x1.ffffe8p-2, INEXACT) // -2.643136924160332523747740651743e-01
T(RN,   -0x1.ef200c1eacd02p+7, -0x1.1d7edc8988ebfp+356,  -0x1.ffffe6p-2, INEXACT) // -2.475625924669221262774954084307e+02
T(RN,    0x1.da931df060bd8p-4,    0x1.dba31ec16439cp-4,  -0x1.fffffep-2, INEXACT) // 1.158629579058890746168231089541e-01
T(RD,    0x1.ee001b89b6fb6p+7,   0x1.456113126fbbp+355,  -0x1.ffffeap-1, INEXACT) // 2.470002100978724115520890336484e+02
T(RU,    0x1.ee001b89b6fb6p+7,  0x1.456113126fbb1p+355,  0x1.5201aep-21, INEXACT) // 2.470002100978724115520890336484e+02
T(RZ,    0x1.ee001b89b6fb6p+7,   0x1.456113126fbbp+355,  -0x1.ffffeap-1, INEXACT) // 2.470002100978724115520890336484e+02
T(RD,   -0x1.8b731fc0c3daap+2,   -0x1.e275ac7a13968p+7,  -0x1.ffffeep-1, INEXACT) // -6.178901613471149190104370063636e+00
T(RU,   -0x1.8b731fc0c3daap+2,   -0x1.e275ac7a13967p+7,  0x1.2fa2dep-21, INEXACT) // -6.178901613471149190104370063636e+00
T(RZ,   -0x1.8b731fc0c3daap+2,   -0x1.e275ac7a13967p+7,  0x1.2fa2dep-21, INEXACT) // -6.178901613471149190104370063636e+00
T(RN,   -0x1.3384b4de46fa2p-5,   -0x1.3397327aec09bp-5,  -0x1.fffffap-2, INEXACT) // -3.753886533578955353451789278552e-02
T(RD,    0x1.958ca6bcf078cp-9,    0x1.958cd12533c6cp-9,  -0x1.fffff4p-1, INEXACT) // 3.094096521153616094479410492113e-03
T(RU,    0x1.958ca6bcf078cp-9,    0x1.958cd12533c6dp-9,  0x1.6de334p-22, INEXACT) // 3.094096521153616094479410492113e-03
T(RZ,    0x1.958ca6bcf078cp-9,    0x1.958cd12533c6cp-9,  -0x1.fffff4p-1, INEXACT) // 3.094096521153616094479410492113e-03
T(RD,   -0x1.4e1e572c7133ap-8,   -0x1.4e1eb607ecf8cp-8, -0x1.5a2a0ep-22, INEXACT) // -5.098243982904199569916592338359e-03
T(RU,   -0x1.4e1e572c7133ap-8,   -0x1.4e1eb607ecf8bp-8,   0x1.fffff6p-1, INEXACT) // -5.098243982904199569916592338359e-03
T(RZ,   -0x1.4e1e572c7133ap-8,   -0x1.4e1eb607ecf8bp-8,   0x1.fffff6p-1, INEXACT) // -5.098243982904199569916592338359e-03
T(RD,    0x1.6364bc2a46383p+3,   0x1.040c7e3dc95c2p+15,  -0x1.fffffep-1, INEXACT) // 1.110604675537775243299165595090e+01
T(RU,    0x1.6364bc2a46383p+3,   0x1.040c7e3dc95c3p+15,   0x1.6cb7cp-24, INEXACT) // 1.110604675537775243299165595090e+01
T(RZ,    0x1.6364bc2a46383p+3,   0x1.040c7e3dc95c2p+15,  -0x1.fffffep-1, INEXACT) // 1.110604675537775243299165595090e+01
T(RD,   -0x1.333833f5fb8cap+2,   -0x1.e6283e444f836p+5,  -0x1.fffff2p-1, INEXACT) // -4.800305357186696042504081560764e+00
T(RU,   -0x1.333833f5fb8cap+2,   -0x1.e6283e444f835p+5,  0x1.bb4f62p-22, INEXACT) // -4.800305357186696042504081560764e+00
T(RZ,   -0x1.333833f5fb8cap+2,   -0x1.e6283e444f835p+5,  0x1.bb4f62p-22, INEXACT) // -4.800305357186696042504081560764e+00
T(RN,    0x1.b746de144b829p-2,    0x1.c4dfd377da187p-2,   0x1.fffff8p-2, INEXACT) // 4.289812755477009909022001465928e-01
T(RN,   -0x1.46df619cf4df5p+0,   -0x1.a7380f22836abp+0,   0x1.fffff2p-2, INEXACT) // -1.276846028155771195500278736290e+00
T(RN,   -0x1.4c3a5925dfab9p-5,   -0x1.4c51aa075671cp-5,   -0x1.ffffep-2, INEXACT) // -4.055516635616158299670885867272e-02
T(RN,    0x1.9de776b94485ap+0,    0x1.35a9b0000e2f3p+1,  -0x1.ffffe6p-2, INEXACT) // 1.616813106757510443145520184771e+00
T(RN,    0x1.60e2d3ce325dap-9,    0x1.60e2efbe9b52ep-9,  -0x1.fffff2p-2, INEXACT) // 2.692306857259946402394223952115e-03
T(RN,  -0x1.99ad67378c14fp-10,  -0x1.99ad722555b2ap-10,   0x1.fffff4p-2, INEXACT) // -1.562795090546204501355531668594e-03
T(RN,     0x1.61424247b725p+7,  0x1.c4b066e01239fp+253,   0x1.ffffc4p-2, INEXACT) // 1.766294119273247815726790577173e+02
T(RD,    0x1.e04bb2a5f36a3p+8,  0x1.e474502e73fc4p+691,  -0x1.ffffeep-1, INEXACT) // 4.802956947058939363159879576415e+02
T(RU,    0x1.e04bb2a5f36a3p+8,  0x1.e474502e73fc5p+691,  0x1.153b96p-21, INEXACT) // 4.802956947058939363159879576415e+02
T(RZ,    0x1.e04bb2a5f36a3p+8,  0x1.e474502e73fc4p+691,  -0x1.ffffeep-1, INEXACT) // 4.802956947058939363159879576415e+02
T(RN,    0x1.abf05c9728fb1p-2,    0x1.b8812ca71876fp-2,   0x1.ffffd2p-2, INEXACT) // 4.179090945492545672301787362812e-01
T(RD,    0x1.c11c07132d2c5p-1,     0x1.fcf5669d12d8p-1,  -0x1.bd0fep-21, INEXACT) // 8.771669588955651741812857835612e-01
T(RU,    0x1.c11c07132d2c5p-1,    0x1.fcf5669d12d81p-1,   0x1.ffffe4p-1, INEXACT) // 8.771669588955651741812857835612e-01
T(RZ,    0x1.c11c07132d2c5p-1,     0x1.fcf5669d12d8p-1,  -0x1.bd0fep-21, INEXACT) // 8.771669588955651741812857835612e-01
T(RN,   -0x1.06551d93be75cp+6,  -0x1.88789f5d429ecp+93,  -0x1.ffffd6p-2, INEXACT) // -6.558312064027762744444771669805e+01
T(RN,    0x1.dd62694dd0646p-2,    0x1.eedd9aa2cb8eep-2,  -0x1.ffffeep-2, INEXACT) // 4.661957219833293697419662748871e-01
T(RN,   -0x1.aa7ef3a7afeccp+7, -0x1.9232cfb6360bep+306,   -0x1.ffffdp-2, INEXACT) // -2.132479526903392752501531504095e+02
T(RD,   -0x1.665dbdfacc79dp+2,   -0x1.0e47a3bfdc677p+7, -0x1.60abbep-21, INEXACT) // -5.599471564217222585568833892467e+00
T(RU,   -0x1.665dbdfacc79dp+2,   -0x1.0e47a3bfdc676p+7,   0x1.ffffeap-1, INEXACT) // -5.599471564217222585568833892467e+00
T(RZ,   -0x1.665dbdfacc79dp+2,   -0x1.0e47a3bfdc676p+7,   0x1.ffffeap-1, INEXACT) // -5.599471564217222585568833892467e+00
T(RD,    0x1.2e6f8f8c26a22p-8,    0x1.2e6fd5e5f2316p-8, -0x1.c825d4p-23, INEXACT) // 4.614803834693622167084647855972e-03
T(RU,    0x1.2e6f8f8c26a22p-8,    0x1.2e6fd5e5f2317p-8,   0x1.fffff8p-1, INEXACT) // 4.614803834693622167084647855972e-03
T(RZ,    0x1.2e6f8f8c26a22p-8,    0x1.2e6fd5e5f2316p-8, -0x1.c825d4p-23, INEXACT) // 4.614803834693622167084647855972e-03
T(RN,    0x1.33176c2cb5aadp+4,   0x1.9cfd4a69104edp+26,  -0x1.ffffccp-2, INEXACT) // 1.919321839775755123014278069604e+01
T(RD,   -0x1.1591100544bb7p-8,   -0x1.1591466791de5p-8,  -0x1.fffff8p-1, INEXACT) // -4.235330973886889359414364975009e-03
T(RU,   -0x1.1591100544bb7p-8,   -0x1.1591466791de4p-8,  0x1.132782p-22, INEXACT) // -4.235330973886889359414364975009e-03
T(RZ,   -0x1.1591100544bb7p-8,   -0x1.1591466791de4p-8,  0x1.132782p-22, INEXACT) // -4.235330973886889359414364975009e-03
T(RN,    0x1.300af1df511adp-2,    0x1.3487a54820e21p-2,  -0x1.ffffe4p-2, INEXACT) // 2.969167511512534329831680679490e-01
T(RN,   -0x1.c620387e59965p-7,   -0x1.c623f134a697ep-7,  -0x1.ffffe2p-2, INEXACT) // -1.385882147287693412496256684108e-02
T(RN,   -0x1.222b63d250fe9p-8,   -0x1.222ba1f4719ecp-8,   -0x1.ffffcp-2, INEXACT) // -4.427635069365700760946058522904e-03
T(RN,    0x1.2c5ec94b29be3p-2,    0x1.30b23ee272df9p-2,   0x1.fffffcp-2, INEXACT) // 2.933303310514345230153310239984e-01
T(RN,   -0x1.bcf0a2fd32508p+4,  -0x1.161dc68c490a8p+39,   0x1.fffffcp-2, INEXACT) // -2.780874918846987498000089544803e+01
T(RN,   -0x1.f14f1f730ceacp+8, -0x1.6171715fcdb73p+716,   0x1.ffffecp-2, INEXACT) // -4.973090736300025582750095054507e+02
T(RN,    0x1.ee19f9087faa3p-2,    0x1.00bfe654c4d77p-1,  -0x1.ffffd2p-2, INEXACT) // 4.825209533154667940202386944293e-01
T(RN,   -0x1.3c9dc63d421f6p+1,   -0x1.78f8e7c1178a8p+2,  -0x1.ffffe4p-2, INEXACT) // -2.473564891730570813876965985401e+00
T(RN,   0x1.57f4a95f803dap-10,   0x1.57f4afd741d86p-10,   0x1.fffff8p-2, INEXACT) // 1.312086904249768013613897110758e-03
T(RD,   -0x1.296cae8922dc1p-8,   -0x1.296cf1726fb2cp-8,  -0x1.fffffap-1, INEXACT) // -4.538338290454858349465272482348e-03
T(RU,   -0x1.296cae8922dc1p-8,   -0x1.296cf1726fb2bp-8,  0x1.7801f2p-23, INEXACT) // -4.538338290454858349465272482348e-03
T(RZ,   -0x1.296cae8922dc1p-8,   -0x1.296cf1726fb2bp-8,  0x1.7801f2p-23, INEXACT) // -4.538338290454858349465272482348e-03
T(RD,   0x1.af50d8388c3cfp-10,   0x1.af50e4f97c68ap-10,  -0x1.ffffeap-1, INEXACT) // 1.645339200092122344462608474203e-03
T(RU,   0x1.af50d8388c3cfp-10,   0x1.af50e4f97c68bp-10,  0x1.67a31cp-21, INEXACT) // 1.645339200092122344462608474203e-03
T(RZ,   0x1.af50d8388c3cfp-10,   0x1.af50e4f97c68ap-10,  -0x1.ffffeap-1, INEXACT) // 1.645339200092122344462608474203e-03
T(RD,    0x1.5af1eaf2f9528p+1,    0x1.df0d8fbc10c22p+2,  -0x1.fffff8p-1, INEXACT) // 2.710507744445425970525320735760e+00
T(RU,    0x1.5af1eaf2f9528p+1,    0x1.df0d8fbc10c23p+2,  0x1.d26d54p-23, INEXACT) // 2.710507744445425970525320735760e+00
T(RZ,    0x1.5af1eaf2f9528p+1,    0x1.df0d8fbc10c22p+2,  -0x1.fffff8p-1, INEXACT) // 2.710507744445425970525320735760e+00
T(RN,    0x1.6204e77499dbbp-1,    0x1.7ee909e13ca1cp-1,   0x1.ffffdap-2, INEXACT) // 6.914436654887404776204107292870e-01
T(RN,   -0x1.736e9a3af7dcbp-1,   -0x1.94e13e3ee6579p-1,   0x1.ffffc2p-2, INEXACT) // -7.254532048208884864592960184382e-01
T(RD,    0x1.954db829382e7p+5,   0x1.10b3e3f03cacbp+72,  -0x1.fffffap-1, INEXACT) // 5.066294891550733581198073807172e+01
T(RU,    0x1.954db829382e7p+5,   0x1.10b3e3f03caccp+72,  0x1.5e5d64p-23, INEXACT) // 5.066294891550733581198073807172e+01
T(RZ,    0x1.954db829382e7p+5,   0x1.10b3e3f03cacbp+72,  -0x1.fffffap-1, INEXACT) // 5.066294891550733581198073807172e+01
T(RD,    0x1.c44493dfc77bfp-8,    0x1.c4457f23965f2p-8,  -0x1.ffffe2p-1, INEXACT) // 6.901060201725372177106176962980e-03
T(RU,    0x1.c44493dfc77bfp-8,    0x1.c4457f23965f3p-8,  0x1.dc6358p-21, INEXACT) // 6.901060201725372177106176962980e-03
T(RZ,    0x1.c44493dfc77bfp-8,    0x1.c4457f23965f2p-8,  -0x1.ffffe2p-1, INEXACT) // 6.901060201725372177106176962980e-03
T(RD,   -0x1.67761e035a612p-4,   -0x1.67ec488781125p-4, -0x1.9e74bap-22, INEXACT) // -8.775912975183811082224849542399e-02
T(RU,   -0x1.67761e035a612p-4,   -0x1.67ec488781124p-4,   0x1.fffff4p-1, INEXACT) // -8.775912975183811082224849542399e-02
T(RZ,   -0x1.67761e035a612p-4,   -0x1.67ec488781124p-4,   0x1.fffff4p-1, INEXACT) // -8.775912975183811082224849542399e-02
T(RD,   -0x1.d52a9498a7cbep-8,   -0x1.d52b9b3ae19a5p-8,  -0x1.fffffcp-1, INEXACT) // -7.158910063167654366789172115659e-03
T(RU,   -0x1.d52a9498a7cbep-8,   -0x1.d52b9b3ae19a4p-8,   0x1.a2f19p-24, INEXACT) // -7.158910063167654366789172115659e-03
T(RZ,   -0x1.d52a9498a7cbep-8,   -0x1.d52b9b3ae19a4p-8,   0x1.a2f19p-24, INEXACT) // -7.158910063167654366789172115659e-03
T(RD,    0x1.cb2d4edb206b5p-7,    0x1.cb3127b6a76a8p-7,  -0x1.dbe52p-21, INEXACT) // 1.401296949757422673210616181905e-02
T(RU,    0x1.cb2d4edb206b5p-7,    0x1.cb3127b6a76a9p-7,   0x1.ffffe2p-1, INEXACT) // 1.401296949757422673210616181905e-02
T(RZ,    0x1.cb2d4edb206b5p-7,    0x1.cb3127b6a76a8p-7,  -0x1.dbe52p-21, INEXACT) // 1.401296949757422673210616181905e-02
T(RD,   -0x1.c3af9182c3f4bp-1,   -0x1.004c82815a1d8p+0, -0x1.1a8524p-21, INEXACT) // -8.821988556028171890588396308885e-01
T(RU,   -0x1.c3af9182c3f4bp-1,   -0x1.004c82815a1d7p+0,   0x1.ffffeep-1, INEXACT) // -8.821988556028171890588396308885e-01
T(RZ,   -0x1.c3af9182c3f4bp-1,   -0x1.004c82815a1d7p+0,   0x1.ffffeep-1, INEXACT) // -8.821988556028171890588396308885e-01
T(RN,    0x1.f2d55bce2e006p+4,   0x1.f89cd35417001p+43,   0x1.fffff6p-2, INEXACT) // 3.117708950556700386869124486111e+01
T(RD,   -0x1.83194f68031fbp-1,   -0x1.a90bc3bacc495p-1, -0x1.f25fe4p-24, INEXACT) // -7.560524763553638782909160909185e-01
T(RU,   -0x1.83194f68031fbp-1,   -0x1.a90bc3bacc494p-1,   0x1.fffffcp-1, INEXACT) // -7.560524763553638782909160909185e-01
T(RZ,   -0x1.83194f68031fbp-1,   -0x1.a90bc3bacc494p-1,   0x1.fffffcp-1, INEXACT) // -7.560524763553638782909160909185e-01
T(RD,    0x1.25cf710839d8dp-2,     0x1.29dbb8e7c0e6p-2,  -0x1.3c91bp-24, INEXACT) // 2.869241391440134347767809686047e-01
T(RU,    0x1.25cf710839d8dp-2,    0x1.29dbb8e7c0e61p-2,   0x1.fffffep-1, INEXACT) // 2.869241391440134347767809686047e-01
T(RZ,    0x1.25cf710839d8dp-2,     0x1.29dbb8e7c0e6p-2,  -0x1.3c91bp-24, INEXACT) // 2.869241391440134347767809686047e-01
T(RD,    0x1.8c78d9e92b67ep-5,    0x1.8ca07a91f48d7p-5,  -0x1.fffff4p-1, INEXACT) // 4.839747009951354816958968285689e-02
T(RU,    0x1.8c78d9e92b67ep-5,    0x1.8ca07a91f48d8p-5,  0x1.94af86p-22, INEXACT) // 4.839747009951354816958968285689e-02
T(RZ,    0x1.8c78d9e92b67ep-5,    0x1.8ca07a91f48d7p-5,  -0x1.fffff4p-1, INEXACT) // 4.839747009951354816958968285689e-02
T(RD,   -0x1.b6de2fad39af2p-3,   -0x1.ba3c0719dd0b5p-3,  -0x1.3f31ap-21, INEXACT) // -2.142909741152930203078597060085e-01
T(RU,   -0x1.b6de2fad39af2p-3,   -0x1.ba3c0719dd0b4p-3,   0x1.ffffecp-1, INEXACT) // -2.142909741152930203078597060085e-01
T(RZ,   -0x1.b6de2fad39af2p-3,   -0x1.ba3c0719dd0b4p-3,   0x1.ffffecp-1, INEXACT) // -2.142909741152930203078597060085e-01
T(RN,   -0x1.f72e65db2fab1p-9,   -0x1.f72eb6db10939p-9,   0x1.ffffeep-2, INEXACT) // -3.838968213670434104917150719416e-03
T(RN,   -0x1.5cc8ab3ce12c7p+7, -0x1.82836edf211c8p+250,  -0x1.ffffc4p-2, INEXACT) // -1.743919314408178422581841005012e+02
T(RD,   -0x1.aa22ae4a0d855p-1,   -0x1.dd10fe708df88p-1, -0x1.dcd4aep-24, INEXACT) // -8.322958436390403003102278489678e-01
T(RU,   -0x1.aa22ae4a0d855p-1,   -0x1.dd10fe708df87p-1,   0x1.fffffcp-1, INEXACT) // -8.322958436390403003102278489678e-01
T(RZ,   -0x1.aa22ae4a0d855p-1,   -0x1.dd10fe708df87p-1,   0x1.fffffcp-1, INEXACT) // -8.322958436390403003102278489678e-01
T(RD,    0x1.64d81be2f6042p-8,    0x1.64d88f722b3d3p-8, -0x1.bebcc4p-23, INEXACT) // 5.445010002368690441021392700804e-03
T(RU,    0x1.64d81be2f6042p-8,    0x1.64d88f722b3d4p-8,   0x1.fffffap-1, INEXACT) // 5.445010002368690441021392700804e-03
T(RZ,    0x1.64d81be2f6042p-8,    0x1.64d88f722b3d3p-8, -0x1.bebcc4p-23, INEXACT) // 5.445010002368690441021392700804e-03
T(RN,   -0x1.7049e98146a23p+3,  -0x1.851a763ad889ap+15,  -0x1.fffffep-2, INEXACT) // -1.150902247666551225790954049444e+01
T(RD,    0x1.eb600fd1720f3p+4,   0x1.3c9acf8a916dbp+43, -0x1.22a4ccp-21, INEXACT) // 3.071095258536020011774780869018e+01
T(RU,    0x1.eb600fd1720f3p+4,   0x1.3c9acf8a916dcp+43,   0x1.ffffeep-1, INEXACT) // 3.071095258536020011774780869018e+01
T(RZ,    0x1.eb600fd1720f3p+4,   0x1.3c9acf8a916dbp+43, -0x1.22a4ccp-21, INEXACT) // 3.071095258536020011774780869018e+01
T(RD,    0x1.a23b86553613ep+7,  0x1.9d48bd7805fbcp+300, -0x1.93673ap-21, INEXACT) // 2.091162592533600559363549109548e+02
T(RU,    0x1.a23b86553613ep+7,  0x1.9d48bd7805fbdp+300,   0x1.ffffe6p-1, INEXACT) // 2.091162592533600559363549109548e+02
T(RZ,    0x1.a23b86553613ep+7,  0x1.9d48bd7805fbcp+300, -0x1.93673ap-21, INEXACT) // 2.091162592533600559363549109548e+02
T(RD,      0x1.a66c269cd72p+2,    0x1.6fad0ae66fe18p+8,  -0x1.ffffeep-1, INEXACT) // 6.600351002849947690265253186226e+00
T(RU,      0x1.a66c269cd72p+2,    0x1.6fad0ae66fe19p+8,   0x1.1fc8bp-21, INEXACT) // 6.600351002849947690265253186226e+00
T(RZ,      0x1.a66c269cd72p+2,    0x1.6fad0ae66fe18p+8,  -0x1.ffffeep-1, INEXACT) // 6.600351002849947690265253186226e+00
T(RD,   -0x1.fc4f4b99b2ff6p+8, -0x1.43202def3d051p+732,  -0x1.0ca3ap-21, INEXACT) // -5.083097473203664549146196804941e+02
T(RU,   -0x1.fc4f4b99b2ff6p+8,  -0x1.43202def3d05p+732,    0x1.fffffp-1, INEXACT) // -5.083097473203664549146196804941e+02
T(RZ,   -0x1.fc4f4b99b2ff6p+8,  -0x1.43202def3d05p+732,    0x1.fffffp-1, INEXACT) // -5.083097473203664549146196804941e+02
T(RD,   -0x1.e283786c17f63p+4,   -0x1.6beca085362ap+42,  -0x1.ffffe4p-1, INEXACT) // -3.015709726547300917331995151471e+01
T(RU,   -0x1.e283786c17f63p+4,  -0x1.6beca0853629fp+42,  0x1.b44ef6p-21, INEXACT) // -3.015709726547300917331995151471e+01
T(RZ,   -0x1.e283786c17f63p+4,  -0x1.6beca0853629fp+42,  0x1.b44ef6p-21, INEXACT) // -3.015709726547300917331995151471e+01
T(RN,    0x1.b051b71d083d2p-5,    0x1.b085180dafe77p-5,  -0x1.ffffc8p-2, INEXACT) // 5.277333988511369311513732327512e-02
T(RN,    0x1.819895cd8943bp+0,     0x1.126e2b0ae679p+1,  -0x1.fffffep-2, INEXACT) // 1.506234514884694730696423903282e+00
T(RN,   -0x1.6cf4ba96e0991p+1,    -0x1.1404734ce196p+3,  -0x1.ffffc4p-2, INEXACT) // -2.851218532248090742342583325808e+00
T(RD,     0x1.af2e74e7ab2dp+8,  0x1.0b7ed43020539p+621,  -0x1.ffffeep-1, INEXACT) // 4.311814713280591604416258633137e+02
T(RU,     0x1.af2e74e7ab2dp+8,  0x1.0b7ed4302053ap+621,    0x1.24d9p-21, INEXACT) // 4.311814713280591604416258633137e+02
T(RZ,     0x1.af2e74e7ab2dp+8,  0x1.0b7ed43020539p+621,  -0x1.ffffeep-1, INEXACT) // 4.311814713280591604416258633137e+02
T(RD,   -0x1.8ed0ea7569703p-7,   -0x1.8ed36fbdc65ebp-7, -0x1.362758p-21, INEXACT) // -1.217090080428873642703901936102e-02
T(RU,   -0x1.8ed0ea7569703p-7,   -0x1.8ed36fbdc65eap-7,   0x1.ffffecp-1, INEXACT) // -1.217090080428873642703901936102e-02
T(RZ,   -0x1.8ed0ea7569703p-7,   -0x1.8ed36fbdc65eap-7,   0x1.ffffecp-1, INEXACT) // -1.217090080428873642703901936102e-02
T(RD,    0x1.329f7cd092d03p-9,    0x1.329f8f24a0e19p-9, -0x1.e1cc14p-21, INEXACT) // 2.339347826170291768516085184615e-03
T(RU,    0x1.329f7cd092d03p-9,    0x1.329f8f24a0e1ap-9,   0x1.ffffe2p-1, INEXACT) // 2.339347826170291768516085184615e-03
T(RZ,    0x1.329f7cd092d03p-9,    0x1.329f8f24a0e19p-9, -0x1.e1cc14p-21, INEXACT) // 2.339347826170291768516085184615e-03
T(RD,    0x1.06c445984f249p-8,     0x1.06c473bc378cp-8,  -0x1.fffff2p-1, INEXACT) // 4.009501448589755136231449483830e-03
T(RU,    0x1.06c445984f249p-8,    0x1.06c473bc378c1p-8,  0x1.aaa588p-22, INEXACT) // 4.009501448589755136231449483830e-03
T(RZ,    0x1.06c445984f249p-8,     0x1.06c473bc378cp-8,  -0x1.fffff2p-1, INEXACT) // 4.009501448589755136231449483830e-03
T(RD,    0x1.571c5ae29cdcap+8,  0x1.00bed168aaa79p+494,  -0x1.ffffecp-1, INEXACT) // 3.431107617981875819168635644019e+02
T(RU,    0x1.571c5ae29cdcap+8,  0x1.00bed168aaa7ap+494,   0x1.3a913p-21, INEXACT) // 3.431107617981875819168635644019e+02
T(RZ,    0x1.571c5ae29cdcap+8,  0x1.00bed168aaa79p+494,  -0x1.ffffecp-1, INEXACT) // 3.431107617981875819168635644019e+02
T(RN,    -0x1.cd3d0a4e992cp+5,  -0x1.21ad4b6539e6ap+82,  -0x1.fffff6p-2, INEXACT) // -5.765480481533950296579860150814e+01
T(RN,   -0x1.a01e7e4911251p+4,  -0x1.6f4c8fc6827cdp+36,   0x1.ffffd8p-2, INEXACT) // -2.600744465390954829331349174026e+01
T(RD,    0x1.ba62aa6b78c7bp+4,   0x1.da26a3f98e585p+38, -0x1.b9cfdcp-23, INEXACT) // 2.764908830624743174553259450477e+01
T(RU,    0x1.ba62aa6b78c7bp+4,   0x1.da26a3f98e586p+38,   0x1.fffffap-1, INEXACT) // 2.764908830624743174553259450477e+01
T(RZ,    0x1.ba62aa6b78c7bp+4,   0x1.da26a3f98e585p+38, -0x1.b9cfdcp-23, INEXACT) // 2.764908830624743174553259450477e+01
T(RD,    0x1.cdd21ff329b13p-7,    0x1.cdd609ead1306p-7, -0x1.6df308p-21, INEXACT) // 1.409365234424123612677615113853e-02
T(RU,    0x1.cdd21ff329b13p-7,    0x1.cdd609ead1307p-7,   0x1.ffffeap-1, INEXACT) // 1.409365234424123612677615113853e-02
T(RZ,    0x1.cdd21ff329b13p-7,    0x1.cdd609ead1306p-7, -0x1.6df308p-21, INEXACT) // 1.409365234424123612677615113853e-02
T(RN,    -0x1.9e5ac4ea0695p+7, -0x1.db9c877da4949p+297,  -0x1.ffffd6p-2, INEXACT) // -2.071772835858378130069468170404e+02
T(RN,    0x1.afd088b21c2bdp-7,    0x1.afd3bbc5b67b7p-7,   0x1.ffffc4p-2, INEXACT) // 1.317793535801691819087100299157e-02
T(RD,    0x1.f5a594c3b9882p-5,    0x1.f5f5db5b93a3bp-5,   -0x1.fffffp-1, INEXACT) // 6.123618178917046572795612746631e-02
T(RU,    0x1.f5a594c3b9882p-5,    0x1.f5f5db5b93a3cp-5,  0x1.f211acp-22, INEXACT) // 6.123618178917046572795612746631e-02
T(RZ,    0x1.f5a594c3b9882p-5,    0x1.f5f5db5b93a3bp-5,   -0x1.fffffp-1, INEXACT) // 6.123618178917046572795612746631e-02
T(RD,   -0x1.08e004a5a8cd3p+0,   -0x1.3abae210e30e4p+0, -0x1.ec8a1ap-21, INEXACT) // -1.034668245739159386786809591285e+00
T(RU,   -0x1.08e004a5a8cd3p+0,   -0x1.3abae210e30e3p+0,   0x1.ffffe2p-1, INEXACT) // -1.034668245739159386786809591285e+00
T(RZ,   -0x1.08e004a5a8cd3p+0,   -0x1.3abae210e30e3p+0,   0x1.ffffe2p-1, INEXACT) // -1.034668245739159386786809591285e+00
T(RD,    0x1.620d1c66a78fep-7,    0x1.620edfdf2a25cp-7,  -0x1.ffffe4p-1, INEXACT) // 1.080478560225772363678764520500e-02
T(RU,    0x1.620d1c66a78fep-7,    0x1.620edfdf2a25dp-7,  0x1.bf87a6p-21, INEXACT) // 1.080478560225772363678764520500e-02
T(RZ,    0x1.620d1c66a78fep-7,    0x1.620edfdf2a25cp-7,  -0x1.ffffe4p-1, INEXACT) // 1.080478560225772363678764520500e-02
T(RN,    0x1.0a4134dc5233ep+8,  0x1.170b831979213p+383,   0x1.ffffd6p-2, INEXACT) // 2.662547128391923934032092802227e+02
T(RD,   0x1.9739174bd3041p-10,   0x1.97392207a0e66p-10,  -0x1.fffff2p-1, INEXACT) // 1.553432509314070725583989407426e-03
T(RU,   0x1.9739174bd3041p-10,   0x1.97392207a0e67p-10,   0x1.b4599p-22, INEXACT) // 1.553432509314070725583989407426e-03
T(RZ,   0x1.9739174bd3041p-10,   0x1.97392207a0e66p-10,  -0x1.fffff2p-1, INEXACT) // 1.553432509314070725583989407426e-03
T(RD,    0x1.5baaa8ca36e86p-3,    0x1.5d56c1fc00a35p-3,  -0x1.ffffecp-1, INEXACT) // 1.697591006003344449304393037892e-01
T(RU,    0x1.5baaa8ca36e86p-3,    0x1.5d56c1fc00a36p-3,   0x1.41e8fp-21, INEXACT) // 1.697591006003344449304393037892e-01
T(RZ,    0x1.5baaa8ca36e86p-3,    0x1.5d56c1fc00a35p-3,  -0x1.ffffecp-1, INEXACT) // 1.697591006003344449304393037892e-01
T(RD,   -0x1.965fb9ca99ccdp-4,   -0x1.970a79ba08f9bp-4, -0x1.8c19cap-22, INEXACT) // -9.921238493699320593055546169126e-02
T(RU,   -0x1.965fb9ca99ccdp-4,   -0x1.970a79ba08f9ap-4,   0x1.fffff4p-1, INEXACT) // -9.921238493699320593055546169126e-02
T(RZ,   -0x1.965fb9ca99ccdp-4,   -0x1.970a79ba08f9ap-4,   0x1.fffff4p-1, INEXACT) // -9.921238493699320593055546169126e-02
T(RD,    0x1.75a7c6d372535p+7,  0x1.7306e57193697p+268,   -0x1.fffffp-1, INEXACT) // 1.868276887967164441306522348896e+02
T(RU,    0x1.75a7c6d372535p+7,  0x1.7306e57193698p+268,  0x1.0f6f58p-21, INEXACT) // 1.868276887967164441306522348896e+02
T(RZ,    0x1.75a7c6d372535p+7,  0x1.7306e57193697p+268,   -0x1.fffffp-1, INEXACT) // 1.868276887967164441306522348896e+02
T(RN,    0x1.c80b215eb19abp-4,    0x1.c8fc7c502a62ap-4,   0x1.ffffcap-2, INEXACT) // 1.113387397300359821228354917366e-01
T(RN,   -0x1.b5cdb51447e44p+6, -0x1.df1f57f0ebab3p+156,   0x1.ffffdep-2, INEXACT) // -1.094508860749129439682292286307e+02
T(RN,   -0x1.c01dfced662a2p-4,    -0x1.c102f898738dp-4,  -0x1.ffffccp-2, INEXACT) // -1.094035987829422851280725126344e-01
T(RD,    0x1.272d8642299cap+2,    0x1.92c36f4be3f53p+5,  -0x1.fffff6p-1, INEXACT) // 4.612153591739522440207110776100e+00
T(RU,    0x1.272d8642299cap+2,    0x1.92c36f4be3f54p+5,  0x1.4be362p-22, INEXACT) // 4.612153591739522440207110776100e+00
T(RZ,    0x1.272d8642299cap+2,    0x1.92c36f4be3f53p+5,  -0x1.fffff6p-1, INEXACT) // 4.612153591739522440207110776100e+00
T(RN,   -0x1.0d0d95db42fd8p-2,   -0x1.1028d4e4a06dep-2,  -0x1.ffffcap-2, INEXACT) // -2.627471366001805641587907302892e-01
T(RN,   -0x1.a39fdd321e3d9p+7, -0x1.9e745f116739ap+301,   -0x1.ffffdp-2, INEXACT) // -2.098122344648279806733626173809e+02
T(RD,    0x1.c54d867a938a2p-8,    0x1.c54e735ccd015p-8, -0x1.6f2104p-22, INEXACT) // 6.916852313748974093177146471589e-03
T(RU,    0x1.c54d867a938a2p-8,    0x1.c54e735ccd016p-8,   0x1.fffff4p-1, INEXACT) // 6.916852313748974093177146471589e-03
T(RZ,    0x1.c54d867a938a2p-8,    0x1.c54e735ccd015p-8, -0x1.6f2104p-22, INEXACT) // 6.916852313748974093177146471589e-03
T(RD,   -0x1.9104b218ef088p+5,  -0x1.3f37ba187e846p+71, -0x1.5177d6p-21, INEXACT) // -5.012729281882735676845186389983e+01
T(RU,   -0x1.9104b218ef088p+5,  -0x1.3f37ba187e845p+71,   0x1.ffffeap-1, INEXACT) // -5.012729281882735676845186389983e+01
T(RZ,   -0x1.9104b218ef088p+5,  -0x1.3f37ba187e845p+71,   0x1.ffffeap-1, INEXACT) // -5.012729281882735676845186389983e+01
T(RD,    0x1.2bdd448fdae35p+5,   0x1.0df58a563c958p+53,  -0x1.fffffcp-1, INEXACT) // 3.748304092776053408897496410646e+01
T(RU,    0x1.2bdd448fdae35p+5,   0x1.0df58a563c959p+53,  0x1.f62d64p-24, INEXACT) // 3.748304092776053408897496410646e+01
T(RZ,    0x1.2bdd448fdae35p+5,   0x1.0df58a563c958p+53,  -0x1.fffffcp-1, INEXACT) // 3.748304092776053408897496410646e+01
T(RN,    0x1.36bb244b6fc94p+3,   0x1.019d1eaf4d771p+13,   0x1.fffff4p-2, INEXACT) // 9.710344455086932669019006425515e+00
T(RD,    0x1.9e58b941a0513p-9,    0x1.9e58e67bce401p-9, -0x1.671c52p-21, INEXACT) // 3.161213506985513423813705102816e-03
T(RU,    0x1.9e58b941a0513p-9,    0x1.9e58e67bce402p-9,   0x1.ffffeap-1, INEXACT) // 3.161213506985513423813705102816e-03
T(RZ,    0x1.9e58b941a0513p-9,    0x1.9e58e67bce401p-9, -0x1.671c52p-21, INEXACT) // 3.161213506985513423813705102816e-03
T(RN,   -0x1.f9b95fc373ba8p+4,  -0x1.841e6e59cf19ap+44,   0x1.ffffc8p-2, INEXACT) // -3.160775734280073834270297084004e+01
T(RD,    0x1.03c1b2044438dp+8,  0x1.ae6abfe15e413p+373, -0x1.acbb0ap-21, INEXACT) // 2.597566225687558585377701092511e+02
T(RU,    0x1.03c1b2044438dp+8,  0x1.ae6abfe15e414p+373,   0x1.ffffe6p-1, INEXACT) // 2.597566225687558585377701092511e+02
T(RZ,    0x1.03c1b2044438dp+8,  0x1.ae6abfe15e413p+373, -0x1.acbb0ap-21, INEXACT) // 2.597566225687558585377701092511e+02
T(RD,    0x1.f7a7146d0a0e7p-6,    0x1.f7bb6338997a6p-6,  -0x1.fffffcp-1, INEXACT) // 3.074051851959405320946494555301e-02
T(RU,    0x1.f7a7146d0a0e7p-6,    0x1.f7bb6338997a7p-6,   0x1.2540ep-23, INEXACT) // 3.074051851959405320946494555301e-02
T(RZ,    0x1.f7a7146d0a0e7p-6,    0x1.f7bb6338997a6p-6,  -0x1.fffffcp-1, INEXACT) // 3.074051851959405320946494555301e-02
T(RN,   0x1.e456e0025b598p-10,   0x1.e456f2118236ap-10,   0x1.ffffe2p-2, INEXACT) // 1.847608015477097617718094113570e-03
T(RN,    0x1.27424d98c4ec8p+3,   0x1.3db3371cadf21p+12,  -0x1.ffffc4p-2, INEXACT) // 9.226843641641053750390710774809e+00
T(RD,    0x1.b42c07a2d14e6p+4,   0x1.418f958027eb7p+38, -0x1.695a48p-21, INEXACT) // 2.726074946976304858026196598075e+01
T(RU,    0x1.b42c07a2d14e6p+4,   0x1.418f958027eb8p+38,   0x1.ffffeap-1, INEXACT) // 2.726074946976304858026196598075e+01
T(RZ,    0x1.b42c07a2d14e6p+4,   0x1.418f958027eb7p+38, -0x1.695a48p-21, INEXACT) // 2.726074946976304858026196598075e+01
T(RN,   -0x1.54363e78cd306p-8,   -0x1.5436a29d3f9e3p-8,   0x1.ffffe4p-2, INEXACT) // -5.191221477436119488557686452168e-03
T(RN,    -0x1.99279747a251p+5,  -0x1.b9514d9966287p+72,   -0x1.ffffdp-2, INEXACT) // -5.114433151210880623693810775876e+01
T(RN,    0x1.2227b163fd146p+8,  0x1.85704f0176a96p+417,  -0x1.fffff6p-2, INEXACT) // 2.901550505154485790626495145261e+02
T(RD,     0x1.9a6a95b8b57ap-3,    0x1.9d2b3cab56d83p-3, -0x1.1a48dcp-21, INEXACT) // 2.003986069673233672006062988658e-01
T(RU,     0x1.9a6a95b8b57ap-3,    0x1.9d2b3cab56d84p-3,   0x1.ffffeep-1, INEXACT) // 2.003986069673233672006062988658e-01
T(RZ,     0x1.9a6a95b8b57ap-3,    0x1.9d2b3cab56d83p-3, -0x1.1a48dcp-21, INEXACT) // 2.003986069673233672006062988658e-01
T(RD,   0x1.615110cc167edp-10,   0x1.615117cebe6a2p-10, -0x1.d48826p-22, INEXACT) // 1.347796106549110960529103131478e-03
T(RU,   0x1.615110cc167edp-10,   0x1.615117cebe6a3p-10,   0x1.fffff2p-1, INEXACT) // 1.347796106549110960529103131478e-03
T(RZ,   0x1.615110cc167edp-10,   0x1.615117cebe6a2p-10, -0x1.d48826p-22, INEXACT) // 1.347796106549110960529103131478e-03
T(RD,   -0x1.b51d3c92e008ap+4,  -0x1.5510d46ba5d28p+38,  -0x1.ffffecp-1, INEXACT) // -2.731963784573648723608130239882e+01
T(RU,   -0x1.b51d3c92e008ap+4,  -0x1.5510d46ba5d27p+38,  0x1.373ac6p-21, INEXACT) // -2.731963784573648723608130239882e+01
T(RZ,   -0x1.b51d3c92e008ap+4,  -0x1.5510d46ba5d27p+38,  0x1.373ac6p-21, INEXACT) // -2.731963784573648723608130239882e+01
T(RN,   -0x1.4f6b8762a13a4p+8, -0x1.e0a47c6afb1f7p+482,   0x1.ffffdep-2, INEXACT) // -3.354200345653173371829325333238e+02
T(RD,    0x1.630416bb39c6dp-4,    0x1.6375ec7a8716ep-4,  -0x1.fffffep-1, INEXACT) // 8.667382125314455898479337747631e-02
T(RU,    0x1.630416bb39c6dp-4,    0x1.6375ec7a8716fp-4,  0x1.3b07fap-24, INEXACT) // 8.667382125314455898479337747631e-02
T(RZ,    0x1.630416bb39c6dp-4,    0x1.6375ec7a8716ep-4,  -0x1.fffffep-1, INEXACT) // 8.667382125314455898479337747631e-02
T(RD,    0x1.72541e187b46ap+3,   0x1.9eb6f6899215bp+15, -0x1.acbd1ap-23, INEXACT) // 1.157276825696517974506605241913e+01
T(RU,    0x1.72541e187b46ap+3,   0x1.9eb6f6899215cp+15,   0x1.fffffap-1, INEXACT) // 1.157276825696517974506605241913e+01
T(RZ,    0x1.72541e187b46ap+3,   0x1.9eb6f6899215bp+15, -0x1.acbd1ap-23, INEXACT) // 1.157276825696517974506605241913e+01
T(RD,   -0x1.3df871e29e177p-1,   -0x1.52cec80d894a8p-1,  -0x1.ffffe8p-1, INEXACT) // -6.210361088879342572610653405718e-01
T(RU,   -0x1.3df871e29e177p-1,   -0x1.52cec80d894a7p-1,   0x1.830f9p-21, INEXACT) // -6.210361088879342572610653405718e-01
T(RZ,   -0x1.3df871e29e177p-1,   -0x1.52cec80d894a7p-1,   0x1.830f9p-21, INEXACT) // -6.210361088879342572610653405718e-01
T(RN,   -0x1.6be2632ab5b33p+5,  -0x1.89ebe15e5ed49p+64,   0x1.ffffc8p-2, INEXACT) // -4.548554070822719808120382367633e+01
T(RN,   -0x1.13c554cbb7ebcp-7,   -0x1.13c62a23232b1p-7,  -0x1.fffff6p-2, INEXACT) // -8.415857700526323259548888700010e-03
T(RD,    0x1.ede1274446831p-1,    0x1.1f0e6bcadc023p+0, -0x1.125898p-21, INEXACT) // 9.646084090084113826790712664661e-01
T(RU,    0x1.ede1274446831p-1,    0x1.1f0e6bcadc024p+0,   0x1.ffffeep-1, INEXACT) // 9.646084090084113826790712664661e-01
T(RZ,    0x1.ede1274446831p-1,    0x1.1f0e6bcadc023p+0, -0x1.125898p-21, INEXACT) // 9.646084090084113826790712664661e-01
T(RD,    0x1.c256b9db470ffp+3,   0x1.3bdde47cdd1d2p+19,  -0x1.fffff8p-1, INEXACT) // 1.407308667018560122130566014675e+01
T(RU,    0x1.c256b9db470ffp+3,   0x1.3bdde47cdd1d3p+19,  0x1.d6efccp-23, INEXACT) // 1.407308667018560122130566014675e+01
T(RZ,    0x1.c256b9db470ffp+3,   0x1.3bdde47cdd1d2p+19,  -0x1.fffff8p-1, INEXACT) // 1.407308667018560122130566014675e+01
T(RN,   -0x1.7ffdc59909dbbp+2,   -0x1.935f179cbdfbep+7,   0x1.ffffd2p-2, INEXACT) // -5.999864005519550680389784247382e+00
T(RN,    0x1.da4fc1d4c6955p-5,    0x1.da939c5898254p-5,  -0x1.ffffccp-2, INEXACT) // 5.789935929915893814134975059460e-02
T(RN,   -0x1.c02449b542944p-4,   -0x1.c1094f09c6a1ep-4,   0x1.fffffap-2, INEXACT) // -1.094096068592636528116202043748e-01
T(RN,   -0x1.8804036ee872cp+3,    -0x1.985dd94ec03p+16,  -0x1.ffffd2p-2, INEXACT) // -1.225048991834372458242796710692e+01
T(RN,    0x1.b204768a0d74fp-7,     0x1.b207b63718a9p-7,  -0x1.ffffe6p-2, INEXACT) // 1.324516094255625935083298116979e-02
T(RD,     0x1.bda952cd3986p-4,    0x1.be8a8fa44406ap-4, -0x1.be4f06p-21, INEXACT) // 1.088040575446895807942837564042e-01
T(RU,     0x1.bda952cd3986p-4,    0x1.be8a8fa44406bp-4,   0x1.ffffe4p-1, INEXACT) // 1.088040575446895807942837564042e-01
T(RZ,     0x1.bda952cd3986p-4,    0x1.be8a8fa44406ap-4, -0x1.be4f06p-21, INEXACT) // 1.088040575446895807942837564042e-01
T(RN,    0x1.7b90151d14959p-7,    0x1.7b9241613eb9dp-7,   -0x1.ffffdp-2, INEXACT) // 1.158333807885429840578428439812e-02
T(RD,   -0x1.2eaa6268a9a47p+2,   -0x1.c4c2f96988547p+5,  -0x1.ffffeap-1, INEXACT) // -4.729149439057954928955496143317e+00
T(RU,   -0x1.2eaa6268a9a47p+2,   -0x1.c4c2f96988546p+5,   0x1.610f6p-21, INEXACT) // -4.729149439057954928955496143317e+00
T(RZ,   -0x1.2eaa6268a9a47p+2,   -0x1.c4c2f96988546p+5,   0x1.610f6p-21, INEXACT) // -4.729149439057954928955496143317e+00
T(RD,   -0x1.5b7a8fb7f9d7ap-4,   -0x1.5be54c116e52dp-4,  -0x1.fffffep-1, INEXACT) // -8.483368053531661900912297369359e-02
T(RU,   -0x1.5b7a8fb7f9d7ap-4,   -0x1.5be54c116e52cp-4,  0x1.8c3a38p-25, INEXACT) // -8.483368053531661900912297369359e-02
T(RZ,   -0x1.5b7a8fb7f9d7ap-4,   -0x1.5be54c116e52cp-4,  0x1.8c3a38p-25, INEXACT) // -8.483368053531661900912297369359e-02
T(RN,    0x1.438bdac382e33p+2,    0x1.39b9a9a5364d1p+6,  -0x1.fffffap-2, INEXACT) // 5.055411044053061964120843185810e+00
T(RD,   -0x1.0bca80695d689p+2,   -0x1.068315a0781fdp+5, -0x1.826e48p-21, INEXACT) // -4.184234717269313286180931754643e+00
T(RU,   -0x1.0bca80695d689p+2,   -0x1.068315a0781fcp+5,   0x1.ffffe8p-1, INEXACT) // -4.184234717269313286180931754643e+00
T(RZ,   -0x1.0bca80695d689p+2,   -0x1.068315a0781fcp+5,   0x1.ffffe8p-1, INEXACT) // -4.184234717269313286180931754643e+00
T(RN,    0x1.5caf6d6b2577bp+3,   0x1.a5bcec1b23afbp+14,  -0x1.ffffccp-2, INEXACT) // 1.089641447951338726340964058181e+01
T(RN,    0x1.03fa29a4e0eeap-7,    0x1.03fadc63d090cp-7,  -0x1.ffffeep-2, INEXACT) // 7.933874448787976013663936214471e-03
T(RN,    0x1.6a376007682bap+5,   0x1.3fc8ff08a2794p+64,  -0x1.ffffe6p-2, INEXACT) // 4.527703862940457213426270755008e+01
T(RD,    -0x1.6793a9b848b5p-2,   -0x1.6f031c5d6fb97p-2,  -0x1.ffffe4p-1, INEXACT) // -3.511492270210299082577876106370e-01
T(RU,    -0x1.6793a9b848b5p-2,   -0x1.6f031c5d6fb96p-2,  0x1.be6788p-21, INEXACT) // -3.511492270210299082577876106370e-01
T(RZ,    -0x1.6793a9b848b5p-2,   -0x1.6f031c5d6fb96p-2,  0x1.be6788p-21, INEXACT) // -3.511492270210299082577876106370e-01
T(RN,    0x1.1b8f1be0badf2p-5,    0x1.1b9d9affe81e9p-5,  -0x1.fffff6p-2, INEXACT) // 3.461413807766779149321934028194e-02
T(RD,    0x1.af0165e77c439p-9,    0x1.af0198cf12d64p-9, -0x1.a71312p-21, INEXACT) // 3.288310708506017327606985034549e-03
T(RU,    0x1.af0165e77c439p-9,    0x1.af0198cf12d65p-9,   0x1.ffffe6p-1, INEXACT) // 3.288310708506017327606985034549e-03
T(RZ,    0x1.af0165e77c439p-9,    0x1.af0198cf12d64p-9, -0x1.a71312p-21, INEXACT) // 3.288310708506017327606985034549e-03
T(RD,    -0x1.6f716885f721p+5,  -0x1.334dead1c5468p+65, -0x1.08dc74p-21, INEXACT) // -4.593037514362742967932717874646e+01
T(RU,    -0x1.6f716885f721p+5,  -0x1.334dead1c5467p+65,    0x1.fffffp-1, INEXACT) // -4.593037514362742967932717874646e+01
T(RZ,    -0x1.6f716885f721p+5,  -0x1.334dead1c5467p+65,    0x1.fffffp-1, INEXACT) // -4.593037514362742967932717874646e+01
T(RN,    0x1.5217af98a5da8p+3,   0x1.2ee32bef51a95p+14,   -0x1.ffffep-2, INEXACT) // 1.056539134801899137983127729967e+01
T(RD,    0x1.d1a5dce8e875fp+5,   0x1.f6ad7dfa412d5p+82,  -0x1.fffff8p-1, INEXACT) // 5.820598775824941384371413732879e+01
T(RU,    0x1.d1a5dce8e875fp+5,   0x1.f6ad7dfa412d6p+82,  0x1.d0224ap-23, INEXACT) // 5.820598775824941384371413732879e+01
T(RZ,    0x1.d1a5dce8e875fp+5,   0x1.f6ad7dfa412d5p+82,  -0x1.fffff8p-1, INEXACT) // 5.820598775824941384371413732879e+01
T(RN,    0x1.32ba8e92cc96dp-2,    0x1.3756103b48256p-2,   0x1.ffffc6p-2, INEXACT) // 2.995397832011324479317693203484e-01
T(RN,   -0x1.69705b0ab9a3bp-6,   -0x1.6977dc6184944p-6,  -0x1.fffff8p-2, INEXACT) // -2.206047907648154768334158859489e-02
T(RN,    0x1.7187fb0885a39p+2,    0x1.41cb8a40e6e2ap+7,   0x1.ffffd6p-2, INEXACT) // 5.773924597093860633378881175304e+00
T(RD,   -0x1.c0dc387c1a49bp+1,   -0x1.0a785843b6b78p+4, -0x1.79782ap-21, INEXACT) // -3.506720600697531775580273460946e+00
T(RU,   -0x1.c0dc387c1a49bp+1,   -0x1.0a785843b6b77p+4,   0x1.ffffe8p-1, INEXACT) // -3.506720600697531775580273460946e+00
T(RZ,   -0x1.c0dc387c1a49bp+1,   -0x1.0a785843b6b77p+4,   0x1.ffffe8p-1, INEXACT) // -3.506720600697531775580273460946e+00
T(RD,   -0x1.0a1a76386f9fbp-1,   -0x1.163f0d9cea63cp-1,  -0x1.a963fp-23, INEXACT) // -5.197331375018728882864138540754e-01
T(RU,   -0x1.0a1a76386f9fbp-1,   -0x1.163f0d9cea63bp-1,   0x1.fffffap-1, INEXACT) // -5.197331375018728882864138540754e-01
T(RZ,   -0x1.0a1a76386f9fbp-1,   -0x1.163f0d9cea63bp-1,   0x1.fffffap-1, INEXACT) // -5.197331375018728882864138540754e-01
T(RD,    0x1.368702053ed81p+1,    0x1.6733f3f0c30d8p+2,  -0x1.fffff4p-1, INEXACT) // 2.425995113908073097519491057028e+00
T(RU,    0x1.368702053ed81p+1,    0x1.6733f3f0c30d9p+2,  0x1.6422dap-22, INEXACT) // 2.425995113908073097519491057028e+00
T(RZ,    0x1.368702053ed81p+1,    0x1.6733f3f0c30d8p+2,  -0x1.fffff4p-1, INEXACT) // 2.425995113908073097519491057028e+00
T(RN,   -0x1.748ba579befecp+2,   -0x1.5150690188b86p+7,  -0x1.fffffcp-2, INEXACT) // -5.821023339169169474871523561887e+00
T(RN,   -0x1.fe2ea29c6e454p+1,    -0x1.ae7a2f0e8972p+4,   0x1.ffffe2p-2, INEXACT) // -3.985798193342398931804382300470e+00
T(RN,   -0x1.6893d7e8cba5cp+8, -0x1.26c2359664a3ep+519,   0x1.ffffc8p-2, INEXACT) // -3.605775132653413947991793975234e+02
T(RN,   -0x1.05f8e1b0d5999p+1,   -0x1.e7386244bcda8p+1,  -0x1.ffffcep-2, INEXACT) // -2.046657763810071362087228408200e+00
T(RD,   -0x1.486283565844ep+1,   -0x1.9dc588c064ba8p+2,   -0x1.ffffep-1, INEXACT) // -2.565506379280612314630616310751e+00
T(RU,   -0x1.486283565844ep+1,   -0x1.9dc588c064ba7p+2,  0x1.fcbf6cp-21, INEXACT) // -2.565506379280612314630616310751e+00
T(RZ,   -0x1.486283565844ep+1,   -0x1.9dc588c064ba7p+2,  0x1.fcbf6cp-21, INEXACT) // -2.565506379280612314630616310751e+00
T(RN,    0x1.68ed5e685a497p+3,   0x1.352427d4da715p+15,  -0x1.ffffd4p-2, INEXACT) // 1.127897568112739001833233487559e+01
T(RD,   -0x1.8698910e10fc7p+5,  -0x1.5b040980ea402p+69, -0x1.643f78p-21, INEXACT) // -4.882449542035424627783868345432e+01
T(RU,   -0x1.8698910e10fc7p+5,  -0x1.5b040980ea401p+69,   0x1.ffffeap-1, INEXACT) // -4.882449542035424627783868345432e+01
T(RZ,   -0x1.8698910e10fc7p+5,  -0x1.5b040980ea401p+69,   0x1.ffffeap-1, INEXACT) // -4.882449542035424627783868345432e+01
T(RD,    0x1.6312209325fbap+4,   0x1.02e32d6ac8038p+31, -0x1.2681d8p-21, INEXACT) // 2.219192559699852296262179152109e+01
T(RU,    0x1.6312209325fbap+4,   0x1.02e32d6ac8039p+31,   0x1.ffffeep-1, INEXACT) // 2.219192559699852296262179152109e+01
T(RZ,    0x1.6312209325fbap+4,   0x1.02e32d6ac8038p+31, -0x1.2681d8p-21, INEXACT) // 2.219192559699852296262179152109e+01
T(RN,   -0x1.6cd2394ddb904p+7, -0x1.1e97c1ee222cap+262,   0x1.ffffe4p-2, INEXACT) // -1.824105934458276578880031593144e+02
T(RD,    0x1.00f572f596e5ap-8,    0x1.00f59e1b7307cp-8, -0x1.b1a3a8p-26, INEXACT) // 3.920879904025642917475558135720e-03
T(RU,    0x1.00f572f596e5ap-8,    0x1.00f59e1b7307dp-8,          0x1p+0, INEXACT) // 3.920879904025642917475558135720e-03
T(RZ,    0x1.00f572f596e5ap-8,    0x1.00f59e1b7307cp-8, -0x1.b1a3a8p-26, INEXACT) // 3.920879904025642917475558135720e-03
T(RD,   -0x1.7a4d0847f7fedp+5,  -0x1.2a80f825f609ep+67, -0x1.32531ep-24, INEXACT) // -4.728761345124789983174196095206e+01
T(RU,   -0x1.7a4d0847f7fedp+5,  -0x1.2a80f825f609dp+67,   0x1.fffffep-1, INEXACT) // -4.728761345124789983174196095206e+01
T(RZ,   -0x1.7a4d0847f7fedp+5,  -0x1.2a80f825f609dp+67,   0x1.fffffep-1, INEXACT) // -4.728761345124789983174196095206e+01
T(RN,    0x1.45225e89def6dp+7,  0x1.72dff72c17558p+233,   0x1.ffffe2p-2, INEXACT) // 1.625671275219605433903780067340e+02
T(RD,    0x1.67ef7c6f01f95p+1,    0x1.09540d290852cp+3, -0x1.87d21ap-22, INEXACT) // 2.811996034815772649295695373439e+00
T(RU,    0x1.67ef7c6f01f95p+1,    0x1.09540d290852dp+3,   0x1.fffff4p-1, INEXACT) // 2.811996034815772649295695373439e+00
T(RZ,    0x1.67ef7c6f01f95p+1,    0x1.09540d290852cp+3, -0x1.87d21ap-22, INEXACT) // 2.811996034815772649295695373439e+00
T(RD,   -0x1.23c5d39dc38a3p-5,   -0x1.23d59eae0a6e2p-5, -0x1.759c0ep-21, INEXACT) // -3.561679202367542401708178090303e-02
T(RU,   -0x1.23c5d39dc38a3p-5,   -0x1.23d59eae0a6e1p-5,   0x1.ffffe8p-1, INEXACT) // -3.561679202367542401708178090303e-02
T(RZ,   -0x1.23c5d39dc38a3p-5,   -0x1.23d59eae0a6e1p-5,   0x1.ffffe8p-1, INEXACT) // -3.561679202367542401708178090303e-02
T(RD,   -0x1.9d1973057fa7bp-4,   -0x1.9dccd21f88308p-4, -0x1.4576cap-21, INEXACT) // -1.008543484713104038119624306091e-01
T(RU,   -0x1.9d1973057fa7bp-4,   -0x1.9dccd21f88307p-4,   0x1.ffffecp-1, INEXACT) // -1.008543484713104038119624306091e-01
T(RZ,   -0x1.9d1973057fa7bp-4,   -0x1.9dccd21f88307p-4,   0x1.ffffecp-1, INEXACT) // -1.008543484713104038119624306091e-01
T(RD,    0x1.adf6e5140de3cp+5,   0x1.73d0da7b0485ep+76,  -0x1.fffff4p-1, INEXACT) // 5.374555411975276797420519869775e+01
T(RU,    0x1.adf6e5140de3cp+5,   0x1.73d0da7b0485fp+76,  0x1.6420dap-22, INEXACT) // 5.374555411975276797420519869775e+01
T(RZ,    0x1.adf6e5140de3cp+5,   0x1.73d0da7b0485ep+76,  -0x1.fffff4p-1, INEXACT) // 5.374555411975276797420519869775e+01
T(RN,    0x1.724fe9904d338p-7,    0x1.7251ee2424f12p-7,  -0x1.ffffeep-2, INEXACT) // 1.130103020168747585127988486420e-02
