//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// WorkspaceManagedSQLServerEncryptionProtectorServer is a fake server for instances of the armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClient type.
type WorkspaceManagedSQLServerEncryptionProtectorServer struct {
	// BeginCreateOrUpdate is the fake for method WorkspaceManagedSQLServerEncryptionProtectorClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, encryptionProtectorName armsynapse.EncryptionProtectorName, parameters armsynapse.EncryptionProtector, options *armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WorkspaceManagedSQLServerEncryptionProtectorClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, encryptionProtectorName armsynapse.EncryptionProtectorName, options *armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientGetOptions) (resp azfake.Responder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WorkspaceManagedSQLServerEncryptionProtectorClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, workspaceName string, options *armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientListOptions) (resp azfake.PagerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientListResponse])

	// BeginRevalidate is the fake for method WorkspaceManagedSQLServerEncryptionProtectorClient.BeginRevalidate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRevalidate func(ctx context.Context, resourceGroupName string, workspaceName string, encryptionProtectorName armsynapse.EncryptionProtectorName, options *armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientBeginRevalidateOptions) (resp azfake.PollerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientRevalidateResponse], errResp azfake.ErrorResponder)
}

// NewWorkspaceManagedSQLServerEncryptionProtectorServerTransport creates a new instance of WorkspaceManagedSQLServerEncryptionProtectorServerTransport with the provided implementation.
// The returned WorkspaceManagedSQLServerEncryptionProtectorServerTransport instance is connected to an instance of armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkspaceManagedSQLServerEncryptionProtectorServerTransport(srv *WorkspaceManagedSQLServerEncryptionProtectorServer) *WorkspaceManagedSQLServerEncryptionProtectorServerTransport {
	return &WorkspaceManagedSQLServerEncryptionProtectorServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientCreateOrUpdateResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientListResponse]](),
		beginRevalidate:     newTracker[azfake.PollerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientRevalidateResponse]](),
	}
}

// WorkspaceManagedSQLServerEncryptionProtectorServerTransport connects instances of armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClient to instances of WorkspaceManagedSQLServerEncryptionProtectorServer.
// Don't use this type directly, use NewWorkspaceManagedSQLServerEncryptionProtectorServerTransport instead.
type WorkspaceManagedSQLServerEncryptionProtectorServerTransport struct {
	srv                 *WorkspaceManagedSQLServerEncryptionProtectorServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientCreateOrUpdateResponse]]
	newListPager        *tracker[azfake.PagerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientListResponse]]
	beginRevalidate     *tracker[azfake.PollerResponder[armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientRevalidateResponse]]
}

// Do implements the policy.Transporter interface for WorkspaceManagedSQLServerEncryptionProtectorServerTransport.
func (w *WorkspaceManagedSQLServerEncryptionProtectorServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkspaceManagedSQLServerEncryptionProtectorClient.BeginCreateOrUpdate":
		resp, err = w.dispatchBeginCreateOrUpdate(req)
	case "WorkspaceManagedSQLServerEncryptionProtectorClient.Get":
		resp, err = w.dispatchGet(req)
	case "WorkspaceManagedSQLServerEncryptionProtectorClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	case "WorkspaceManagedSQLServerEncryptionProtectorClient.BeginRevalidate":
		resp, err = w.dispatchBeginRevalidate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkspaceManagedSQLServerEncryptionProtectorServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := w.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector/(?P<encryptionProtectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.EncryptionProtector](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		encryptionProtectorNameParam, err := parseWithCast(matches[regex.SubexpIndex("encryptionProtectorName")], func(v string) (armsynapse.EncryptionProtectorName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsynapse.EncryptionProtectorName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, encryptionProtectorNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		w.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		w.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (w *WorkspaceManagedSQLServerEncryptionProtectorServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector/(?P<encryptionProtectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	encryptionProtectorNameParam, err := parseWithCast(matches[regex.SubexpIndex("encryptionProtectorName")], func(v string) (armsynapse.EncryptionProtectorName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.EncryptionProtectorName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, encryptionProtectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EncryptionProtector, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceManagedSQLServerEncryptionProtectorServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPager(resourceGroupNameParam, workspaceNameParam, nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsynapse.WorkspaceManagedSQLServerEncryptionProtectorClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}

func (w *WorkspaceManagedSQLServerEncryptionProtectorServerTransport) dispatchBeginRevalidate(req *http.Request) (*http.Response, error) {
	if w.srv.BeginRevalidate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRevalidate not implemented")}
	}
	beginRevalidate := w.beginRevalidate.get(req)
	if beginRevalidate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector/(?P<encryptionProtectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revalidate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		encryptionProtectorNameParam, err := parseWithCast(matches[regex.SubexpIndex("encryptionProtectorName")], func(v string) (armsynapse.EncryptionProtectorName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsynapse.EncryptionProtectorName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginRevalidate(req.Context(), resourceGroupNameParam, workspaceNameParam, encryptionProtectorNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRevalidate = &respr
		w.beginRevalidate.add(req, beginRevalidate)
	}

	resp, err := server.PollerResponderNext(beginRevalidate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginRevalidate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRevalidate) {
		w.beginRevalidate.remove(req)
	}

	return resp, nil
}
