//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/marketplace/armmarketplace"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// PrivateStoreCollectionServer is a fake server for instances of the armmarketplace.PrivateStoreCollectionClient type.
type PrivateStoreCollectionServer struct {
	// CreateOrUpdate is the fake for method PrivateStoreCollectionClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, privateStoreID string, collectionID string, options *armmarketplace.PrivateStoreCollectionClientCreateOrUpdateOptions) (resp azfake.Responder[armmarketplace.PrivateStoreCollectionClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PrivateStoreCollectionClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, privateStoreID string, collectionID string, options *armmarketplace.PrivateStoreCollectionClientDeleteOptions) (resp azfake.Responder[armmarketplace.PrivateStoreCollectionClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PrivateStoreCollectionClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, privateStoreID string, collectionID string, options *armmarketplace.PrivateStoreCollectionClientGetOptions) (resp azfake.Responder[armmarketplace.PrivateStoreCollectionClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method PrivateStoreCollectionClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreCollectionClientListOptions) (resp azfake.Responder[armmarketplace.PrivateStoreCollectionClientListResponse], errResp azfake.ErrorResponder)

	// Post is the fake for method PrivateStoreCollectionClient.Post
	// HTTP status codes to indicate success: http.StatusOK
	Post func(ctx context.Context, privateStoreID string, collectionID string, options *armmarketplace.PrivateStoreCollectionClientPostOptions) (resp azfake.Responder[armmarketplace.PrivateStoreCollectionClientPostResponse], errResp azfake.ErrorResponder)

	// TransferOffers is the fake for method PrivateStoreCollectionClient.TransferOffers
	// HTTP status codes to indicate success: http.StatusOK
	TransferOffers func(ctx context.Context, privateStoreID string, collectionID string, options *armmarketplace.PrivateStoreCollectionClientTransferOffersOptions) (resp azfake.Responder[armmarketplace.PrivateStoreCollectionClientTransferOffersResponse], errResp azfake.ErrorResponder)
}

// NewPrivateStoreCollectionServerTransport creates a new instance of PrivateStoreCollectionServerTransport with the provided implementation.
// The returned PrivateStoreCollectionServerTransport instance is connected to an instance of armmarketplace.PrivateStoreCollectionClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateStoreCollectionServerTransport(srv *PrivateStoreCollectionServer) *PrivateStoreCollectionServerTransport {
	return &PrivateStoreCollectionServerTransport{srv: srv}
}

// PrivateStoreCollectionServerTransport connects instances of armmarketplace.PrivateStoreCollectionClient to instances of PrivateStoreCollectionServer.
// Don't use this type directly, use NewPrivateStoreCollectionServerTransport instead.
type PrivateStoreCollectionServerTransport struct {
	srv *PrivateStoreCollectionServer
}

// Do implements the policy.Transporter interface for PrivateStoreCollectionServerTransport.
func (p *PrivateStoreCollectionServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateStoreCollectionClient.CreateOrUpdate":
		resp, err = p.dispatchCreateOrUpdate(req)
	case "PrivateStoreCollectionClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PrivateStoreCollectionClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrivateStoreCollectionClient.List":
		resp, err = p.dispatchList(req)
	case "PrivateStoreCollectionClient.Post":
		resp, err = p.dispatchPost(req)
	case "PrivateStoreCollectionClient.TransferOffers":
		resp, err = p.dispatchTransferOffers(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateStoreCollectionServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.Collection](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	collectionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreCollectionClientCreateOrUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreCollectionClientCreateOrUpdateOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.CreateOrUpdate(req.Context(), privateStoreIDParam, collectionIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Collection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreCollectionServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	collectionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), privateStoreIDParam, collectionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreCollectionServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	collectionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), privateStoreIDParam, collectionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Collection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreCollectionServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if p.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.List(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CollectionsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreCollectionServerTransport) dispatchPost(req *http.Request) (*http.Response, error) {
	if p.srv.Post == nil {
		return nil, &nonRetriableError{errors.New("fake for method Post not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.Operation](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	collectionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreCollectionClientPostOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreCollectionClientPostOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.Post(req.Context(), privateStoreIDParam, collectionIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreCollectionServerTransport) dispatchTransferOffers(req *http.Request) (*http.Response, error) {
	if p.srv.TransferOffers == nil {
		return nil, &nonRetriableError{errors.New("fake for method TransferOffers not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transferOffers`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.TransferOffersProperties](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	collectionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreCollectionClientTransferOffersOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreCollectionClientTransferOffersOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.TransferOffers(req.Context(), privateStoreIDParam, collectionIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TransferOffersResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
