﻿using ClassLibrary1;
using ClassLibrary2.Interfaces;
using ClassLibrary3.Interfaces;

namespace ClassLibrary2
{
    public class WeatherForecastService: IWeatherForecastService
    {
        private readonly IWeatherForecastProvider _provider;

        public WeatherForecastService(IWeatherForecastProvider provider)
        {
            _provider = provider;
        }

        public IEnumerable<WeatherForecast> Get()
        {
            return _provider.Get().Select((dto) => new WeatherForecast
            {
                Date = dto.Date, 
                Summary = SummaryService.Get(dto.SummaryId), 
                TemperatureC = dto.TemperatureInCelsius
            });
        }

    }
}