% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{parallel_psis_list}
\alias{parallel_psis_list}
\alias{parallel_importance_sampling_list}
\title{Parallel psis list computations}
\usage{
parallel_psis_list(
  N,
  .loo_i,
  .llfun,
  data,
  draws,
  r_eff,
  save_psis,
  cores,
  ...
)

parallel_importance_sampling_list(
  N,
  .loo_i,
  .llfun,
  data,
  draws,
  r_eff,
  save_psis,
  cores,
  method,
  ...
)
}
\arguments{
\item{N}{The total number of observations (i.e. \code{nrow(data)}).}

\item{.loo_i}{The function used to compute individual loo contributions.}

\item{.llfun}{See \code{llfun} in \code{\link[=loo.function]{loo.function()}}.}

\item{data, draws, ...}{For the \code{loo.function()} method and the \code{loo_i()}
function, these are the data, posterior draws, and other arguments to pass
to the log-likelihood function. See the \strong{Methods (by class)} section
below for details on how to specify these arguments.}

\item{r_eff}{Vector of relative effective sample size estimates for the
likelihood (\code{exp(log_lik)}) of each observation. This is related to
the relative efficiency of estimating the normalizing term in
self-normalized importance sampling when using posterior draws obtained
with MCMC. If MCMC draws are used and \code{r_eff} is not provided then
the reported PSIS effective sample sizes and Monte Carlo error estimates
can be over-optimistic. If the posterior draws are (near) independent then
\code{r_eff=1} can be used. \code{r_eff} has to be a scalar (same value is used
for all observations) or a vector with length equal to the number of
observations. The default value is 1. See the \code{\link[=relative_eff]{relative_eff()}} helper
functions for help computing \code{r_eff}.}

\item{save_psis}{Should the \code{psis} object created internally by \code{loo()} be
saved in the returned object? The \code{loo()} function calls \code{\link[=psis]{psis()}}
internally but by default discards the (potentially large) \code{psis} object
after using it to compute the LOO-CV summaries. Setting \code{save_psis=TRUE}
will add a \code{psis_object} component to the list returned by \code{loo}.
This is useful if you plan to use the \code{\link[=E_loo]{E_loo()}} function to compute
weighted expectations after running \code{loo}. Several functions in the
\pkg{bayesplot} package also accept \code{psis} objects.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}

\item{method}{See \code{is_method} for \code{\link[=loo]{loo()}}}
}
\description{
Parallel psis list computations
}
\details{
Refactored function to handle parallel computations
for psis_list
}
\keyword{internal}
