//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armtestbase.ClientFactory type.
type ServerFactory struct {
	AccountsServer          AccountsServer
	AnalysisResultsServer   AnalysisResultsServer
	AvailableOSServer       AvailableOSServer
	CustomerEventsServer    CustomerEventsServer
	EmailEventsServer       EmailEventsServer
	FavoriteProcessesServer FavoriteProcessesServer
	FlightingRingsServer    FlightingRingsServer
	OSUpdatesServer         OSUpdatesServer
	OperationsServer        OperationsServer
	PackagesServer          PackagesServer
	SKUsServer              SKUsServer
	TestResultsServer       TestResultsServer
	TestSummariesServer     TestSummariesServer
	TestTypesServer         TestTypesServer
	UsageServer             UsageServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armtestbase.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armtestbase.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                       *ServerFactory
	trMu                      sync.Mutex
	trAccountsServer          *AccountsServerTransport
	trAnalysisResultsServer   *AnalysisResultsServerTransport
	trAvailableOSServer       *AvailableOSServerTransport
	trCustomerEventsServer    *CustomerEventsServerTransport
	trEmailEventsServer       *EmailEventsServerTransport
	trFavoriteProcessesServer *FavoriteProcessesServerTransport
	trFlightingRingsServer    *FlightingRingsServerTransport
	trOSUpdatesServer         *OSUpdatesServerTransport
	trOperationsServer        *OperationsServerTransport
	trPackagesServer          *PackagesServerTransport
	trSKUsServer              *SKUsServerTransport
	trTestResultsServer       *TestResultsServerTransport
	trTestSummariesServer     *TestSummariesServerTransport
	trTestTypesServer         *TestTypesServerTransport
	trUsageServer             *UsageServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccountsClient":
		initServer(s, &s.trAccountsServer, func() *AccountsServerTransport { return NewAccountsServerTransport(&s.srv.AccountsServer) })
		resp, err = s.trAccountsServer.Do(req)
	case "AnalysisResultsClient":
		initServer(s, &s.trAnalysisResultsServer, func() *AnalysisResultsServerTransport {
			return NewAnalysisResultsServerTransport(&s.srv.AnalysisResultsServer)
		})
		resp, err = s.trAnalysisResultsServer.Do(req)
	case "AvailableOSClient":
		initServer(s, &s.trAvailableOSServer, func() *AvailableOSServerTransport { return NewAvailableOSServerTransport(&s.srv.AvailableOSServer) })
		resp, err = s.trAvailableOSServer.Do(req)
	case "CustomerEventsClient":
		initServer(s, &s.trCustomerEventsServer, func() *CustomerEventsServerTransport {
			return NewCustomerEventsServerTransport(&s.srv.CustomerEventsServer)
		})
		resp, err = s.trCustomerEventsServer.Do(req)
	case "EmailEventsClient":
		initServer(s, &s.trEmailEventsServer, func() *EmailEventsServerTransport { return NewEmailEventsServerTransport(&s.srv.EmailEventsServer) })
		resp, err = s.trEmailEventsServer.Do(req)
	case "FavoriteProcessesClient":
		initServer(s, &s.trFavoriteProcessesServer, func() *FavoriteProcessesServerTransport {
			return NewFavoriteProcessesServerTransport(&s.srv.FavoriteProcessesServer)
		})
		resp, err = s.trFavoriteProcessesServer.Do(req)
	case "FlightingRingsClient":
		initServer(s, &s.trFlightingRingsServer, func() *FlightingRingsServerTransport {
			return NewFlightingRingsServerTransport(&s.srv.FlightingRingsServer)
		})
		resp, err = s.trFlightingRingsServer.Do(req)
	case "OSUpdatesClient":
		initServer(s, &s.trOSUpdatesServer, func() *OSUpdatesServerTransport { return NewOSUpdatesServerTransport(&s.srv.OSUpdatesServer) })
		resp, err = s.trOSUpdatesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PackagesClient":
		initServer(s, &s.trPackagesServer, func() *PackagesServerTransport { return NewPackagesServerTransport(&s.srv.PackagesServer) })
		resp, err = s.trPackagesServer.Do(req)
	case "SKUsClient":
		initServer(s, &s.trSKUsServer, func() *SKUsServerTransport { return NewSKUsServerTransport(&s.srv.SKUsServer) })
		resp, err = s.trSKUsServer.Do(req)
	case "TestResultsClient":
		initServer(s, &s.trTestResultsServer, func() *TestResultsServerTransport { return NewTestResultsServerTransport(&s.srv.TestResultsServer) })
		resp, err = s.trTestResultsServer.Do(req)
	case "TestSummariesClient":
		initServer(s, &s.trTestSummariesServer, func() *TestSummariesServerTransport {
			return NewTestSummariesServerTransport(&s.srv.TestSummariesServer)
		})
		resp, err = s.trTestSummariesServer.Do(req)
	case "TestTypesClient":
		initServer(s, &s.trTestTypesServer, func() *TestTypesServerTransport { return NewTestTypesServerTransport(&s.srv.TestTypesServer) })
		resp, err = s.trTestTypesServer.Do(req)
	case "UsageClient":
		initServer(s, &s.trUsageServer, func() *UsageServerTransport { return NewUsageServerTransport(&s.srv.UsageServer) })
		resp, err = s.trUsageServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
