//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorsimple8000series_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersList.json
func ExampleManagersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagerList = armstorsimple8000series.ManagerList{
		// 	Value: []*armstorsimple8000series.Manager{
		// 		{
		// 			Name: to.Ptr("Manager1"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroup1/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"datetime'2017-06-05T09%3A36%3A00.8822928Z'\""),
		// 			Properties: &armstorsimple8000series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple8000series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ManagerForSDKTest"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"datetime'2017-06-05T09%3A36%3A00.8822928Z'\""),
		// 			Properties: &armstorsimple8000series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple8000series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ManagerForSDKTest1"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest1"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"datetime'2017-06-14T11%3A27%3A23.8667962Z'\""),
		// 			Properties: &armstorsimple8000series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple8000series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ManagerForSDKTest2"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest2"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"TagName": to.Ptr("ForSDKTest"),
		// 			},
		// 			Etag: to.Ptr("W/\"datetime'2017-06-18T16%3A13%3A43.8476579Z'\""),
		// 			Properties: &armstorsimple8000series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple8000series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersListByResourceGroup.json
func ExampleManagersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListByResourceGroupPager("ResourceGroupForSDKTest", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagerList = armstorsimple8000series.ManagerList{
		// 	Value: []*armstorsimple8000series.Manager{
		// 		{
		// 			Name: to.Ptr("ManagerForSDKTest"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"datetime'2017-06-05T09%3A36%3A00.8822928Z'\""),
		// 			Properties: &armstorsimple8000series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple8000series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ManagerForSDKTest1"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest1"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"datetime'2017-06-14T11%3A27%3A23.8667962Z'\""),
		// 			Properties: &armstorsimple8000series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple8000series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersGet.json
func ExampleManagersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().Get(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Manager = armstorsimple8000series.Manager{
	// 	Name: to.Ptr("ManagerForSDKTest2"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest2"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"TagName": to.Ptr("ForSDKTest"),
	// 	},
	// 	Etag: to.Ptr("W/\"datetime'2017-06-18T16%3A15%3A11.7946224Z'\""),
	// 	Properties: &armstorsimple8000series.ManagerProperties{
	// 		CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
	// 			Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstorsimple8000series.ManagerSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersCreateOrUpdate.json
func ExampleManagersClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().CreateOrUpdate(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", armstorsimple8000series.Manager{
		Location: to.Ptr("westus"),
		Properties: &armstorsimple8000series.ManagerProperties{
			CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
				Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
			},
			SKU: &armstorsimple8000series.ManagerSKU{
				Name: to.Ptr("Standard"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Manager = armstorsimple8000series.Manager{
	// 	Name: to.Ptr("ManagerForSDKTest2"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest2"),
	// 	Location: to.Ptr("westus"),
	// 	Etag: to.Ptr("W/\"datetime'2017-06-19T16%3A13%3A18.5925197Z'\""),
	// 	Properties: &armstorsimple8000series.ManagerProperties{
	// 		CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
	// 			Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstorsimple8000series.ManagerSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersDelete.json
func ExampleManagersClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewManagersClient().Delete(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersUpdate.json
func ExampleManagersClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().Update(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", armstorsimple8000series.ManagerPatch{
		Tags: map[string]*string{
			"TagName": to.Ptr("ForSDKTest"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Manager = armstorsimple8000series.Manager{
	// 	Name: to.Ptr("ManagerForSDKTest2"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest2"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"TagName": to.Ptr("ForSDKTest"),
	// 	},
	// 	Etag: to.Ptr("W/\"datetime'2017-06-18T16%3A13%3A43.8476579Z'\""),
	// 	Properties: &armstorsimple8000series.ManagerProperties{
	// 		CisIntrinsicSettings: &armstorsimple8000series.ManagerIntrinsicSettings{
	// 			Type: to.Ptr(armstorsimple8000series.ManagerTypeGardaV1),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstorsimple8000series.ManagerSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersGetDevicePublicEncryptionKey.json
func ExampleManagersClient_GetDevicePublicEncryptionKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetDevicePublicEncryptionKey(ctx, "sca01forsdktest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PublicKey = armstorsimple8000series.PublicKey{
	// 	Key: to.Ptr("MIIDhjCCAm6gAwIBAgIQenen3LlBm4pFTfxko4pMMjANBgkqhkiG9w0BAQUFADB/MX0wewYDVQQDHnQAQwBCAF8AZgBhAGMAOAA2ADEAOAA3AC0AZgAzADYANgAtADQAYgA5ADUALQBiADQAMgBmAC0AZgBmADEAMAA3ADEANQAzAGQAOAA1AGUAXwA2ADMANgAzADMANwAzADcAMgAyADQANQAyADYANwAxADgAMDAeFw0xNzA2MTcwMDAwMDBaFw0yMDA2MjIxNDA3MDRaMH8xfTB7BgNVBAMedABDAEIAXwBmAGEAYwA4ADYAMQA4ADcALQBmADMANgA2AC0ANABiADkANQAtAGIANAAyAGYALQBmAGYAMQAwADcAMQA1ADMAZAA4ADUAZQBfADYAMwA2ADMAMwA3ADMANwAyADIANAA1ADIANgA3ADEAOAAwMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAz6r59tE8cxAf5g4cCs/JyaLKKpLf+5OEpSAsPnxHR5FBOaebsOV1raGDOmqIrc1dSOXArAyY6NcqizKkdslA0aNftKjya8Kks618Jf61mQVNHhq5fEyqTuVNSe3FZn1I2Xs2yS2NEt3YQl+GwisLgoT5ecC27NFZMEgjw2EOJwD9fjZG21CoCBCErEf+5j5HJkXk1jrn/o4wI7OnCGswPhlbGgDzl8eKcfSvMKpib50faCWdsvglC097CGtSmgu0a73IwGnac1eZCAnoVQmjaIFsdMeVNOqFot23tj1HT+Dwb9cECN8wKT7bkHCGSS84+veGiR0XEh3Op1iZ46zsIQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQAfgsz7cH8NsiR5Ub0Pgx4T0cm8saMgJIfXZdMkCPTysdxU60EgmoDC/3KypFHAhhsBaFAvFrlXEybM4n4WLiDPeNM1Dr4xq56zzBhO0gO84Vp2PXk2VdybLfiobDyMb8cgAPXXcxzzb3jdRb1/bobiUuWBJvWSRHv5fON00c+BzloUzWJHY2BezNHBCof5awoMd+hzSfxX5WRFNW29rKgWW0h8A1cYNhaWGRxSA+U7YciYRyMDew8Nae1WCxVj9v/qsEXGd+jFDOckdJd5ySgXOQCPyG8j9/QM+Lsrsx29JnGsiiddaRfCtI4K8QdjkOjh0+RXMO3DeWhkFEmoOlNK"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersGetEncryptionSettings.json
func ExampleManagersClient_GetEncryptionSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetEncryptionSettings(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EncryptionSettings = armstorsimple8000series.EncryptionSettings{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/encryptionSettings"),
	// 	ID: to.Ptr("/subscriptions/d3ebfe71-b7a9-4c57-92b9-68a2afde4de5/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/encryptionSettings/default"),
	// 	Kind: to.Ptr("Series8000"),
	// 	Properties: &armstorsimple8000series.EncryptionSettingsProperties{
	// 		EncryptionStatus: to.Ptr(armstorsimple8000series.EncryptionStatusEnabled),
	// 		KeyRolloverStatus: to.Ptr(armstorsimple8000series.KeyRolloverStatusNotRequired),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersGetExtendedInfo.json
func ExampleManagersClient_GetExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetExtendedInfo(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagerExtendedInfo = armstorsimple8000series.ManagerExtendedInfo{
	// 	Name: to.Ptr("vaultExtendedInfo"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest1extendedInformation/vaultExtendedInfo"),
	// 	Etag: to.Ptr("bcb55c1e-29b2-42b3-a507-f2a0cd27a963"),
	// 	Properties: &armstorsimple8000series.ManagerExtendedInfoProperties{
	// 		Algorithm: to.Ptr("None"),
	// 		EncryptionKey: to.Ptr("MIIDQjCCAiqgAwIBAgIQQmzC+SfPepJF20zGMFBbJjANBgkqhkiG9w0BAQUFADBdMVswWQYDVQQDHlIAQwBCAF8AMgA0ADMANQAyADQAMwAzADYANwAzADkAOAA0ADcAMQA5ADEANQBfADYAMwA2ADMAMgAzADQAMgA2ADEAOQAxADMANgAwADgAOAAxMB4XDTE3MDYwMTA3MDAwMFoXDTIwMDYwNjEwNDMzOVowXTFbMFkGA1UEAx5SAEMAQgBfADIANAAzADUAMgA0ADMAMwA2ADcAMwA5ADgANAA3ADEAOQAxADUAXwA2ADMANgAzADIAMwA0ADIANgAxADkAMQAzADYAMAA4ADgAMTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJvO+6ytUY0Z/x2GVE2grF8L7XvuJ63mN3ebHKncQVlJiKjyfuG7iDzQUfW0HZZ/TtgxineJLHPNg67NIxjwaqhr+c0kbR6VUtyShqBxfqFAQt+Lx1bySxZ5S/G/ZSKc++evMwhYMoCkU8k1uQWOcco4N4+7HrB3XPkZee1TckhXnsjS5d9OawNCfVxt9PsCEwhX8Ezj58u1FN21OOosxKdSBTaRI1Hh+kIAP2ZPeldRvgjJ+HVRzR7hqm6OLVg/azaSziGMkP+UmvvwsyG8EI2xfhkF3K11rEFRng0fB06V01LN11hpVEL1uvNbGbfkmlIjEWmiwujiFGMdVK0eYfUCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAcztBrLgiL3fqykBXQ/3GjJXZ1PX7z9CFjoLkHdv6ZG+mkAkAkjaOxYvzCueIhX61u2zOgg9AJYW+J3BKvSGe5W5O7W8OLL0TRCmzSASH4Bap9oZmb6exs8D45aPgGRW/Mmhm2W+jGk9NIg6W8GFPksqP2XY3DlKSfAztzIU86fPRfXlNHknvpp7rt+gv7WjbSt8smSTJ7PJwUh9s/oYL+k5GPtYxHkB8A7YCgVj0rk6v9uHvhmOXm3Cm+1wOJA9ebk0U1CUUJ8maMi89JvFuxhps8kBObnp6M52AzVErMwqn9zH0gbDRlh9fIQPwvXsXm7DosxccD5KuG9/oX4eqfQ=="),
	// 		EncryptionKeyThumbprint: to.Ptr("A872A2DF196AC7682EE24791E7DE2E2A360F5926"),
	// 		IntegrityKey: to.Ptr("x3V1JcHquNW1P87Vgz10Pw=="),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersCreateExtendedInfo.json
func ExampleManagersClient_CreateExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().CreateExtendedInfo(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", armstorsimple8000series.ManagerExtendedInfo{
		Properties: &armstorsimple8000series.ManagerExtendedInfoProperties{
			Algorithm:    to.Ptr("None"),
			IntegrityKey: to.Ptr("BIl+RHqO8PZ6DRvuXTTK7g=="),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagerExtendedInfo = armstorsimple8000series.ManagerExtendedInfo{
	// 	Name: to.Ptr("vaultExtendedInfo"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest2extendedInformation/vaultExtendedInfo"),
	// 	Etag: to.Ptr("674ab9df-af56-4c5c-a5ca-2bddcf1b781a"),
	// 	Properties: &armstorsimple8000series.ManagerExtendedInfoProperties{
	// 		Algorithm: to.Ptr("None"),
	// 		IntegrityKey: to.Ptr("BIl+RHqO8PZ6DRvuXTTK7g=="),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersDeleteExtendedInfo.json
func ExampleManagersClient_DeleteExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewManagersClient().DeleteExtendedInfo(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersUpdateExtendedInfo.json
func ExampleManagersClient_UpdateExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().UpdateExtendedInfo(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", "674ab9df-af56-4c5c-a5ca-2bddcf1b781a", armstorsimple8000series.ManagerExtendedInfo{
		Etag: to.Ptr("674ab9df-af56-4c5c-a5ca-2bddcf1b781a"),
		Properties: &armstorsimple8000series.ManagerExtendedInfoProperties{
			Algorithm:    to.Ptr("SHA256"),
			IntegrityKey: to.Ptr("BIl+RHqO8PZ6DRvuXTTK7g=="),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagerExtendedInfo = armstorsimple8000series.ManagerExtendedInfo{
	// 	Name: to.Ptr("vaultExtendedInfo"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest2extendedInformation/vaultExtendedInfo"),
	// 	Etag: to.Ptr("7d062cd9-c325-422b-8bff-0e702b8659ed"),
	// 	Properties: &armstorsimple8000series.ManagerExtendedInfoProperties{
	// 		Algorithm: to.Ptr("SHA256"),
	// 		IntegrityKey: to.Ptr("BIl+RHqO8PZ6DRvuXTTK7g=="),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersListFeatureSupportStatus.json
func ExampleManagersClient_NewListFeatureSupportStatusPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListFeatureSupportStatusPager("ResourceGroupForSDKTest", "ManagerForSDKTest1", &armstorsimple8000series.ManagersClientListFeatureSupportStatusOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FeatureList = armstorsimple8000series.FeatureList{
		// 	Value: []*armstorsimple8000series.Feature{
		// 		{
		// 			Name: to.Ptr("BandwidthThrottling"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("OtherCloud"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusUnsupportedDeviceVersion),
		// 		},
		// 		{
		// 			Name: to.Ptr("DeviceUpdate"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusNotAvailable),
		// 		},
		// 		{
		// 			Name: to.Ptr("ControllerRestartFeature"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("GetDRTargetDevicesApi"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("Migration"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("Update"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("GetSupportedVirtualApplianceVersionInfoApi"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("LocalOnlyVolume"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("PremiumSVA"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusSupported),
		// 		},
		// 		{
		// 			Name: to.Ptr("VersionBasedARMApiAccess"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusNotAvailable),
		// 		},
		// 		{
		// 			Name: to.Ptr("SubscriptionBasedARMApiAccess"),
		// 			Status: to.Ptr(armstorsimple8000series.FeatureSupportStatusNotAvailable),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersGetActivationKey.json
func ExampleManagersClient_GetActivationKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetActivationKey(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Key = armstorsimple8000series.Key{
	// 	ActivationKey: to.Ptr("<activationKey>"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersGetPublicEncryptionKey.json
func ExampleManagersClient_GetPublicEncryptionKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetPublicEncryptionKey(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SymmetricEncryptedSecret = armstorsimple8000series.SymmetricEncryptedSecret{
	// 	EncryptionAlgorithm: to.Ptr(armstorsimple8000series.EncryptionAlgorithmAES256),
	// 	Value: to.Ptr("EAAAACcRUjoLMPhaI/fH4EFvdYv355vUfR6L+21trxRIl3toWpu91W804sPvAFQbCjwPAdG2epj8GYgXO44DZVHvf8x/X0f5cHhvLlcdx4yo7hdcEqoSpKwKytik8GfDTgsiqcEG4Fod05JF7E9CSAvFGOFf4hFfdQWjeiU3kTP5wCM4lJCCUWqI2uPSc5Izmg+XmumlXACavVKVtRzDEki4cbNCFc0tR1RAdMMDgziQmJFVlKNIvOOUSmurE1a5rXyUP8n3VvuCokIjlSSQSyySOSk/cWicAXjiBVHbJ6pFjJkDFLV/hTi/xdnrywVHJ7fDrdyBtMIRTZU6085lp/kWBkjVt5RNiPy9p/xHjOlGxa6DUSxYmUPZKzQytNQ49uLCVTH/JvUV0tWM6LU9bLvZxOYTJfD8hiHNaHk+XbrsX+AE4XrOj2cN/Ih1tULcX12cS21OLVYadWm9fkvU0U/csDu+r7PuwH/rBO1Bw/vmv2Kochj6h1akedro6R4+0txxu2t3HVh1a9Xc1/2xYNnSv/06/ekxEzxYwe7Sb6yAHZYZ4nCdS1FiGsBJ+2U1iSYgzDUDYcn9vwmFSJMdLlujwp5gNEWR7hZFrnmbPMtq+kBmuWA1mjJDTMZhefsJHLL3sEB1qqHTOaj8yAxM2oWYOvbc6/E/osy+qve0f1HAFWAsmgK2wOZ/yM9myAQDNFmVnxGibjNVb/svTIgfvYfSpDqWOKISDW1T4A8eHUk2Gz/8xnx+dSArjuVuLFk7u96tMbw4glEc74HNahtZbY8cvyFIStLugxrwlYmFlgN86tly9SZicd0x2cbsrIYySX4gvuSsgOwcQigoyVxFojE9u0rJa0gJYcTS4YbBjnd0+HGQJG604TKPb9hMmH7V1FbmH3bJc03PAOfPdNDgjA61uK7PgTEaamdIyoDg/FjBWpFiVJhdIu+m7Mm1gNf9GwXyv9XjQ9P42aAc/vUKzkvJESQ4uqkYFSlYTgyvMUyCpeRI9U2OD3iziNj5/Y1wr4eJ5BLePP6lVTR+UnWDjyu863d7N5grH7sWof1b+TZFb9Il6vMHA3BA9ujiFedQwqUdIdkdpKZuOBhkq+Ij9nMTQtIG1ODEpPetEXxaAoCKCS9DcBdmsN3MLvN46IIWN//vBmkABP3oUwnPoCgyx7P5V4NUpAJbm70mO1Mo6a1JEcFiqXJNZa9BO6v8e+9mRZokpDHOJCIJ0UwLpevpbKvBnLx9mcSNMN9JvcgGQOKvxt2/vBZdOv0DcO0aSYkV+bv+4ZAtLsBKOWeQTJ5CtSPs17m/y5a8+vxirvWxiGuMsNFBLHrD1aSAGBPd/5llsEde/TfIgWs+j8GW9Ep6E64LMjqALF0L5BZOSShleMbb2seTNi+d+0xOg5a2nuSRvPhcxFhRqPykmOQ/wAAMm1fE5K2l+jJfE3gZ5J3CdLXulmZHM1hV0oAGlqutqM6SCW7Czg813162G99tQb2l90MD1G01KkO7ppzn1Hy6MOazanOCzwRH6CMqZw09mEU9JozEKw=="),
	// 	ValueCertificateThumbprint: to.Ptr("D3411C80B443A01C51B8A8295A21EE82535972D0"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersListMetrics.json
func ExampleManagersClient_NewListMetricsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListMetricsPager("ResourceGroupForSDKTest", "ManagerForSDKTest1", "name/value%20eq%20'PrimaryStorageTieredUsed'%20and%20timeGrain%20eq%20'PT1H'%20and%20startTime%20ge%20'2017-06-17T18:30:00Z'%20and%20endTime%20le%20'2017-06-21T18:30:00Z'%20and%20category%20eq%20'CapacityUtilization'", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricList = armstorsimple8000series.MetricList{
		// 	Value: []*armstorsimple8000series.Metrics{
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Tiered Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageTieredUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metrics"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("ManagerForSDKTest1"),
		// 			}},
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-21T18:30:00.000Z"); return t}()),
		// 			PrimaryAggregation: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1"),
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-17T18:30:00.000Z"); return t}()),
		// 			TimeGrain: to.Ptr("01:00:00"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 			Values: []*armstorsimple8000series.MetricData{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersListMetricDefinition.json
func ExampleManagersClient_NewListMetricDefinitionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListMetricDefinitionPager("ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionList = armstorsimple8000series.MetricDefinitionList{
		// 	Value: []*armstorsimple8000series.MetricDefinition{
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Tiered Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageTieredUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("ManagerForSDKTest1"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Locally Pinned Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageLocallyPinnedUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("ManagerForSDKTest1"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Cloud Storage Used"),
		// 				Value: to.Ptr("CloudStorageUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("ManagerForSDKTest1"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/ManagersRegenerateActivationKey.json
func ExampleManagersClient_RegenerateActivationKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().RegenerateActivationKey(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Key = armstorsimple8000series.Key{
	// 	ActivationKey: to.Ptr("<activationKey>"),
	// }
}
