//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservicesdatareplication/armrecoveryservicesdatareplication"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// AzureSiteRecoveryManagementServiceAPIServer is a fake server for instances of the armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClient type.
type AzureSiteRecoveryManagementServiceAPIServer struct {
	// CheckNameAvailability is the fake for method AzureSiteRecoveryManagementServiceAPIClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, location string, options *armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientCheckNameAvailabilityOptions) (resp azfake.Responder[armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// DeploymentPreflight is the fake for method AzureSiteRecoveryManagementServiceAPIClient.DeploymentPreflight
	// HTTP status codes to indicate success: http.StatusOK
	DeploymentPreflight func(ctx context.Context, resourceGroupName string, deploymentID string, options *armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientDeploymentPreflightOptions) (resp azfake.Responder[armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientDeploymentPreflightResponse], errResp azfake.ErrorResponder)
}

// NewAzureSiteRecoveryManagementServiceAPIServerTransport creates a new instance of AzureSiteRecoveryManagementServiceAPIServerTransport with the provided implementation.
// The returned AzureSiteRecoveryManagementServiceAPIServerTransport instance is connected to an instance of armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAzureSiteRecoveryManagementServiceAPIServerTransport(srv *AzureSiteRecoveryManagementServiceAPIServer) *AzureSiteRecoveryManagementServiceAPIServerTransport {
	return &AzureSiteRecoveryManagementServiceAPIServerTransport{srv: srv}
}

// AzureSiteRecoveryManagementServiceAPIServerTransport connects instances of armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClient to instances of AzureSiteRecoveryManagementServiceAPIServer.
// Don't use this type directly, use NewAzureSiteRecoveryManagementServiceAPIServerTransport instead.
type AzureSiteRecoveryManagementServiceAPIServerTransport struct {
	srv *AzureSiteRecoveryManagementServiceAPIServer
}

// Do implements the policy.Transporter interface for AzureSiteRecoveryManagementServiceAPIServerTransport.
func (a *AzureSiteRecoveryManagementServiceAPIServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AzureSiteRecoveryManagementServiceAPIClient.CheckNameAvailability":
		resp, err = a.dispatchCheckNameAvailability(req)
	case "AzureSiteRecoveryManagementServiceAPIClient.DeploymentPreflight":
		resp, err = a.dispatchDeploymentPreflight(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AzureSiteRecoveryManagementServiceAPIServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if a.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataReplication/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesdatareplication.CheckNameAvailabilityModel](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	var options *armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientCheckNameAvailabilityOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientCheckNameAvailabilityOptions{
			Body: &body,
		}
	}
	respr, errRespr := a.srv.CheckNameAvailability(req.Context(), locationParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResponseModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AzureSiteRecoveryManagementServiceAPIServerTransport) dispatchDeploymentPreflight(req *http.Request) (*http.Response, error) {
	if a.srv.DeploymentPreflight == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeploymentPreflight not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataReplication/deployments/(?P<deploymentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preflight`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesdatareplication.DeploymentPreflightModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deploymentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentId")])
	if err != nil {
		return nil, err
	}
	var options *armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientDeploymentPreflightOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armrecoveryservicesdatareplication.AzureSiteRecoveryManagementServiceAPIClientDeploymentPreflightOptions{
			Body: &body,
		}
	}
	respr, errRespr := a.srv.DeploymentPreflight(req.Context(), resourceGroupNameParam, deploymentIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentPreflightModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
