//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// EventSubscriptionsServer is a fake server for instances of the armeventgrid.EventSubscriptionsClient type.
type EventSubscriptionsServer struct {
	// BeginCreateOrUpdate is the fake for method EventSubscriptionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionInfo armeventgrid.EventSubscription, options *armeventgrid.EventSubscriptionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armeventgrid.EventSubscriptionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method EventSubscriptionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, scope string, eventSubscriptionName string, options *armeventgrid.EventSubscriptionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armeventgrid.EventSubscriptionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method EventSubscriptionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, eventSubscriptionName string, options *armeventgrid.EventSubscriptionsClientGetOptions) (resp azfake.Responder[armeventgrid.EventSubscriptionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetDeliveryAttributes is the fake for method EventSubscriptionsClient.GetDeliveryAttributes
	// HTTP status codes to indicate success: http.StatusOK
	GetDeliveryAttributes func(ctx context.Context, scope string, eventSubscriptionName string, options *armeventgrid.EventSubscriptionsClientGetDeliveryAttributesOptions) (resp azfake.Responder[armeventgrid.EventSubscriptionsClientGetDeliveryAttributesResponse], errResp azfake.ErrorResponder)

	// GetFullURL is the fake for method EventSubscriptionsClient.GetFullURL
	// HTTP status codes to indicate success: http.StatusOK
	GetFullURL func(ctx context.Context, scope string, eventSubscriptionName string, options *armeventgrid.EventSubscriptionsClientGetFullURLOptions) (resp azfake.Responder[armeventgrid.EventSubscriptionsClientGetFullURLResponse], errResp azfake.ErrorResponder)

	// NewListByDomainTopicPager is the fake for method EventSubscriptionsClient.NewListByDomainTopicPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDomainTopicPager func(resourceGroupName string, domainName string, topicName string, options *armeventgrid.EventSubscriptionsClientListByDomainTopicOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListByDomainTopicResponse])

	// NewListByResourcePager is the fake for method EventSubscriptionsClient.NewListByResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourcePager func(resourceGroupName string, providerNamespace string, resourceTypeName string, resourceName string, options *armeventgrid.EventSubscriptionsClientListByResourceOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListByResourceResponse])

	// NewListGlobalByResourceGroupPager is the fake for method EventSubscriptionsClient.NewListGlobalByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGlobalByResourceGroupPager func(resourceGroupName string, options *armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupResponse])

	// NewListGlobalByResourceGroupForTopicTypePager is the fake for method EventSubscriptionsClient.NewListGlobalByResourceGroupForTopicTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGlobalByResourceGroupForTopicTypePager func(resourceGroupName string, topicTypeName string, options *armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse])

	// NewListGlobalBySubscriptionPager is the fake for method EventSubscriptionsClient.NewListGlobalBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGlobalBySubscriptionPager func(options *armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionResponse])

	// NewListGlobalBySubscriptionForTopicTypePager is the fake for method EventSubscriptionsClient.NewListGlobalBySubscriptionForTopicTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGlobalBySubscriptionForTopicTypePager func(topicTypeName string, options *armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse])

	// NewListRegionalByResourceGroupPager is the fake for method EventSubscriptionsClient.NewListRegionalByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListRegionalByResourceGroupPager func(resourceGroupName string, location string, options *armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupResponse])

	// NewListRegionalByResourceGroupForTopicTypePager is the fake for method EventSubscriptionsClient.NewListRegionalByResourceGroupForTopicTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListRegionalByResourceGroupForTopicTypePager func(resourceGroupName string, location string, topicTypeName string, options *armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse])

	// NewListRegionalBySubscriptionPager is the fake for method EventSubscriptionsClient.NewListRegionalBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListRegionalBySubscriptionPager func(location string, options *armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionResponse])

	// NewListRegionalBySubscriptionForTopicTypePager is the fake for method EventSubscriptionsClient.NewListRegionalBySubscriptionForTopicTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListRegionalBySubscriptionForTopicTypePager func(location string, topicTypeName string, options *armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions) (resp azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse])

	// BeginUpdate is the fake for method EventSubscriptionsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	BeginUpdate func(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionUpdateParameters armeventgrid.EventSubscriptionUpdateParameters, options *armeventgrid.EventSubscriptionsClientBeginUpdateOptions) (resp azfake.PollerResponder[armeventgrid.EventSubscriptionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewEventSubscriptionsServerTransport creates a new instance of EventSubscriptionsServerTransport with the provided implementation.
// The returned EventSubscriptionsServerTransport instance is connected to an instance of armeventgrid.EventSubscriptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEventSubscriptionsServerTransport(srv *EventSubscriptionsServer) *EventSubscriptionsServerTransport {
	return &EventSubscriptionsServerTransport{
		srv:                               srv,
		beginCreateOrUpdate:               newTracker[azfake.PollerResponder[armeventgrid.EventSubscriptionsClientCreateOrUpdateResponse]](),
		beginDelete:                       newTracker[azfake.PollerResponder[armeventgrid.EventSubscriptionsClientDeleteResponse]](),
		newListByDomainTopicPager:         newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListByDomainTopicResponse]](),
		newListByResourcePager:            newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListByResourceResponse]](),
		newListGlobalByResourceGroupPager: newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupResponse]](),
		newListGlobalByResourceGroupForTopicTypePager:   newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse]](),
		newListGlobalBySubscriptionPager:                newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionResponse]](),
		newListGlobalBySubscriptionForTopicTypePager:    newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse]](),
		newListRegionalByResourceGroupPager:             newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupResponse]](),
		newListRegionalByResourceGroupForTopicTypePager: newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse]](),
		newListRegionalBySubscriptionPager:              newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionResponse]](),
		newListRegionalBySubscriptionForTopicTypePager:  newTracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse]](),
		beginUpdate: newTracker[azfake.PollerResponder[armeventgrid.EventSubscriptionsClientUpdateResponse]](),
	}
}

// EventSubscriptionsServerTransport connects instances of armeventgrid.EventSubscriptionsClient to instances of EventSubscriptionsServer.
// Don't use this type directly, use NewEventSubscriptionsServerTransport instead.
type EventSubscriptionsServerTransport struct {
	srv                                             *EventSubscriptionsServer
	beginCreateOrUpdate                             *tracker[azfake.PollerResponder[armeventgrid.EventSubscriptionsClientCreateOrUpdateResponse]]
	beginDelete                                     *tracker[azfake.PollerResponder[armeventgrid.EventSubscriptionsClientDeleteResponse]]
	newListByDomainTopicPager                       *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListByDomainTopicResponse]]
	newListByResourcePager                          *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListByResourceResponse]]
	newListGlobalByResourceGroupPager               *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupResponse]]
	newListGlobalByResourceGroupForTopicTypePager   *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse]]
	newListGlobalBySubscriptionPager                *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionResponse]]
	newListGlobalBySubscriptionForTopicTypePager    *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse]]
	newListRegionalByResourceGroupPager             *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupResponse]]
	newListRegionalByResourceGroupForTopicTypePager *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse]]
	newListRegionalBySubscriptionPager              *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionResponse]]
	newListRegionalBySubscriptionForTopicTypePager  *tracker[azfake.PagerResponder[armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse]]
	beginUpdate                                     *tracker[azfake.PollerResponder[armeventgrid.EventSubscriptionsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for EventSubscriptionsServerTransport.
func (e *EventSubscriptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EventSubscriptionsClient.BeginCreateOrUpdate":
		resp, err = e.dispatchBeginCreateOrUpdate(req)
	case "EventSubscriptionsClient.BeginDelete":
		resp, err = e.dispatchBeginDelete(req)
	case "EventSubscriptionsClient.Get":
		resp, err = e.dispatchGet(req)
	case "EventSubscriptionsClient.GetDeliveryAttributes":
		resp, err = e.dispatchGetDeliveryAttributes(req)
	case "EventSubscriptionsClient.GetFullURL":
		resp, err = e.dispatchGetFullURL(req)
	case "EventSubscriptionsClient.NewListByDomainTopicPager":
		resp, err = e.dispatchNewListByDomainTopicPager(req)
	case "EventSubscriptionsClient.NewListByResourcePager":
		resp, err = e.dispatchNewListByResourcePager(req)
	case "EventSubscriptionsClient.NewListGlobalByResourceGroupPager":
		resp, err = e.dispatchNewListGlobalByResourceGroupPager(req)
	case "EventSubscriptionsClient.NewListGlobalByResourceGroupForTopicTypePager":
		resp, err = e.dispatchNewListGlobalByResourceGroupForTopicTypePager(req)
	case "EventSubscriptionsClient.NewListGlobalBySubscriptionPager":
		resp, err = e.dispatchNewListGlobalBySubscriptionPager(req)
	case "EventSubscriptionsClient.NewListGlobalBySubscriptionForTopicTypePager":
		resp, err = e.dispatchNewListGlobalBySubscriptionForTopicTypePager(req)
	case "EventSubscriptionsClient.NewListRegionalByResourceGroupPager":
		resp, err = e.dispatchNewListRegionalByResourceGroupPager(req)
	case "EventSubscriptionsClient.NewListRegionalByResourceGroupForTopicTypePager":
		resp, err = e.dispatchNewListRegionalByResourceGroupForTopicTypePager(req)
	case "EventSubscriptionsClient.NewListRegionalBySubscriptionPager":
		resp, err = e.dispatchNewListRegionalBySubscriptionPager(req)
	case "EventSubscriptionsClient.NewListRegionalBySubscriptionForTopicTypePager":
		resp, err = e.dispatchNewListRegionalBySubscriptionForTopicTypePager(req)
	case "EventSubscriptionsClient.BeginUpdate":
		resp, err = e.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := e.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armeventgrid.EventSubscription](req)
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreateOrUpdate(req.Context(), scopeParam, eventSubscriptionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		e.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		e.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		e.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := e.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDelete(req.Context(), scopeParam, eventSubscriptionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		e.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		e.beginDelete.remove(req)
	}

	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), scopeParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSubscription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchGetDeliveryAttributes(req *http.Request) (*http.Response, error) {
	if e.srv.GetDeliveryAttributes == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeliveryAttributes not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getDeliveryAttributes`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetDeliveryAttributes(req.Context(), scopeParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeliveryAttributeListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchGetFullURL(req *http.Request) (*http.Response, error) {
	if e.srv.GetFullURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFullURL not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getFullUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetFullURL(req.Context(), scopeParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSubscriptionFullURL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListByDomainTopicPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByDomainTopicPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDomainTopicPager not implemented")}
	}
	newListByDomainTopicPager := e.newListByDomainTopicPager.get(req)
	if newListByDomainTopicPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topics/(?P<topicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		topicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topicName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListByDomainTopicOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListByDomainTopicOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListByDomainTopicPager(resourceGroupNameParam, domainNameParam, topicNameParam, options)
		newListByDomainTopicPager = &resp
		e.newListByDomainTopicPager.add(req, newListByDomainTopicPager)
		server.PagerResponderInjectNextLinks(newListByDomainTopicPager, req, func(page *armeventgrid.EventSubscriptionsClientListByDomainTopicResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDomainTopicPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByDomainTopicPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDomainTopicPager) {
		e.newListByDomainTopicPager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListByResourcePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourcePager not implemented")}
	}
	newListByResourcePager := e.newListByResourcePager.get(req)
	if newListByResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceTypeName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListByResourceOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListByResourceOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListByResourcePager(resourceGroupNameParam, providerNamespaceParam, resourceTypeNameParam, resourceNameParam, options)
		newListByResourcePager = &resp
		e.newListByResourcePager.add(req, newListByResourcePager)
		server.PagerResponderInjectNextLinks(newListByResourcePager, req, func(page *armeventgrid.EventSubscriptionsClientListByResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourcePager) {
		e.newListByResourcePager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListGlobalByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListGlobalByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGlobalByResourceGroupPager not implemented")}
	}
	newListGlobalByResourceGroupPager := e.newListGlobalByResourceGroupPager.get(req)
	if newListGlobalByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListGlobalByResourceGroupPager(resourceGroupNameParam, options)
		newListGlobalByResourceGroupPager = &resp
		e.newListGlobalByResourceGroupPager.add(req, newListGlobalByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListGlobalByResourceGroupPager, req, func(page *armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGlobalByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListGlobalByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGlobalByResourceGroupPager) {
		e.newListGlobalByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListGlobalByResourceGroupForTopicTypePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListGlobalByResourceGroupForTopicTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGlobalByResourceGroupForTopicTypePager not implemented")}
	}
	newListGlobalByResourceGroupForTopicTypePager := e.newListGlobalByResourceGroupForTopicTypePager.get(req)
	if newListGlobalByResourceGroupForTopicTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/topicTypes/(?P<topicTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topicTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topicTypeName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListGlobalByResourceGroupForTopicTypePager(resourceGroupNameParam, topicTypeNameParam, options)
		newListGlobalByResourceGroupForTopicTypePager = &resp
		e.newListGlobalByResourceGroupForTopicTypePager.add(req, newListGlobalByResourceGroupForTopicTypePager)
		server.PagerResponderInjectNextLinks(newListGlobalByResourceGroupForTopicTypePager, req, func(page *armeventgrid.EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGlobalByResourceGroupForTopicTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListGlobalByResourceGroupForTopicTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGlobalByResourceGroupForTopicTypePager) {
		e.newListGlobalByResourceGroupForTopicTypePager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListGlobalBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListGlobalBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGlobalBySubscriptionPager not implemented")}
	}
	newListGlobalBySubscriptionPager := e.newListGlobalBySubscriptionPager.get(req)
	if newListGlobalBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListGlobalBySubscriptionPager(options)
		newListGlobalBySubscriptionPager = &resp
		e.newListGlobalBySubscriptionPager.add(req, newListGlobalBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListGlobalBySubscriptionPager, req, func(page *armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGlobalBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListGlobalBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGlobalBySubscriptionPager) {
		e.newListGlobalBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListGlobalBySubscriptionForTopicTypePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListGlobalBySubscriptionForTopicTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGlobalBySubscriptionForTopicTypePager not implemented")}
	}
	newListGlobalBySubscriptionForTopicTypePager := e.newListGlobalBySubscriptionForTopicTypePager.get(req)
	if newListGlobalBySubscriptionForTopicTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/topicTypes/(?P<topicTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		topicTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topicTypeName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListGlobalBySubscriptionForTopicTypePager(topicTypeNameParam, options)
		newListGlobalBySubscriptionForTopicTypePager = &resp
		e.newListGlobalBySubscriptionForTopicTypePager.add(req, newListGlobalBySubscriptionForTopicTypePager)
		server.PagerResponderInjectNextLinks(newListGlobalBySubscriptionForTopicTypePager, req, func(page *armeventgrid.EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGlobalBySubscriptionForTopicTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListGlobalBySubscriptionForTopicTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGlobalBySubscriptionForTopicTypePager) {
		e.newListGlobalBySubscriptionForTopicTypePager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListRegionalByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListRegionalByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListRegionalByResourceGroupPager not implemented")}
	}
	newListRegionalByResourceGroupPager := e.newListRegionalByResourceGroupPager.get(req)
	if newListRegionalByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListRegionalByResourceGroupPager(resourceGroupNameParam, locationParam, options)
		newListRegionalByResourceGroupPager = &resp
		e.newListRegionalByResourceGroupPager.add(req, newListRegionalByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListRegionalByResourceGroupPager, req, func(page *armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListRegionalByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListRegionalByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListRegionalByResourceGroupPager) {
		e.newListRegionalByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListRegionalByResourceGroupForTopicTypePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListRegionalByResourceGroupForTopicTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListRegionalByResourceGroupForTopicTypePager not implemented")}
	}
	newListRegionalByResourceGroupForTopicTypePager := e.newListRegionalByResourceGroupForTopicTypePager.get(req)
	if newListRegionalByResourceGroupForTopicTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topicTypes/(?P<topicTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		topicTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topicTypeName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListRegionalByResourceGroupForTopicTypePager(resourceGroupNameParam, locationParam, topicTypeNameParam, options)
		newListRegionalByResourceGroupForTopicTypePager = &resp
		e.newListRegionalByResourceGroupForTopicTypePager.add(req, newListRegionalByResourceGroupForTopicTypePager)
		server.PagerResponderInjectNextLinks(newListRegionalByResourceGroupForTopicTypePager, req, func(page *armeventgrid.EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListRegionalByResourceGroupForTopicTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListRegionalByResourceGroupForTopicTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListRegionalByResourceGroupForTopicTypePager) {
		e.newListRegionalByResourceGroupForTopicTypePager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListRegionalBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListRegionalBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListRegionalBySubscriptionPager not implemented")}
	}
	newListRegionalBySubscriptionPager := e.newListRegionalBySubscriptionPager.get(req)
	if newListRegionalBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListRegionalBySubscriptionPager(locationParam, options)
		newListRegionalBySubscriptionPager = &resp
		e.newListRegionalBySubscriptionPager.add(req, newListRegionalBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListRegionalBySubscriptionPager, req, func(page *armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListRegionalBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListRegionalBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListRegionalBySubscriptionPager) {
		e.newListRegionalBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchNewListRegionalBySubscriptionForTopicTypePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListRegionalBySubscriptionForTopicTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListRegionalBySubscriptionForTopicTypePager not implemented")}
	}
	newListRegionalBySubscriptionForTopicTypePager := e.newListRegionalBySubscriptionForTopicTypePager.get(req)
	if newListRegionalBySubscriptionForTopicTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topicTypes/(?P<topicTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		topicTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topicTypeName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := e.srv.NewListRegionalBySubscriptionForTopicTypePager(locationParam, topicTypeNameParam, options)
		newListRegionalBySubscriptionForTopicTypePager = &resp
		e.newListRegionalBySubscriptionForTopicTypePager.add(req, newListRegionalBySubscriptionForTopicTypePager)
		server.PagerResponderInjectNextLinks(newListRegionalBySubscriptionForTopicTypePager, req, func(page *armeventgrid.EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListRegionalBySubscriptionForTopicTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListRegionalBySubscriptionForTopicTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListRegionalBySubscriptionForTopicTypePager) {
		e.newListRegionalBySubscriptionForTopicTypePager.remove(req)
	}
	return resp, nil
}

func (e *EventSubscriptionsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := e.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armeventgrid.EventSubscriptionUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginUpdate(req.Context(), scopeParam, eventSubscriptionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		e.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		e.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		e.beginUpdate.remove(req)
	}

	return resp, nil
}
